/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.spring.factories.resolvers.AbstractTypeResolver;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

abstract class AbstractProxiedTypeResolver
extends AbstractTypeResolver {
    @NonNls
    protected static final String PROXY_CLASS_FLAG_PROPERTY_NAME = "proxyTargetClass";
    @NonNls
    protected static final String OPTIMIZE_PROPERTY_NAME = "optimize";

    AbstractProxiedTypeResolver() {
    }

    @NotNull
    protected static Set<PsiClass> getAllInterfaces(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/spring/factories/resolvers/AbstractProxiedTypeResolver", "getAllInterfaces"));
        }
        HashSet<PsiClass> interfaces = new HashSet<PsiClass>();
        if (psiType instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            if (psiClass == null || psiClass.isInterface()) {
                Set<PsiClass> set = Collections.singleton(psiClass);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/AbstractProxiedTypeResolver", "getAllInterfaces"));
                }
                return set;
            }
            while (psiClass != null) {
                ContainerUtil.addAll(interfaces, (Object[])psiClass.getInterfaces());
                psiClass = psiClass.getSuperClass();
            }
        }
        HashSet<PsiClass> hashSet = interfaces;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/AbstractProxiedTypeResolver", "getAllInterfaces"));
        }
        return hashSet;
    }

    @NotNull
    protected static Set<String> getAllInterfaceNames(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/spring/factories/resolvers/AbstractProxiedTypeResolver", "getAllInterfaceNames"));
        }
        Set<PsiClass> interfaces = AbstractProxiedTypeResolver.getAllInterfaces(type);
        HashSet<String> names = new HashSet<String>(interfaces.size());
        for (PsiClass anInterface : interfaces) {
            names.add(anInterface.getQualifiedName());
        }
        HashSet<String> hashSet = names;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/AbstractProxiedTypeResolver", "getAllInterfaceNames"));
        }
        return hashSet;
    }

    protected static boolean isCglibExplicitlyEnabled(@NotNull SpringBean context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/factories/resolvers/AbstractProxiedTypeResolver", "isCglibExplicitlyEnabled"));
        }
        return AbstractProxiedTypeResolver.isBooleanPropertySetAndTrue(context, PROXY_CLASS_FLAG_PROPERTY_NAME) || AbstractProxiedTypeResolver.isBooleanPropertySetAndTrue(context, OPTIMIZE_PROPERTY_NAME);
    }
}

