/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.generate;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringGenerateTemplatesHolder
extends ArrayList<Pair<PsiElement, Factory<Template>>> {
    private final Project myProject;

    public SpringGenerateTemplatesHolder(Project project) {
        this.myProject = project;
    }

    public void addTemplateFactory(PsiElement element, Factory<Template> template) {
        this.add(Pair.create((Object)element, template));
    }

    public void runTemplates() {
        TemplateManager manager = TemplateManager.getInstance((Project)this.myProject);
        this.runTemplates(manager, 0);
    }

    private void runTemplates(final TemplateManager manager, final int index) {
        if (index >= this.size()) {
            return;
        }
        new WriteCommandAction(this.myProject, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/model/actions/generate/SpringGenerateTemplatesHolder$1", "run"));
                }
                Pair pair = (Pair)SpringGenerateTemplatesHolder.this.get(index);
                Editor editor = SpringGenerateTemplatesHolder.this.getEditor((PsiElement)pair.getFirst());
                if (editor != null) {
                    Template template;
                    PsiDocumentManager.getInstance((Project)SpringGenerateTemplatesHolder.this.myProject).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                    Factory factory = (Factory)pair.getSecond();
                    if (factory != null && (template = (Template)factory.create()) != null) {
                        manager.startTemplate(editor, template, (TemplateEditingListener)new TemplateEditingAdapter(){

                            public void templateFinished(Template template, boolean brokenOff) {
                                if (index + 1 < SpringGenerateTemplatesHolder.this.size()) {
                                    ApplicationManager.getApplication().invokeLater(() -> SpringGenerateTemplatesHolder.this.runTemplates(manager, index + 1));
                                }
                            }
                        });
                    }
                }
            }
        }.execute();
    }

    @Nullable
    private Editor getEditor(PsiElement element) {
        VirtualFile virtualFile;
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null && (virtualFile = psiFile.getVirtualFile()) != null) {
            TextRange range = element.getTextRange();
            int textOffset = range.getStartOffset();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, virtualFile, textOffset);
            return FileEditorManager.getInstance((Project)this.myProject).openTextEditor(descriptor, true);
        }
        return null;
    }
}

