/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.config;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.facet.validation.SpringProgrammaticConfigurationCollector;
import com.intellij.spring.model.highlighting.config.SetupProgrammaticContextFix;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringFacetProgrammaticInspection
extends BaseJavaLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/model/highlighting/config/SpringFacetProgrammaticInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/highlighting/config/SpringFacetProgrammaticInspection", "checkFile"));
        }
        if (!ApplicationManager.getApplication().isInternal()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Project project = manager.getProject();
        if (!SpringLibraryUtil.hasSpringLibrary((Project)project)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SpringProgrammaticConfigurationCollector collector = new SpringProgrammaticConfigurationCollector(project);
        collector.collect((ProgressIndicator)new EmptyProgressIndicator(), GlobalSearchScope.fileScope((PsiFile)file));
        List<PsiElement> results = collector.getResults();
        if (results.isEmpty()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        boolean hasSpringFacet = SpringCommonUtils.hasSpringFacet((Module)module);
        SmartList problems = new SmartList();
        for (PsiElement element : results) {
            SetupProgrammaticContextFix fix = hasSpringFacet ? new SetupProgrammaticContextFix(element) : null;
            problems.add(manager.createProblemDescriptor(element, "Programmatic Spring context", (LocalQuickFix)fix, ProblemHighlightType.WEAK_WARNING, isOnTheFly));
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringFacetProgrammaticInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/config/SpringFacetProgrammaticInspection", "getShortName"));
        }
        return "SpringFacetProgrammaticInspection";
    }
}

