/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam;

import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.spring.model.aliasFor.SpringAliasFor;
import com.intellij.spring.model.aliasFor.SpringAliasForUtils;
import com.intellij.spring.model.events.jam.CustomSpringEventListener;
import com.intellij.spring.model.events.jam.SpringJamEventListener;
import com.intellij.spring.model.extensions.netflix.EnableFeignClients;
import com.intellij.spring.model.extensions.netflix.FeignClient;
import com.intellij.spring.model.jam.SpringOrder;
import com.intellij.spring.model.jam.SpringSemContributorUtil;
import com.intellij.spring.model.jam.componentScan.CustomJamComponentScan;
import com.intellij.spring.model.jam.contexts.CustomContextJavaBean;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.javaConfig.JavaConfigConfiguration;
import com.intellij.spring.model.jam.lookup.SpringLookupInjection;
import com.intellij.spring.model.jam.profile.CustomContextProfile;
import com.intellij.spring.model.jam.profile.SpringJamProfile;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringCdiNamed;
import com.intellij.spring.model.jam.stereotype.SpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.model.jam.stereotype.SpringImport;
import com.intellij.spring.model.jam.stereotype.SpringImportResource;
import com.intellij.spring.model.jam.stereotype.SpringJamComponentScan;
import com.intellij.spring.model.jam.stereotype.SpringJamComponentScans;
import com.intellij.spring.model.jam.stereotype.SpringJamPropertySource;
import com.intellij.spring.model.jam.stereotype.SpringManagedBean;
import com.intellij.spring.model.jam.stereotype.SpringPropertySources;
import com.intellij.spring.model.jam.stereotype.SpringRepository;
import com.intellij.spring.model.jam.stereotype.SpringService;
import com.intellij.spring.model.jam.testContexts.CustomContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextHierarchy;
import com.intellij.spring.model.jam.testContexts.SpringTransactionConfiguration;
import com.intellij.spring.model.jam.testContexts.dirtiesContexts.SpringTestingDirtiesContext;
import com.intellij.spring.model.jam.testContexts.jdbc.SpringTestingSql;
import com.intellij.spring.model.jam.testContexts.jdbc.SpringTestingSqlConfig;
import com.intellij.spring.model.jam.testContexts.profiles.SpringCustomActiveProfiles;
import com.intellij.spring.model.jam.testContexts.profiles.SpringJamActiveProfiles;
import com.intellij.spring.model.jam.testContexts.propertySources.CustomTestPropertySource;
import com.intellij.spring.model.jam.testContexts.propertySources.SpringTestPropertySource;
import com.intellij.spring.model.jam.transaction.SpringTransactionalComponent;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.ultimate.UltimateVerifier;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import java.util.Collection;
import java.util.Collections;

public class SpringSemContributor
extends SemContributor {
    private final SemService mySemService;

    public SpringSemContributor(SemService semService, UltimateVerifier verifier) {
        this.mySemService = semService;
        PluginVerifier.verifyUltimatePlugin(verifier);
    }

    public void registerSemProviders(SemRegistrar registrar) {
        PsiClassPattern nonAnnoClass = (PsiClassPattern)PsiJavaPatterns.psiClass().nonAnnotationType().withoutModifiers(new String[]{"private"});
        PsiClassPattern classPattern = (PsiClassPattern)PsiJavaPatterns.psiClass().withoutModifiers(new String[]{"private"});
        SpringComponent.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.stereotype.Component"));
        this.registerConfigurations(registrar);
        this.registerServices(registrar, nonAnnoClass);
        this.registerControllers(registrar, nonAnnoClass);
        this.registerRepositories(registrar, nonAnnoClass);
        this.registerProfiles(registrar);
        this.registerActiveProfiles(registrar);
        this.registerCustomComponents(registrar, nonAnnoClass);
        this.registerCustomContextConfigurations(registrar, nonAnnoClass);
        this.registerCustomComponentScans(registrar, nonAnnoClass);
        this.registerCustomTestingPropertySources(registrar, nonAnnoClass);
        SpringCdiNamed.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("javax.inject.Named"));
        this.registerContextJavaBeans(registrar);
        this.registerEventListeners(registrar);
        SpringAliasFor.METHOD_META.register(registrar, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().constructor(false).withModifiers(new String[]{"public"})).withAnnotation("org.springframework.core.annotation.AliasFor"));
        SpringOrder.CLASS_META.register(registrar, (ElementPattern)classPattern.withAnnotation("org.springframework.core.annotation.Order"));
        SpringOrder.FIELD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiField().withAnnotation("org.springframework.core.annotation.Order"));
        SpringOrder.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("org.springframework.core.annotation.Order"));
        SpringImport.META.register(registrar, (ElementPattern)classPattern.withAnnotation("org.springframework.context.annotation.Import"));
        SpringImportResource.META.register(registrar, (ElementPattern)classPattern.withAnnotation("org.springframework.context.annotation.ImportResource"));
        SpringJamComponentScan.META.register(registrar, (ElementPattern)classPattern.withAnnotation("org.springframework.context.annotation.ComponentScan"));
        registrar.registerSemElementProvider(SpringJamComponentScan.REPEATABLE_ANNO_JAM_KEY, (ElementPattern)PsiJavaPatterns.psiAnnotation().qName("org.springframework.context.annotation.ComponentScan"), annotation -> new SpringJamComponentScan(annotation));
        SpringJamComponentScans.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.context.annotation.ComponentScans"));
        SpringJamPropertySource.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.context.annotation.PropertySource"));
        SpringPropertySources.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.context.annotation.PropertySources"));
        JavaConfigConfiguration.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.config.java.annotation.Configuration"));
        SpringContextConfiguration.META.register(registrar, (ElementPattern)classPattern.withAnnotation("org.springframework.test.context.ContextConfiguration"));
        SpringContextHierarchy.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.test.context.ContextHierarchy"));
        SpringTestPropertySource.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.test.context.TestPropertySource"));
        SpringTestingSql.CLASS_META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.test.context.jdbc.Sql"));
        SpringTestingSql.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().constructor(false).withAnnotation("org.springframework.test.context.jdbc.Sql"));
        SpringTestingDirtiesContext.CLASS_META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.test.annotation.DirtiesContext"));
        SpringTestingDirtiesContext.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().constructor(false).withAnnotation("org.springframework.test.annotation.DirtiesContext"));
        SpringTestingSqlConfig.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.test.context.jdbc.SqlConfig"));
        SpringTransactionConfiguration.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.test.context.transaction.TransactionConfiguration"));
        SpringTransactionalComponent.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.transaction.annotation.Transactional"));
        SpringManagedBean.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("javax.annotation.ManagedBean"));
        SpringLookupInjection.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().constructor(false).withAnnotation("org.springframework.beans.factory.annotation.Lookup"));
        EnableFeignClients.META.register(registrar, (ElementPattern)classPattern.withAnnotation("org.springframework.cloud.netflix.feign.EnableFeignClients"));
        FeignClient.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.cloud.netflix.feign.FeignClient"));
    }

    private void registerEventListeners(SemRegistrar registrar) {
        PsiMethodPattern methodPattern = (PsiMethodPattern)PsiJavaPatterns.psiMethod().constructor(false).withModifiers(new String[]{"public"});
        SpringJamEventListener.METHOD_META.register(registrar, (ElementPattern)methodPattern.withAnnotation("org.springframework.context.event.EventListener"));
        this.registerCustomEventListeners(registrar, methodPattern);
    }

    private void registerProfiles(SemRegistrar registrar) {
        SpringJamProfile.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotation("org.springframework.context.annotation.Profile"));
        this.registerCustomProfiles(registrar, (ElementPattern<? extends PsiMember>)PsiJavaPatterns.psiClass().nonAnnotationType().withoutModifiers(new String[]{"private"}));
        this.registerCustomProfiles(registrar, (ElementPattern<? extends PsiMember>)PsiJavaPatterns.psiMethod().constructor(false).withModifiers(new String[]{"public"}));
    }

    private void registerActiveProfiles(SemRegistrar registrar) {
        SpringJamActiveProfiles.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.test.context.ActiveProfiles"));
        this.registerCustomActiveProfiles(registrar, (ElementPattern<? extends PsiMember>)PsiJavaPatterns.psiClass().nonAnnotationType().withoutModifiers(new String[]{"private"}));
    }

    private void registerContextJavaBeans(SemRegistrar registrar) {
        PsiMethodPattern beanMethodPattern = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withoutModifiers(new String[]{"private"})).constructor(false);
        ContextJavaBean.METHOD_META.register(registrar, (ElementPattern)beanMethodPattern.withAnnotation("org.springframework.context.annotation.Bean"));
        this.registerCustomContextJavaBean(registrar, (PsiMethodPattern)beanMethodPattern.andNot((ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("org.springframework.context.annotation.Bean")));
    }

    private void registerCustomComponents(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)psiClassPattern, (SemKey)CustomSpringComponent.META_KEY, (SemKey)CustomSpringComponent.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction((SemKey)CustomSpringComponent.JAM_KEY, CustomSpringComponent.class, SpringSemContributor.getUserDefinedCustomAnnotations(), pair -> new CustomSpringComponent((String)pair.first, (PsiClass)pair.second), (Consumer)SpringSemContributorUtil.createStereotypeConsumer()));
    }

    private void registerCustomComponentScans(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)psiClassPattern, CustomJamComponentScan.META_KEY, CustomJamComponentScan.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(CustomJamComponentScan.JAM_KEY, CustomJamComponentScan.class, (Function)SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.context.annotation.ComponentScan"), pair -> new CustomJamComponentScan((String)pair.first, (PsiClass)pair.second), null, (NotNullFunction)SpringAliasForUtils.getAnnotationMetaProducer(CustomJamComponentScan.JAM_ANNO_META_KEY, (JamMemberMeta[])new JamMemberMeta[]{SpringJamComponentScan.META})));
    }

    private void registerCustomContextConfigurations(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)psiClassPattern, (SemKey)CustomContextConfiguration.META_KEY, (SemKey)CustomContextConfiguration.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction((SemKey)CustomContextConfiguration.JAM_KEY, CustomContextConfiguration.class, (Function)SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.test.context.ContextConfiguration", (boolean)true), pair -> new CustomContextConfiguration((String)pair.first, (PsiClass)pair.second), null, (NotNullFunction)SpringAliasForUtils.getAnnotationMetaProducer((SemKey)CustomContextConfiguration.JAM_ANNO_META_KEY, (JamMemberMeta[])new JamMemberMeta[]{SpringContextConfiguration.META})));
    }

    private void registerCustomTestingPropertySources(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)psiClassPattern, (SemKey)CustomTestPropertySource.META_KEY, (SemKey)CustomTestPropertySource.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction((SemKey)CustomTestPropertySource.JAM_KEY, CustomTestPropertySource.class, (Function)SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.test.context.TestPropertySource", (boolean)true), pair -> new CustomTestPropertySource((String)pair.first, (PsiClass)pair.second), null, (NotNullFunction)SpringAliasForUtils.getAnnotationMetaProducer((SemKey)CustomTestPropertySource.JAM_ANNO_META_KEY, (JamMemberMeta[])new JamMemberMeta[]{SpringTestPropertySource.META})));
    }

    private void registerCustomEventListeners(SemRegistrar registrar, PsiMethodPattern psiMethodPattern) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)psiMethodPattern, CustomSpringEventListener.META_KEY, CustomSpringEventListener.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(CustomSpringEventListener.JAM_KEY, CustomSpringEventListener.class, (Function)SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.context.event.EventListener", (boolean)true), pair -> new CustomSpringEventListener((String)pair.first, (PsiMethod)pair.second), null));
    }

    private void registerCustomProfiles(SemRegistrar registrar, ElementPattern<? extends PsiMember> pattern) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, pattern, (SemKey)CustomContextProfile.META_KEY, (SemKey)CustomContextProfile.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction((SemKey)CustomContextProfile.JAM_KEY, CustomContextProfile.class, (Function)SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.context.annotation.Profile", (boolean)true), pair -> new CustomContextProfile((String)pair.first, (PsiMember)pair.second), null));
    }

    private void registerCustomActiveProfiles(SemRegistrar registrar, ElementPattern<? extends PsiMember> pattern) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, pattern, (SemKey)SpringCustomActiveProfiles.META_KEY, (SemKey)SpringCustomActiveProfiles.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction((SemKey)SpringCustomActiveProfiles.JAM_KEY, SpringCustomActiveProfiles.class, (Function)SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.test.context.ActiveProfiles", (boolean)true), pair -> new SpringCustomActiveProfiles((String)pair.first, (PsiMember)pair.second), null));
    }

    private void registerCustomContextJavaBean(SemRegistrar registrar, PsiMethodPattern pattern) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)pattern, CustomContextJavaBean.META_KEY, CustomContextJavaBean.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(CustomContextJavaBean.JAM_KEY, CustomContextJavaBean.class, (Function)SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.context.annotation.Bean"), pair -> new CustomContextJavaBean((String)pair.first, (PsiMethod)pair.second), null, (NotNullFunction)SpringAliasForUtils.getAnnotationMetaProducer(CustomContextJavaBean.JAM_ANNO_META_KEY, (JamMemberMeta[])new JamMemberMeta[]{ContextJavaBean.METHOD_META})));
    }

    private void registerConfigurations(SemRegistrar registrar) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)PsiJavaPatterns.psiClass().nonAnnotationType().withoutModifiers(new String[]{"abstract"}), (SemKey)SpringConfiguration.META_KEY, (SemKey)SpringConfiguration.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction((SemKey)SpringConfiguration.JAM_KEY, SpringConfiguration.class, (Function)SpringConfiguration.getAnnotations(), pair -> new SpringConfiguration((String)pair.first, (PsiClass)pair.second), (Consumer)SpringSemContributorUtil.createStereotypeConsumer()));
    }

    private void registerControllers(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)psiClassPattern, (SemKey)SpringController.META_KEY, (SemKey)SpringController.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction((SemKey)SpringController.JAM_KEY, SpringController.class, (Function)SpringController.getControllerAnnotations(), pair -> new SpringController((String)pair.first, (PsiClass)pair.second), (Consumer)SpringSemContributorUtil.createStereotypeConsumer()));
    }

    private void registerRepositories(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)psiClassPattern, SpringRepository.META_KEY, SpringRepository.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(SpringRepository.JAM_KEY, SpringRepository.class, SpringRepository.getRepositoryAnnotations(), pair -> new SpringRepository((String)pair.first, (PsiClass)pair.second), (Consumer)SpringSemContributorUtil.createStereotypeConsumer()));
    }

    private void registerServices(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)psiClassPattern, (SemKey)SpringService.META_KEY, (SemKey)SpringService.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction((SemKey)SpringService.JAM_KEY, SpringService.class, (Function)SpringService.getServiceAnnotations(), pair -> new SpringService((String)pair.first, (PsiClass)pair.second), (Consumer)SpringSemContributorUtil.createStereotypeConsumer()));
    }

    private static Function<Module, Collection<String>> getUserDefinedCustomAnnotations() {
        return module -> module == null ? Collections.emptySet() : JamAnnotationTypeUtil.getInstance((Module)module).getUserDefinedCustomComponentAnnotations();
    }
}

