/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.beans.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.ResolvedConstructorArgs;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.ConstructorArgIndexConverterImpl;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.values.SpringValueConvertersRegistry;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.model.xml.beans.impl.SpringInjectionImpl;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class ConstructorArgImpl
extends SpringInjectionImpl
implements ConstructorArg {
    public boolean isAssignable(@NotNull PsiType requiredType) {
        PsiType type;
        if (requiredType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredType", "com/intellij/spring/model/xml/beans/impl/ConstructorArgImpl", "isAssignable"));
        }
        if (DomUtil.hasXml((DomElement)this.getType()) && (type = (PsiType)this.getType().getValue()) != null) {
            return requiredType.isAssignableFrom(type);
        }
        if (DomUtil.hasXml((DomElement)this.getValueAttr())) {
            return ConstructorArgImpl.isAssignableFrom(requiredType, (GenericDomValue)this.getValueAttr());
        }
        if (DomUtil.hasXml((DomElement)this.getRefAttr())) {
            return ConstructorArgImpl.isAssignableFrom(requiredType, (SpringBeanPointer)this.getRefAttr().getValue());
        }
        if (DomUtil.hasXml((DomElement)this.getValue())) {
            type = (PsiType)this.getValue().getType().getValue();
            if (type != null) {
                return requiredType.isAssignableFrom(type);
            }
            return ConstructorArgImpl.isAssignableFrom(requiredType, (GenericDomValue)this.getValue());
        }
        if (DomUtil.hasXml((DomElement)this.getBean())) {
            return ConstructorArgImpl.isAssignableFrom(requiredType, BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)this.getBean()));
        }
        if (DomUtil.hasXml((DomElement)this.getRef())) {
            SpringRef springRef = this.getRef();
            SpringBeanPointer beanPointer = (SpringBeanPointer)springRef.getBean().getValue();
            if (beanPointer != null) {
                if (ConstructorArgImpl.isAssignableFrom(requiredType, beanPointer)) {
                    return true;
                }
            } else {
                SpringBeanPointer localPointer = (SpringBeanPointer)springRef.getLocal().getValue();
                if (localPointer != null) {
                    return ConstructorArgImpl.isAssignableFrom(requiredType, localPointer);
                }
                SpringBeanPointer parentPointer = (SpringBeanPointer)springRef.getParentAttr().getValue();
                if (parentPointer != null) {
                    return ConstructorArgImpl.isAssignableFrom(requiredType, parentPointer);
                }
            }
            return false;
        }
        if (DomUtil.hasXml((DomElement)this.getIdref())) {
            return this.isAssignableFrom(requiredType, String.class);
        }
        if (DomUtil.hasXml((DomElement)this.getList())) {
            return requiredType instanceof PsiEllipsisType || this.isAssignableFrom(requiredType, List.class);
        }
        if (DomUtil.hasXml((DomElement)this.getMap())) {
            return this.isAssignableFrom(requiredType, Map.class);
        }
        if (DomUtil.hasXml((DomElement)this.getSet())) {
            return requiredType instanceof PsiEllipsisType || this.isAssignableFrom(requiredType, Set.class);
        }
        if (DomUtil.hasXml((DomElement)this.getArray())) {
            return requiredType instanceof PsiEllipsisType || requiredType.isAssignableFrom((PsiType)SpringPropertyUtils.getArrayType((ListOrSet)this.getArray()));
        }
        if (DomUtil.hasXml((DomElement)this.getProps())) {
            return this.isAssignableFrom(requiredType, Properties.class);
        }
        if (DomUtil.hasXml((DomElement)this.getNull())) {
            return requiredType.isAssignableFrom((PsiType)PsiType.NULL);
        }
        return false;
    }

    private static boolean isAssignableFrom(PsiType requiredType, GenericDomValue value) {
        String stringValue;
        PsiClass resolve;
        if (requiredType instanceof PsiClassType && "java.lang.String".equals(requiredType.getCanonicalText())) {
            return true;
        }
        if (requiredType instanceof PsiClassType && (resolve = ((PsiClassType)requiredType).resolve()) != null && "java.lang.Class".equals(resolve.getQualifiedName()) && StringUtil.isNotEmpty((String)(stringValue = value.getStringValue())) && JavaPsiFacade.getInstance((Project)resolve.getProject()).findClass(stringValue, GlobalSearchScope.allScope((Project)resolve.getProject())) != null) {
            return true;
        }
        Converter converter = SpringValueConvertersRegistry.getInstance().getConverter(value, requiredType);
        return converter != null && converter.fromString(value.getStringValue(), ConvertContextFactory.createConvertContext((DomInvocationHandler)DomManagerImpl.getDomInvocationHandler((DomElement)value))) != null;
    }

    private static boolean isAssignableFrom(PsiType type, SpringBeanPointer beanPointer) {
        PsiType[] psiTypes;
        if (beanPointer == null || !(type instanceof PsiClassType)) {
            return false;
        }
        type = ((PsiClassType)type).rawType();
        for (PsiType psiType : psiTypes = beanPointer.getEffectiveBeanTypes()) {
            if (!type.isAssignableFrom(psiType)) continue;
            return true;
        }
        return false;
    }

    private boolean isAssignableFrom(PsiType type, Class clazz) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getManager().getProject());
        PsiClass psiClass = facade.findClass(clazz.getCanonicalName(), this.getResolveScope());
        return psiClass != null && facade.getElementFactory().createType(psiClass).isAssignableFrom(type);
    }

    @NotNull
    public List<PsiType> getRequiredTypes() {
        PsiType type = (PsiType)this.getType().getValue();
        if (type != null) {
            List<PsiType> list = Collections.singletonList(type);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/ConstructorArgImpl", "getRequiredTypes"));
            }
            return list;
        }
        SpringBean springBean = (SpringBean)this.getParent();
        assert (springBean != null);
        GenericAttributeValue index = this.getIndex();
        if (index.getValue() != null) {
            Set<PsiParameter> resolvedParameters = ConstructorArgIndexConverterImpl.multiResolve((GenericDomValue<Integer>)index, springBean);
            if (resolvedParameters.size() > 0) {
                List list = ContainerUtil.map(resolvedParameters, PsiVariable::getType);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/ConstructorArgImpl", "getRequiredTypes"));
                }
                return list;
            }
            PsiParameter parameter = ConstructorArgIndexConverterImpl.resolve((GenericDomValue<Integer>)index, springBean);
            List<PsiType> list = parameter == null ? Collections.emptyList() : Collections.singletonList(parameter.getType());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/ConstructorArgImpl", "getRequiredTypes"));
            }
            return list;
        }
        ResolvedConstructorArgs resolvedArgs = springBean.getResolvedConstructorArgs();
        String nameAttr = this.getNameAttr().getStringValue();
        if (nameAttr != null && resolvedArgs.getResolvedMethod() == null) {
            ArrayList<PsiType> types = new ArrayList<PsiType>();
            List psiMethods = resolvedArgs.getCheckedMethods();
            for (PsiMethod method2 : psiMethods) {
                for (PsiParameter psiParameter : method2.getParameterList().getParameters()) {
                    if (!nameAttr.equals(psiParameter.getName())) continue;
                    types.add(psiParameter.getType());
                }
            }
            ArrayList<PsiType> arrayList = types;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/ConstructorArgImpl", "getRequiredTypes"));
            }
            return arrayList;
        }
        List list = ContainerUtil.mapNotNull((Collection)resolvedArgs.getCandidates(), (Function)((NullableFunction)method -> {
            PsiParameter parameter = (PsiParameter)resolvedArgs.getResolvedArgs(method).get((Object)this);
            return parameter != null ? parameter.getType() : null;
        }));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/ConstructorArgImpl", "getRequiredTypes"));
        }
        return list;
    }

    public int hashCode() {
        Integer value = (Integer)this.getIndex().getValue();
        return value == null ? 0 : value.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConstructorArg)) {
            return false;
        }
        ConstructorArg that = (ConstructorArg)obj;
        XmlTag xmlTag = this.getXmlTag();
        if (xmlTag != null && xmlTag.equals(that.getXmlTag())) {
            return true;
        }
        Integer index = (Integer)this.getIndex().getValue();
        return index != null && Comparing.equal((Object)index, (Object)that.getIndex().getValue());
    }
}

