/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.refactoring;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ProjectContentScope
extends GlobalSearchScope {
    private final ProjectFileIndex myFileIndex;

    public ProjectContentScope(Project project) {
        super(project);
        this.myFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/refactoring/ProjectContentScope", "contains"));
        }
        return this.myFileIndex.isInContent(file);
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/spring/refactoring/ProjectContentScope", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/spring/refactoring/ProjectContentScope", "compare"));
        }
        return 0;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/spring/refactoring/ProjectContentScope", "isSearchInModuleContent"));
        }
        return true;
    }

    public boolean isSearchInLibraries() {
        return false;
    }

    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        return ModuleManager.getInstance((Project)((Project)ObjectUtils.assertNotNull((Object)this.getProject()))).getUnloadedModuleDescriptions();
    }
}

