/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.EventDispatcher;
import com.intellij.xdebugger.XSourcePosition;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.EventListener;
import org.intellij.plugins.xsltDebugger.impl.XsltBreakpointHandler;
import org.intellij.plugins.xsltDebugger.impl.XsltDebugProcess;
import org.intellij.plugins.xsltDebugger.rt.engine.Breakpoint;
import org.intellij.plugins.xsltDebugger.rt.engine.BreakpointManager;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.intellij.plugins.xsltDebugger.rt.engine.DebuggerStoppedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltDebuggerSession
implements Disposable {
    private static final Key<XsltDebuggerSession> DEBUGGER_SESSION = Key.create((String)"DEBUGGER_SESSION");
    private final Project myProject;
    private final ProcessHandler myProcess;
    private final Debugger myClient;
    private final EventDispatcher<Listener> myEventDispatcher = EventDispatcher.create(Listener.class);
    private Breakpoint myTempBreakpoint;
    private volatile Debugger.State myState;
    private boolean myClosed;

    private XsltDebuggerSession(Project project, ProcessHandler process, Debugger client) {
        this.myProject = project;
        this.myProcess = process;
        this.myClient = client;
        Disposer.register((Disposable)XsltDebugProcess.getInstance(process), (Disposable)this);
    }

    public void start() {
        this.myClient.start();
        this.myState = Debugger.State.RUNNING;
        BreakpointManager breakpointManager = this.myClient.getBreakpointManager();
        Listener multicaster = (Listener)this.myEventDispatcher.getMulticaster();
        try {
            if (!this.myClient.waitForDebuggee()) {
                multicaster.debuggerStopped();
                return;
            }
            this.myState = Debugger.State.SUSPENDED;
            do {
                if (this.myState == Debugger.State.SUSPENDED) {
                    if (this.myTempBreakpoint != null) {
                        breakpointManager.removeBreakpoint(this.myTempBreakpoint);
                        this.myTempBreakpoint = null;
                    }
                    multicaster.debuggerSuspended();
                    continue;
                }
                if (this.myState == Debugger.State.RUNNING) {
                    multicaster.debuggerResumed();
                    continue;
                }
                if (this.myState == Debugger.State.STOPPED) break;
            } while ((this.myState = this.myClient.waitForStateChange(this.myState)) != null);
            multicaster.debuggerStopped();
        }
        catch (DebuggerStoppedException e) {
            multicaster.debuggerStopped();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RemoteException && e.getCause().getCause() instanceof SocketException) {
                multicaster.debuggerStopped();
                return;
            }
            throw e;
        }
        finally {
            this.myState = Debugger.State.STOPPED;
            this.close();
        }
    }

    public void addListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    public Debugger getClient() {
        return this.myClient;
    }

    public Debugger.State getCurrentState() {
        return this.myState;
    }

    public void pause() {
        this.myClient.pause();
    }

    public void resume() {
        this.myClient.resume();
    }

    public void stop() {
        try {
            this.myClient.stop(false);
        }
        catch (DebuggerStoppedException debuggerStoppedException) {
            // empty catch block
        }
    }

    public void stepOver() {
        this.myClient.step();
    }

    public void stepInto() {
        this.myClient.stepInto();
    }

    public boolean canRunTo(XSourcePosition position) {
        return XsltBreakpointHandler.getActualLineNumber(this.myProject, position) != -1;
    }

    public void runTo(PsiFile file, XSourcePosition position) {
        assert (this.myTempBreakpoint == null);
        int lineNumber = XsltBreakpointHandler.getActualLineNumber(this.myProject, position);
        String uri = XsltBreakpointHandler.getFileURL(file.getVirtualFile());
        this.myTempBreakpoint = this.myClient.getBreakpointManager().setBreakpoint(uri, lineNumber);
        this.resume();
    }

    @Nullable
    public static Editor openLocation(Project project, @NotNull String uri, int lineNumber) {
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "org/intellij/plugins/xsltDebugger/XsltDebuggerSession", "openLocation"));
        }
        try {
            VirtualFile file = VfsUtil.findFileByURL((URL)new URI(uri).toURL());
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, lineNumber, 0);
            descriptor.navigate(true);
            return FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        }
        catch (MalformedURLException | URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized void close() {
        if (this.myClosed) {
            return;
        }
        this.myClosed = true;
        try {
            this.myClient.stop(true);
        }
        catch (DebuggerStoppedException debuggerStoppedException) {
        }
        finally {
            this.myProcess.destroyProcess();
        }
    }

    public void dispose() {
        XsltDebuggerSession.detach(this.myProcess);
    }

    @NotNull
    public static XsltDebuggerSession create(Project project, @NotNull ProcessHandler process, Debugger client) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/intellij/plugins/xsltDebugger/XsltDebuggerSession", "create"));
        }
        XsltDebuggerSession session = new XsltDebuggerSession(project, process, client);
        process.putUserData(DEBUGGER_SESSION, (Object)session);
        XsltDebuggerSession xsltDebuggerSession = session;
        if (xsltDebuggerSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xsltDebugger/XsltDebuggerSession", "create"));
        }
        return xsltDebuggerSession;
    }

    public static XsltDebuggerSession getInstance(@NotNull ProcessHandler process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/intellij/plugins/xsltDebugger/XsltDebuggerSession", "getInstance"));
        }
        return (XsltDebuggerSession)process.getUserData(DEBUGGER_SESSION);
    }

    public static void detach(ProcessHandler processHandler) {
        processHandler.putUserData(DEBUGGER_SESSION, null);
    }

    public static interface Listener
    extends EventListener {
        public void debuggerSuspended();

        public void debuggerResumed();

        public void debuggerStopped();
    }
}

