/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.SortableTreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public abstract class DroolsStructureViewElement
implements StructureViewTreeElement,
SortableTreeElement,
ItemPresentation {
    private final PsiElement myElement;

    public DroolsStructureViewElement(PsiElement element) {
        this.myElement = element;
    }

    public Object getValue() {
        return this.myElement;
    }

    public void navigate(boolean requestFocus) {
        if (this.myElement instanceof NavigationItem) {
            ((NavigationItem)this.myElement).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return this.myElement instanceof NavigationItem && ((NavigationItem)this.myElement).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myElement instanceof NavigationItem && ((NavigationItem)this.myElement).canNavigateToSource();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        DroolsStructureViewElement droolsStructureViewElement = this;
        if (droolsStructureViewElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/structure/DroolsStructureViewElement", "getPresentation"));
        }
        return droolsStructureViewElement;
    }

    @NotNull
    public String getAlphaSortKey() {
        String result = this.myElement instanceof NavigationItem ? ((NavigationItem)this.myElement).getName() : null;
        String string = result == null ? "" : result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/structure/DroolsStructureViewElement", "getAlphaSortKey"));
        }
        return string;
    }

    public PsiElement getRealElement() {
        return this.myElement;
    }
}

