/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.util.DbUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class LengthUnit {
    public static final LengthUnit NONE = new LengthUnit("");
    public static final LengthUnit DIGIT = new LengthUnit("");
    public static final LengthUnit BYTE = new LengthUnit("byte");
    public static final LengthUnit CHAR = new LengthUnit("char");
    @NotNull
    public final String suffix;
    private static final Map<String, LengthUnit> ourPossibleNames = ContainerUtil.immutableMapBuilder().put((Object)"b", (Object)BYTE).put((Object)"byte", (Object)BYTE).put((Object)"bytes", (Object)BYTE).put((Object)"c", (Object)CHAR).put((Object)"char", (Object)CHAR).put((Object)"chars", (Object)CHAR).put((Object)"d", (Object)DIGIT).put((Object)"digit", (Object)DIGIT).put((Object)"digits", (Object)DIGIT).put((Object)"", (Object)NONE).build();

    LengthUnit(@NotNull String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/database/model/LengthUnit", "<init>"));
        }
        this.suffix = suffix;
    }

    @NotNull
    public static LengthUnit of(String str) throws IllegalArgumentException {
        if (str == null) {
            LengthUnit lengthUnit = NONE;
            if (lengthUnit == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/LengthUnit", "of"));
            }
            return lengthUnit;
        }
        String name = str.trim().toLowerCase(Locale.ENGLISH);
        LengthUnit unit = ourPossibleNames.get(name);
        LengthUnit lengthUnit = unit != null ? unit : new LengthUnit(DbUtil.intern2(name));
        if (lengthUnit == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/LengthUnit", "of"));
        }
        return lengthUnit;
    }
}

