/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupportKt;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XNamedTreeNode;
import com.intellij.xdebugger.evaluation.InlineDebuggerHelper;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProviderBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDebuggerEditorsProvider
extends XDebuggerEditorsProviderBase {
    @NotNull
    public FileType getFileType() {
        LanguageFileType languageFileType = JavaScriptSupportLoader.JAVASCRIPT;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/JSDebuggerEditorsProvider", "getFileType"));
        }
        return languageFileType;
    }

    protected PsiFile createExpressionCodeFragment(@NotNull Project project, @NotNull String text, @Nullable PsiElement context, boolean isPhysical) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/JSDebuggerEditorsProvider", "createExpressionCodeFragment"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/javascript/debugger/JSDebuggerEditorsProvider", "createExpressionCodeFragment"));
        }
        return JSElementFactory.createExpressionCodeFragment((Project)project, (CharSequence)text, (PsiElement)context);
    }

    protected PsiElement getContextElement(@NotNull VirtualFile virtualFile, int offset, @NotNull Project project) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/javascript/debugger/JSDebuggerEditorsProvider", "getContextElement"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/JSDebuggerEditorsProvider", "getContextElement"));
        }
        return JavaScriptDebuggerViewSupportKt.getContextElement(virtualFile, offset, project);
    }

    @NotNull
    public InlineDebuggerHelper getInlineDebuggerHelper() {
        MyInlineDebuggerHelper myInlineDebuggerHelper = MyInlineDebuggerHelper.INSTANCE;
        if (myInlineDebuggerHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/JSDebuggerEditorsProvider", "getInlineDebuggerHelper"));
        }
        return myInlineDebuggerHelper;
    }

    private static final class MyInlineDebuggerHelper
    extends InlineDebuggerHelper {
        private static final MyInlineDebuggerHelper INSTANCE = new MyInlineDebuggerHelper();

        private MyInlineDebuggerHelper() {
        }

        public boolean shouldEvaluateChildrenByDefault(XNamedTreeNode node) {
            return false;
        }
    }
}

