/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.browserConnection;

import com.intellij.javascript.debugger.browserConnection.InetAddressService;
import com.intellij.util.PairProcessor;
import gnu.trove.TIntArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PageService {
    private static final PairProcessor<String, String> INSPECTABLE_PREDICATE = (host, path) -> InetAddressService.isLocalHost(host);

    public TIntArrayList filterInspectable(@Nullable String projectId, List<String> hostAndPathPairs) {
        TIntArrayList result = new TIntArrayList(hostAndPathPairs.size() >> 1);
        PairProcessor<String, String> predicate = this.createInspectablePredicate(projectId);
        int n = hostAndPathPairs.size();
        for (int i = 0; i < n; i += 2) {
            if (!predicate.process((Object)hostAndPathPairs.get(i), (Object)hostAndPathPairs.get(i + 1))) continue;
            result.add(i >> 1);
        }
        return result;
    }

    protected PairProcessor<String, String> createInspectablePredicate(@Nullable String projectId) {
        return INSPECTABLE_PREDICATE;
    }
}

