/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.SimilarityIndex;
import com.intellij.openapi.util.text.TableFullException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a(\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016\u001a\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0003H\u0002\u001a1\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\b\b\u0002\u0010\u001e\u001a\u00020\u00012\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0086\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"KEY_SHIFT", "", "MAX_COUNT", "", "MAX_SCORE", "SimilarityIndex", "Lcom/intellij/openapi/util/text/SimilarityIndex;", "input", "", "common", "srcHash", "", "_srcIdx", "dstHash", "_dstIdx", "countOf", "v", "growAt", "idHashBits", "keyOf", "nameScore", "a", "", "b", "pair", "key", "cnt", "similarityScore", "sourceBytes", "destination", "maxScore", "sourceIndex", "Lkotlin/Function0;", "JavaScriptDebugger"})
public final class SimilarityIndexKt {
    private static final int KEY_SHIFT = 32;
    private static final long MAX_COUNT = 0xFFFFFFFFL;
    public static final int MAX_SCORE = 10000;

    @NotNull
    public static final SimilarityIndex SimilarityIndex(@NotNull byte[] input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        SimilarityIndex idx = new SimilarityIndex();
        SimilarityIndex.hash$JavaScriptDebugger$default(idx, input, 0, 0, false, 14, null);
        idx.sort$JavaScriptDebugger();
        return idx;
    }

    public static final int similarityScore(@NotNull byte[] sourceBytes, @NotNull byte[] destination, int maxScore, @NotNull Function0<SimilarityIndex> sourceIndex) {
        Intrinsics.checkParameterIsNotNull((Object)sourceBytes, (String)"sourceBytes");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Intrinsics.checkParameterIsNotNull(sourceIndex, (String)"sourceIndex");
        return Arrays.equals(sourceBytes, destination) ? maxScore : SimilarityIndex.score$default((SimilarityIndex)sourceIndex.invoke(), SimilarityIndexKt.SimilarityIndex(destination), 0, 2, null);
    }

    public static /* bridge */ /* synthetic */ int similarityScore$default(byte[] sourceBytes, byte[] destination, int maxScore, Function0 sourceIndex, int n, Object object) {
        if ((n & 4) != 0) {
            maxScore = 10000;
        }
        Intrinsics.checkParameterIsNotNull((Object)sourceBytes, (String)"sourceBytes");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Intrinsics.checkParameterIsNotNull((Object)sourceIndex, (String)"sourceIndex");
        return Arrays.equals(sourceBytes, destination) ? maxScore : SimilarityIndex.score$default((SimilarityIndex)sourceIndex.invoke(), SimilarityIndexKt.SimilarityIndex(destination), 0, 2, null);
    }

    private static final long common(long[] srcHash, int _srcIdx, long[] dstHash, int _dstIdx) {
        int srcIdx = _srcIdx;
        int dstIdx = _dstIdx;
        if (srcIdx == srcHash.length || dstIdx == dstHash.length) {
            return 0L;
        }
        long common = 0L;
        int srcKey = SimilarityIndexKt.keyOf(srcHash[srcIdx]);
        int dstKey = SimilarityIndexKt.keyOf(dstHash[dstIdx]);
        while (true) {
            if (srcKey == dstKey) {
                common += Math.min(SimilarityIndexKt.countOf(srcHash[srcIdx]), SimilarityIndexKt.countOf(dstHash[dstIdx]));
                if (++srcIdx == srcHash.length) break;
                srcKey = SimilarityIndexKt.keyOf(srcHash[srcIdx]);
                if (++dstIdx == dstHash.length) break;
                dstKey = SimilarityIndexKt.keyOf(dstHash[dstIdx]);
                continue;
            }
            if (srcKey < dstKey) {
                if (++srcIdx == srcHash.length) break;
                srcKey = SimilarityIndexKt.keyOf(srcHash[srcIdx]);
                continue;
            }
            if (++dstIdx == dstHash.length) break;
            dstKey = SimilarityIndexKt.keyOf(dstHash[dstIdx]);
        }
        return common;
    }

    private static final long pair(int key, long cnt) {
        if (0xFFFFFFFFL < cnt) {
            throw (Throwable)new TableFullException(null, 1, null);
        }
        return (long)key << 32 | cnt;
    }

    private static final int growAt(int idHashBits) {
        return (1 << idHashBits) * (idHashBits - 3) / idHashBits;
    }

    private static final int keyOf(long v) {
        return (int)(v >>> 32);
    }

    private static final long countOf(long v) {
        return v & 0xFFFFFFFFL;
    }

    public static final int nameScore(@NotNull String a, @NotNull String b) {
        int fileSim;
        int dirScoreRtl;
        int dirScoreLtr;
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        int aDirLen = StringsKt.lastIndexOf$default((CharSequence)a, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
        int bDirLen = StringsKt.lastIndexOf$default((CharSequence)b, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
        int dirMin = Math.min(aDirLen, bDirLen);
        int dirMax = Math.max(aDirLen, bDirLen);
        if (dirMax == 0) {
            dirScoreLtr = 100;
            dirScoreRtl = 100;
        } else {
            int dirSim;
            for (dirSim = 0; dirSim < dirMin && a.charAt(dirSim) == b.charAt(dirSim); ++dirSim) {
            }
            dirScoreLtr = dirSim * 100 / dirMax;
            if (dirScoreLtr == 100) {
                dirScoreRtl = 100;
            } else {
                for (dirSim = 0; dirSim < dirMin && a.charAt(aDirLen - 1 - dirSim) == b.charAt(bDirLen - 1 - dirSim); ++dirSim) {
                }
                dirScoreRtl = dirSim * 100 / dirMax;
            }
        }
        int fileMin = Math.min(a.length() - aDirLen, b.length() - bDirLen);
        int fileMax = Math.max(a.length() - aDirLen, b.length() - bDirLen);
        for (fileSim = 0; fileSim < fileMin && a.charAt(a.length() - 1 - fileSim) == b.charAt(b.length() - 1 - fileSim); ++fileSim) {
        }
        int fileScore = fileSim * 100 / fileMax;
        return ((dirScoreLtr + dirScoreRtl) * 25 + fileScore * 50) / 100;
    }

    public static final /* synthetic */ int access$keyOf(long v) {
        return SimilarityIndexKt.keyOf(v);
    }

    public static final /* synthetic */ long access$countOf(long v) {
        return SimilarityIndexKt.countOf(v);
    }

    public static final /* synthetic */ long access$pair(int key, long cnt) {
        return SimilarityIndexKt.pair(key, cnt);
    }

    public static final /* synthetic */ int access$growAt(int idHashBits) {
        return SimilarityIndexKt.growAt(idHashBits);
    }

    public static final /* synthetic */ long access$common(@NotNull long[] srcHash, int _srcIdx, @NotNull long[] dstHash, int _dstIdx) {
        return SimilarityIndexKt.common(srcHash, _srcIdx, dstHash, _dstIdx);
    }
}

