/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

public class RangeCodegenUtil {
    private static final ImmutableMap<FqName, PrimitiveType> RANGE_TO_ELEMENT_TYPE;
    private static final ImmutableMap<FqName, PrimitiveType> PROGRESSION_TO_ELEMENT_TYPE;

    @NotNull
    public static List<PrimitiveType> supportedRangeTypes() {
        List<PrimitiveType> list2 = Arrays.asList(PrimitiveType.CHAR, PrimitiveType.INT, PrimitiveType.LONG);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "supportedRangeTypes"));
        }
        return list2;
    }

    private RangeCodegenUtil() {
    }

    public static boolean isRange(KotlinType rangeType) {
        return !rangeType.isMarkedNullable() && RangeCodegenUtil.getPrimitiveRangeElementType(rangeType) != null;
    }

    public static boolean isProgression(KotlinType rangeType) {
        return !rangeType.isMarkedNullable() && RangeCodegenUtil.getPrimitiveProgressionElementType(rangeType) != null;
    }

    @Nullable
    private static PrimitiveType getPrimitiveRangeElementType(KotlinType rangeType) {
        return RangeCodegenUtil.getPrimitiveRangeOrProgressionElementType(rangeType, RANGE_TO_ELEMENT_TYPE);
    }

    @Nullable
    private static PrimitiveType getPrimitiveProgressionElementType(KotlinType rangeType) {
        return RangeCodegenUtil.getPrimitiveRangeOrProgressionElementType(rangeType, PROGRESSION_TO_ELEMENT_TYPE);
    }

    @Nullable
    private static PrimitiveType getPrimitiveRangeOrProgressionElementType(@NotNull KotlinType rangeOrProgression, @NotNull ImmutableMap<FqName, PrimitiveType> map2) {
        if (rangeOrProgression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeOrProgression", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "getPrimitiveRangeOrProgressionElementType"));
        }
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "getPrimitiveRangeOrProgressionElementType"));
        }
        ClassifierDescriptor declarationDescriptor = rangeOrProgression.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor == null) {
            return null;
        }
        FqNameUnsafe fqName2 = DescriptorUtils.getFqName(declarationDescriptor);
        if (!fqName2.isSafe()) {
            return null;
        }
        return (PrimitiveType)((Object)map2.get((Object)fqName2.toSafe()));
    }

    @Nullable
    public static PrimitiveType getPrimitiveRangeOrProgressionElementType(@NotNull FqName rangeOrProgressionName) {
        if (rangeOrProgressionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeOrProgressionName", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "getPrimitiveRangeOrProgressionElementType"));
        }
        PrimitiveType result2 = (PrimitiveType)((Object)RANGE_TO_ELEMENT_TYPE.get((Object)rangeOrProgressionName));
        return result2 != null ? result2 : (PrimitiveType)((Object)PROGRESSION_TO_ELEMENT_TYPE.get((Object)rangeOrProgressionName));
    }

    public static boolean isRangeOrProgression(@NotNull FqName className2) {
        if (className2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isRangeOrProgression"));
        }
        return RangeCodegenUtil.getPrimitiveRangeOrProgressionElementType(className2) != null;
    }

    public static boolean isPrimitiveNumberRangeTo(CallableDescriptor rangeTo) {
        if (!"rangeTo".equals(rangeTo.getName().asString())) {
            return false;
        }
        return AsmUtil.isPrimitiveNumberClassDescriptor(rangeTo.getContainingDeclaration());
    }

    private static boolean isPrimitiveRangeToExtension(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isPrimitiveRangeToExtension"));
        }
        if (!RangeCodegenUtil.isTopLevelInPackage(descriptor2, "rangeTo", "kotlin.ranges")) {
            return false;
        }
        ReceiverParameterDescriptor extensionReceiver = descriptor2.getExtensionReceiverParameter();
        if (extensionReceiver == null) {
            return false;
        }
        return KotlinBuiltIns.isPrimitiveType(extensionReceiver.getType());
    }

    public static boolean isPrimitiveNumberDownTo(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isPrimitiveNumberDownTo"));
        }
        if (!RangeCodegenUtil.isTopLevelInPackage(descriptor2, "downTo", "kotlin.ranges")) {
            return false;
        }
        ReceiverParameterDescriptor extensionReceiver = descriptor2.getExtensionReceiverParameter();
        if (extensionReceiver == null) {
            return false;
        }
        ClassifierDescriptor extensionReceiverClassifier = extensionReceiver.getType().getConstructor().getDeclarationDescriptor();
        return AsmUtil.isPrimitiveNumberClassDescriptor(extensionReceiverClassifier);
    }

    public static boolean isPrimitiveNumberUntil(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isPrimitiveNumberUntil"));
        }
        if (!RangeCodegenUtil.isTopLevelInPackage(descriptor2, "until", "kotlin.ranges")) {
            return false;
        }
        ReceiverParameterDescriptor extensionReceiver = descriptor2.getExtensionReceiverParameter();
        if (extensionReceiver == null) {
            return false;
        }
        ClassifierDescriptor extensionReceiverClassifier = extensionReceiver.getType().getConstructor().getDeclarationDescriptor();
        return AsmUtil.isPrimitiveNumberClassDescriptor(extensionReceiverClassifier);
    }

    public static boolean isArrayOrPrimitiveArrayIndices(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isArrayOrPrimitiveArrayIndices"));
        }
        if (!RangeCodegenUtil.isTopLevelInPackage(descriptor2, "indices", "kotlin.collections")) {
            return false;
        }
        ReceiverParameterDescriptor extensionReceiver = descriptor2.getExtensionReceiverParameter();
        if (extensionReceiver == null) {
            return false;
        }
        KotlinType extensionReceiverType = extensionReceiver.getType();
        return KotlinBuiltIns.isArray(extensionReceiverType) || KotlinBuiltIns.isPrimitiveArray(extensionReceiverType);
    }

    public static boolean isCollectionIndices(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isCollectionIndices"));
        }
        if (!RangeCodegenUtil.isTopLevelInPackage(descriptor2, "indices", "kotlin.collections")) {
            return false;
        }
        ReceiverParameterDescriptor extensionReceiver = descriptor2.getExtensionReceiverParameter();
        if (extensionReceiver == null) {
            return false;
        }
        KotlinType extensionReceiverType = extensionReceiver.getType();
        return KotlinBuiltIns.isCollectionOrNullableCollection(extensionReceiverType);
    }

    public static boolean isCharSequenceIndices(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isCharSequenceIndices"));
        }
        if (!RangeCodegenUtil.isTopLevelInPackage(descriptor2, "indices", "kotlin.text")) {
            return false;
        }
        ReceiverParameterDescriptor extensionReceiver = descriptor2.getExtensionReceiverParameter();
        if (extensionReceiver == null) {
            return false;
        }
        KotlinType extensionReceiverType = extensionReceiver.getType();
        return KotlinBuiltIns.isCharSequenceOrNullableCharSequence(extensionReceiverType);
    }

    public static boolean isPrimitiveRangeToExtension(@NotNull KtSimpleNameExpression operationReference, @NotNull BindingContext bindingContext2) {
        if (operationReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationReference", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isPrimitiveRangeToExtension"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isPrimitiveRangeToExtension"));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(operationReference, bindingContext2);
        ReceiverValue receiver = resolvedCall2.getDispatchReceiver();
        if (!(receiver instanceof ExpressionReceiver)) {
            return false;
        }
        ExpressionReceiver e = (ExpressionReceiver)receiver;
        ResolvedCall<? extends CallableDescriptor> resolvedReceiver = CallUtilKt.getResolvedCall(e.getExpression(), bindingContext2);
        if (resolvedReceiver == null) {
            return false;
        }
        return RangeCodegenUtil.isPrimitiveRangeToExtension(resolvedReceiver.getResultingDescriptor());
    }

    public static boolean isPrimitiveRangeSpecializationOfType(@NotNull Type argumentType, @NotNull KtExpression rangeExpression, @NotNull BindingContext bindingContext2) {
        if (argumentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentType", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isPrimitiveRangeSpecializationOfType"));
        }
        if (rangeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeExpression", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isPrimitiveRangeSpecializationOfType"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isPrimitiveRangeSpecializationOfType"));
        }
        if (rangeExpression instanceof KtBinaryExpression && ((KtBinaryExpression)rangeExpression).getOperationReference().getReferencedNameElementType() == KtTokens.RANGE) {
            KotlinType kotlinType = bindingContext2.getType(rangeExpression);
            assert (kotlinType != null);
            ClassifierDescriptor descriptor2 = kotlinType.getConstructor().getDeclarationDescriptor();
            if (descriptor2 != null) {
                FqNameUnsafe fqName2 = DescriptorUtils.getFqName(descriptor2);
                if (fqName2.equals(KotlinBuiltIns.FQ_NAMES.longRange)) {
                    return argumentType == Type.LONG_TYPE;
                }
                if (fqName2.equals(KotlinBuiltIns.FQ_NAMES.charRange) || fqName2.equals(KotlinBuiltIns.FQ_NAMES.intRange)) {
                    return AsmUtil.isIntPrimitive(argumentType);
                }
            }
        }
        return false;
    }

    private static boolean isTopLevelInPackage(@NotNull CallableDescriptor descriptor2, @NotNull String name2, @NotNull String packageName) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isTopLevelInPackage"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isTopLevelInPackage"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isTopLevelInPackage"));
        }
        if (!name2.equals(descriptor2.getName().asString())) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (!(containingDeclaration instanceof PackageFragmentDescriptor)) {
            return false;
        }
        String packageFqName = ((PackageFragmentDescriptor)containingDeclaration).getFqName().asString();
        return packageName.equals(packageFqName);
    }

    static {
        ImmutableMap.Builder rangeBuilder = ImmutableMap.builder();
        ImmutableMap.Builder progressionBuilder = ImmutableMap.builder();
        for (PrimitiveType primitiveType : RangeCodegenUtil.supportedRangeTypes()) {
            FqName rangeClassFqName = KotlinBuiltIns.RANGES_PACKAGE_FQ_NAME.child(Name.identifier(primitiveType.getTypeName() + "Range"));
            FqName progressionClassFqName = KotlinBuiltIns.RANGES_PACKAGE_FQ_NAME.child(Name.identifier(primitiveType.getTypeName() + "Progression"));
            rangeBuilder.put((Object)rangeClassFqName, (Object)primitiveType);
            progressionBuilder.put((Object)progressionClassFqName, (Object)primitiveType);
        }
        RANGE_TO_ELEMENT_TYPE = rangeBuilder.build();
        PROGRESSION_TO_ELEMENT_TYPE = progressionBuilder.build();
    }
}

