/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.binding;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.binding.CodegenAnnotatingVisitor;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.when.WhenByEnumsMapping;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.util.slicedMap.BasicWritableSlice;
import org.jetbrains.kotlin.util.slicedMap.Slices;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;
import org.jetbrains.org.objectweb.asm.Type;

public class CodegenBinding {
    public static final WritableSlice<ClassDescriptor, MutableClosure> CLOSURE = Slices.createSimpleSlice();
    public static final WritableSlice<CallableDescriptor, ClassDescriptor> CLASS_FOR_CALLABLE = Slices.createSimpleSlice();
    public static final WritableSlice<ClassDescriptor, Type> ASM_TYPE = Slices.createSimpleSlice();
    public static final WritableSlice<ClassDescriptor, Boolean> ENUM_ENTRY_CLASS_NEED_SUBCLASS = Slices.createSimpleSetSlice();
    private static final WritableSlice<ClassDescriptor, Collection<ClassDescriptor>> INNER_CLASSES = Slices.createSimpleSlice();
    public static final WritableSlice<KtExpression, SamType> SAM_VALUE = Slices.createSimpleSlice();
    public static final WritableSlice<KtCallElement, KtExpression> SAM_CONSTRUCTOR_TO_ARGUMENT = Slices.createSimpleSlice();
    public static final WritableSlice<KtWhenExpression, WhenByEnumsMapping> MAPPING_FOR_WHEN_BY_ENUM = Slices.createSimpleSlice();
    public static final WritableSlice<String, List<WhenByEnumsMapping>> MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE = Slices.createSimpleSlice();
    public static final WritableSlice<FunctionDescriptor, FunctionDescriptor> SUSPEND_FUNCTION_TO_JVM_VIEW = Slices.createSimpleSlice();
    public static final WritableSlice<ValueParameterDescriptor, ValueParameterDescriptor> PARAMETER_SYNONYM = Slices.createSimpleSlice();
    public static final WritableSlice<Type, List<VariableDescriptorWithAccessors>> DELEGATED_PROPERTIES = Slices.createSimpleSlice();
    public static final WritableSlice<VariableDescriptorWithAccessors, Type> DELEGATED_PROPERTY_METADATA_OWNER = Slices.createSimpleSlice();
    public static final WritableSlice<VariableDescriptor, VariableDescriptor> LOCAL_VARIABLE_PROPERTY_METADATA = Slices.createSimpleSlice();

    private CodegenBinding() {
    }

    public static void initTrace(@NotNull GenerationState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "initTrace"));
        }
        CodegenAnnotatingVisitor visitor2 = new CodegenAnnotatingVisitor(state);
        for (KtFile file2 : CodegenBinding.allFilesInPackages(state.getBindingContext(), state.getFiles())) {
            file2.accept(visitor2);
        }
    }

    public static boolean enumEntryNeedSubclass(BindingContext bindingContext2, KtEnumEntry enumEntry) {
        return CodegenBinding.enumEntryNeedSubclass(bindingContext2, bindingContext2.get(BindingContext.CLASS, enumEntry));
    }

    public static boolean enumEntryNeedSubclass(BindingContext bindingContext2, ClassDescriptor classDescriptor) {
        return Boolean.TRUE.equals(bindingContext2.get(ENUM_ENTRY_CLASS_NEED_SUBCLASS, classDescriptor));
    }

    @NotNull
    public static ClassDescriptor anonymousClassForCallable(@NotNull BindingContext bindingContext2, @NotNull CallableDescriptor descriptor2) {
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "anonymousClassForCallable"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "anonymousClassForCallable"));
        }
        ClassDescriptor classDescriptor = bindingContext2.get(CLASS_FOR_CALLABLE, descriptor2);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "anonymousClassForCallable"));
        }
        return classDescriptor;
    }

    @NotNull
    public static Type asmTypeForAnonymousClass(@NotNull BindingContext bindingContext2, @NotNull KtElement expression2) {
        ClassDescriptor descriptor2;
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
        }
        if (expression2 instanceof KtObjectLiteralExpression) {
            expression2 = ((KtObjectLiteralExpression)expression2).getObjectDeclaration();
        }
        if ((descriptor2 = bindingContext2.get(BindingContext.CLASS, expression2)) != null) {
            Type type2 = CodegenBinding.getAsmType(bindingContext2, descriptor2);
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
            }
            return type2;
        }
        SimpleFunctionDescriptor functionDescriptor2 = bindingContext2.get(BindingContext.FUNCTION, expression2);
        if (functionDescriptor2 != null) {
            Type type3 = CodegenBinding.asmTypeForAnonymousClass(bindingContext2, functionDescriptor2);
            if (type3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
            }
            return type3;
        }
        VariableDescriptor variableDescriptor = bindingContext2.get(BindingContext.VARIABLE, expression2);
        if (variableDescriptor != null) {
            Type type4 = CodegenBinding.asmTypeForAnonymousClass(bindingContext2, variableDescriptor);
            if (type4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
            }
            return type4;
        }
        throw new IllegalStateException("Couldn't compute ASM type for " + PsiUtilsKt.getElementTextWithContext((PsiElement)expression2));
    }

    @NotNull
    public static Type asmTypeForAnonymousClass(@NotNull BindingContext bindingContext2, @NotNull CallableDescriptor descriptor2) {
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
        }
        Type type2 = CodegenBinding.getAsmType(bindingContext2, CodegenBinding.anonymousClassForCallable(bindingContext2, descriptor2));
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
        }
        return type2;
    }

    public static boolean canHaveOuter(@NotNull BindingContext bindingContext2, @NotNull ClassDescriptor classDescriptor) {
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "canHaveOuter"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "canHaveOuter"));
        }
        if (classDescriptor.getKind() != ClassKind.CLASS) {
            return false;
        }
        MutableClosure closure = bindingContext2.get(CLOSURE, classDescriptor);
        if (closure == null || closure.getEnclosingClass() == null) {
            return false;
        }
        return classDescriptor.isInner() || !(classDescriptor.getContainingDeclaration() instanceof ClassDescriptor);
    }

    @NotNull
    static MutableClosure recordClosure(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor, @Nullable ClassDescriptor enclosing, @NotNull Type asmType) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "recordClosure"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "recordClosure"));
        }
        if (asmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmType", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "recordClosure"));
        }
        KtElement element2 = (KtElement)DescriptorToSourceUtils.descriptorToDeclaration(classDescriptor);
        assert (element2 != null) : "No source element for " + classDescriptor;
        MutableClosure closure = new MutableClosure(classDescriptor, enclosing);
        if (classDescriptor.isInner()) {
            closure.setCaptureThis();
        }
        trace.record(ASM_TYPE, classDescriptor, asmType);
        trace.record(CLOSURE, classDescriptor, closure);
        if (enclosing != null && !JvmCodegenUtil.isArgumentWhichWillBeInlined(trace.getBindingContext(), classDescriptor)) {
            CodegenBinding.recordInnerClass(trace, enclosing, classDescriptor);
        }
        MutableClosure mutableClosure = closure;
        if (mutableClosure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "recordClosure"));
        }
        return mutableClosure;
    }

    private static void recordInnerClass(@NotNull BindingTrace bindingTrace, @NotNull ClassDescriptor outer, @NotNull ClassDescriptor inner) {
        if (bindingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "recordInnerClass"));
        }
        if (outer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outer", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "recordInnerClass"));
        }
        if (inner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inner", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "recordInnerClass"));
        }
        Collection<ClassDescriptor> innerClasses = bindingTrace.get(INNER_CLASSES, outer);
        if (innerClasses == null) {
            innerClasses = new ArrayList<ClassDescriptor>(1);
            bindingTrace.record(INNER_CLASSES, outer, innerClasses);
        }
        innerClasses.add(inner);
    }

    @NotNull
    private static Collection<KtFile> allFilesInPackages(BindingContext bindingContext2, Collection<KtFile> files2) {
        HashSet<FqName> names = new HashSet<FqName>();
        for (KtFile ktFile : files2) {
            if (ktFile.isScript()) continue;
            names.add(ktFile.getPackageFqName());
        }
        HashSet<KtFile> answer = new HashSet<KtFile>();
        answer.addAll(files2);
        for (FqName name2 : names) {
            Collection<KtFile> jetFiles = bindingContext2.get(BindingContext.PACKAGE_TO_FILES, name2);
            if (jetFiles == null) continue;
            answer.addAll(jetFiles);
        }
        ArrayList<KtFile> arrayList = new ArrayList<KtFile>(answer);
        arrayList.sort(Comparator.comparing(file2 -> {
            VirtualFile virtualFile2 = file2.getVirtualFile();
            assert (virtualFile2 != null) : "VirtualFile is null for KtFile: " + file2.getName();
            return virtualFile2.getPath();
        }));
        ArrayList<KtFile> arrayList2 = arrayList;
        if (arrayList2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "allFilesInPackages"));
        }
        return arrayList2;
    }

    @NotNull
    public static Type getAsmType(@NotNull BindingContext bindingContext2, @NotNull ClassDescriptor klass2) {
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "getAsmType"));
        }
        if (klass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "getAsmType"));
        }
        Type type2 = bindingContext2.get(ASM_TYPE, klass2);
        assert (type2 != null) : "Type is not yet recorded for " + klass2;
        Type type3 = type2;
        if (type3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "getAsmType"));
        }
        return type3;
    }

    @NotNull
    public static VariableDescriptor getDelegatedLocalVariableMetadata(@NotNull VariableDescriptor variableDescriptor, @NotNull BindingContext bindingContext2) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "getDelegatedLocalVariableMetadata"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "getDelegatedLocalVariableMetadata"));
        }
        VariableDescriptor metadataVariableDescriptor = bindingContext2.get(LOCAL_VARIABLE_PROPERTY_METADATA, variableDescriptor);
        assert (metadataVariableDescriptor != null) : "Metadata for local delegated property should be not null: " + variableDescriptor;
        VariableDescriptor variableDescriptor2 = metadataVariableDescriptor;
        if (variableDescriptor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "getDelegatedLocalVariableMetadata"));
        }
        return variableDescriptor2;
    }

    static {
        BasicWritableSlice.initSliceDebugNames(CodegenBinding.class);
    }
}

