/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.RangeMapping;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.SmapData;
import org.jetbrains.kotlin.idea.debugger.SmapUtilKt$WhenMappings;
import org.jetbrains.kotlin.idea.debugger.SourceLineKind;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a<\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0002\u00a8\u0006\u0014"}, d2={"mapStacktraceLineToSource", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtFile;", "", "smapData", "Lorg/jetbrains/kotlin/idea/debugger/SmapData;", "line", "project", "Lcom/intellij/openapi/project/Project;", "lineKind", "Lorg/jetbrains/kotlin/idea/debugger/SourceLineKind;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "readDebugInfo", "bytes", "", "getIntervalIfContains", "Lorg/jetbrains/kotlin/codegen/inline/RangeMapping;", "Lorg/jetbrains/kotlin/codegen/inline/FileMapping;", "destLine", "idea"})
public final class SmapUtilKt {
    @Nullable
    public static final Pair<KtFile, Integer> mapStacktraceLineToSource(@NotNull SmapData smapData, int line, @NotNull Project project, @NotNull SourceLineKind lineKind, @NotNull GlobalSearchScope searchScope2) {
        int n;
        JvmClassName jvmName;
        Object v1;
        block13: {
            SMAP sMAP;
            Intrinsics.checkParameterIsNotNull((Object)smapData, (String)"smapData");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)((Object)lineKind), (String)"lineKind");
            Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
            switch (SmapUtilKt$WhenMappings.$EnumSwitchMapping$0[lineKind.ordinal()]) {
                case 1: {
                    sMAP = smapData.getKotlinDebugStrata();
                    break;
                }
                case 2: {
                    sMAP = smapData.getKotlinStrata();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (sMAP == null) {
                return null;
            }
            SMAP smap = sMAP;
            Iterable $receiver$iv = smap.getFileMappings();
            for (Object element$iv : $receiver$iv) {
                FileMapping it = (FileMapping)element$iv;
                if (!(SmapUtilKt.getIntervalIfContains(it, line) != null)) continue;
                v1 = element$iv;
                break block13;
            }
            v1 = null;
        }
        FileMapping fileMapping = v1;
        if (fileMapping == null) {
            return null;
        }
        FileMapping mappingInfo = fileMapping;
        JvmClassName jvmClassName = jvmName = JvmClassName.byInternalName(mappingInfo.getPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"jvmName");
        KtFile ktFile = DebuggerUtils.INSTANCE.findSourceFileForClassIncludeLibrarySources(project, searchScope2, jvmClassName, mappingInfo.getName());
        if (ktFile == null) {
            return null;
        }
        KtFile sourceFile = ktFile;
        RangeMapping rangeMapping = SmapUtilKt.getIntervalIfContains(mappingInfo, line);
        if (rangeMapping == null) {
            Intrinsics.throwNpe();
        }
        RangeMapping interval = rangeMapping;
        switch (SmapUtilKt$WhenMappings.$EnumSwitchMapping$1[lineKind.ordinal()]) {
            case 1: {
                n = interval.getSource() - 1;
                break;
            }
            case 2: {
                n = interval.mapDestToSource(line) - 1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int sourceLine = n;
        return TuplesKt.to((Object)sourceFile, (Object)sourceLine);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final SmapData readDebugInfo(@NotNull byte[] bytes2) {
        SmapData smapData;
        void debugInfo2;
        Intrinsics.checkParameterIsNotNull((Object)bytes2, (String)"bytes");
        ClassReader cr = new ClassReader(bytes2);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        cr.accept(new ClassVisitor((Ref.ObjectRef)debugInfo2, 327680){
            final /* synthetic */ Ref.ObjectRef $debugInfo;

            public void visitSource(@Nullable String source, @Nullable String debug) {
                this.$debugInfo.element = debug;
            }
            {
                this.$debugInfo = $captured_local_variable$0;
                super($super_call_param$1);
            }
        }, 0);
        String string = (String)debugInfo2.element;
        if (string != null) {
            String string2;
            String p1 = string2 = string;
            smapData = new SmapData(p1);
        } else {
            smapData = null;
        }
        return smapData;
    }

    private static final RangeMapping getIntervalIfContains(@NotNull FileMapping $receiver, int destLine) {
        Object v0;
        block1: {
            Iterable $receiver$iv = $receiver.getLineMappings();
            for (Object element$iv : $receiver$iv) {
                RangeMapping it = (RangeMapping)element$iv;
                if (!it.contains(destLine)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

