/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.BranchedFoldingUtils;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0003\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "LiftAssignmentOutFix", "LiftReturnOutFix", "idea"})
public final class LiftReturnOrAssignmentInspection
extends AbstractKotlinInspection {
    private static final int LINES_LIMIT = 15;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            private final void visitIfOrWhenOrTry(KtExpression expression2, PsiElement keyword) {
                int assignmentNumber;
                List<KtReturnExpression> foldableReturns;
                if (IfThenUtilsKt.lineCount(expression2) > org.jetbrains.kotlin.idea.inspections.LiftReturnOrAssignmentInspection$Companion.access$getLINES_LIMIT$p(LiftReturnOrAssignmentInspection.Companion)) {
                    return;
                }
                if (IfThenUtilsKt.isElseIf(expression2)) {
                    return;
                }
                List<KtReturnExpression> list2 = foldableReturns = BranchedFoldingUtils.INSTANCE.getFoldableReturns$idea(expression2);
                if (list2 != null) {
                    Collection collection = list2;
                    if (!collection.isEmpty()) {
                        void result$iv$iv$iv;
                        void $receiver$iv;
                        void $receiver$iv$iv;
                        PsiElement psiElement2 = (PsiElement)expression2;
                        Function1 predicate$iv = (Function1)new Function1<KtReturnExpression, Boolean>(foldableReturns){
                            final /* synthetic */ List $foldableReturns;

                            public final boolean invoke(@NotNull KtReturnExpression it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                return this.$foldableReturns.contains(it) ^ true;
                            }
                            {
                                this.$foldableReturns = list2;
                                super(1);
                            }
                        };
                        void $receiver$iv$iv$iv = $receiver$iv$iv = $receiver$iv;
                        Ref.ObjectRef objectRef = new Ref.ObjectRef();
                        objectRef.element = null;
                        $receiver$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv$iv){
                            final /* synthetic */ Function1 $predicate;
                            final /* synthetic */ Ref.ObjectRef $result;
                            {
                                this.$predicate = $captured_local_variable$0;
                                this.$result = $captured_local_variable$1;
                            }

                            public void visitElement(PsiElement element2) {
                                if (element2 instanceof KtReturnExpression && ((Boolean)this.$predicate.invoke((Object)element2)).booleanValue()) {
                                    this.$result.element = element2;
                                    this.stopWalking();
                                    return;
                                }
                                PsiElement it = element2;
                                super.visitElement(element2);
                            }
                        });
                        boolean hasOtherReturns2 = (PsiElement)result$iv$iv$iv.element != null;
                        String string = "Return can be lifted out of '" + keyword.getText() + '\'';
                        ProblemHighlightType problemHighlightType = !hasOtherReturns2 && foldableReturns.size() > 1 ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                        String string2 = keyword.getText();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"keyword.text");
                        localQuickFixArray[0] = new LiftReturnOutFix(string2);
                        this.$holder.registerProblem(keyword, string, problemHighlightType, localQuickFixArray);
                        return;
                    }
                }
                if ((assignmentNumber = BranchedFoldingUtils.INSTANCE.getFoldableAssignmentNumber$idea(expression2)) > 0) {
                    String string = "Assignment can be lifted out of '" + keyword.getText() + '\'';
                    ProblemHighlightType problemHighlightType = assignmentNumber > 1 ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                    String string3 = keyword.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"keyword.text");
                    localQuickFixArray[0] = new LiftAssignmentOutFix(string3);
                    this.$holder.registerProblem(keyword, string, problemHighlightType, localQuickFixArray);
                }
            }

            public void visitIfExpression(@NotNull KtIfExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitIfExpression(expression2);
                KtExpression ktExpression = expression2;
                PsiElement psiElement2 = expression2.getIfKeyword();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"expression.ifKeyword");
                this.visitIfOrWhenOrTry(ktExpression, psiElement2);
            }

            public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitWhenExpression(expression2);
                KtExpression ktExpression = expression2;
                PsiElement psiElement2 = expression2.getWhenKeyword();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"expression.whenKeyword");
                this.visitIfOrWhenOrTry(ktExpression, psiElement2);
            }

            public void visitTryExpression(@NotNull KtTryExpression expression2) {
                block0: {
                    PsiElement psiElement2;
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    super.visitTryExpression(expression2);
                    PsiElement psiElement3 = expression2.getTryKeyword();
                    if (psiElement3 == null) break block0;
                    PsiElement it = psiElement2 = psiElement3;
                    KtExpression ktExpression = expression2;
                    PsiElement psiElement4 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"it");
                    this.visitIfOrWhenOrTry(ktExpression, psiElement4);
                }
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    static {
        LINES_LIMIT = 15;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$LiftReturnOutFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "keyword", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea"})
    private static final class LiftReturnOutFix
    implements LocalQuickFix {
        private final String keyword;

        @NotNull
        public String getName() {
            return "Lift return out of '" + this.keyword + '\'';
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            void strict$iv;
            void $receiver$iv;
            PsiElement psiElement2;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement3 = descriptor2.getPsiElement();
            boolean bl = true;
            BranchedFoldingUtils branchedFoldingUtils = BranchedFoldingUtils.INSTANCE;
            PsiElement psiElement4 = psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtExpression.class, (boolean)strict$iv);
            if (psiElement4 == null) {
                Intrinsics.throwNpe();
            }
            branchedFoldingUtils.foldToReturn((KtExpression)psiElement4);
        }

        public LiftReturnOutFix(@NotNull String keyword) {
            Intrinsics.checkParameterIsNotNull((Object)keyword, (String)"keyword");
            this.keyword = keyword;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$LiftAssignmentOutFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "keyword", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea"})
    private static final class LiftAssignmentOutFix
    implements LocalQuickFix {
        private final String keyword;

        @NotNull
        public String getName() {
            return "Lift assignment out of '" + this.keyword + '\'';
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            void strict$iv;
            void $receiver$iv;
            PsiElement psiElement2;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement3 = descriptor2.getPsiElement();
            boolean bl = true;
            BranchedFoldingUtils branchedFoldingUtils = BranchedFoldingUtils.INSTANCE;
            PsiElement psiElement4 = psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtExpression.class, (boolean)strict$iv);
            if (psiElement4 == null) {
                Intrinsics.throwNpe();
            }
            branchedFoldingUtils.foldToAssignment((KtExpression)psiElement4);
        }

        public LiftAssignmentOutFix(@NotNull String keyword) {
            Intrinsics.checkParameterIsNotNull((Object)keyword, (String)"keyword");
            this.keyword = keyword;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$Companion;", "", "()V", "LINES_LIMIT", "", "getLINES_LIMIT", "()I", "idea"})
    public static final class Companion {
        private final int getLINES_LIMIT() {
            return LINES_LIMIT;
        }

        private Companion() {
        }

        public static final /* synthetic */ int access$getLINES_LIMIT$p(Companion $this) {
            return $this.getLINES_LIMIT();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

