/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomGoal;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator;
import org.jetbrains.kotlin.idea.maven.inspections.KotlinMavenPluginPhaseInspectionKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\f\r\u000e\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "()V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "getStaticDescription", "", "AddExecutionLocalFix", "AddJavaExecutionsLocalFix", "ConfigurePluginExecutionLocalFix", "FixAddStdlibLocalFix", "FixExecutionPhaseLocalFix", "idea-maven"})
public final class KotlinMavenPluginPhaseInspection
extends DomElementsInspection<MavenDomProjectModel> {
    @NotNull
    public String getStaticDescription() {
        return "Reports kotlin-maven-plugin configuration issues";
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void checkFileElement(@Nullable DomFileElement<MavenDomProjectModel> domFileElement, @Nullable DomElementAnnotationHolder holder) {
        if (domFileElement == null || holder == null) {
            return;
        }
        v0 = domFileElement.getModule();
        if (v0 == null) {
            return;
        }
        module = v0;
        manager = MavenProjectsManager.getInstance((Project)module.getProject());
        v1 = manager.findProject(module);
        if (v1 == null) {
            return;
        }
        mavenProject = v1;
        v2 = domFileElement.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"domFileElement.file");
        v3 = PomFile.Companion.forFileOrNull(v2);
        if (v3 == null) {
            return;
        }
        pom = v3;
        hasJavaFiles = KotlinMavenPluginPhaseInspectionKt.hasJavaFiles(module);
        var9_8 = mavenProject.getPlugins();
        var10_9 = $receiver$iv;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            it = (MavenPlugin)element$iv$iv;
            if (!KotlinMavenPluginPhaseInspectionKt.access$isKotlinMavenPlugin(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            it = (MavenPlugin)element$iv$iv;
            list$iv$iv = it.getExecutions();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        executions = (List)destination$iv$iv;
        $receiver$iv$iv = executions;
        destination$iv = new HashSet<E>();
        for (T element$iv : $receiver$iv) {
            it = (MavenPlugin.Execution)element$iv;
            v4 = it.getGoals();
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it.goals");
            list$iv = v4;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        allGoalsSet = (Set)destination$iv;
        hasJvmExecution = allGoalsSet.contains(PomFile.KotlinGoals.INSTANCE.getCompile()) != false || allGoalsSet.contains(PomFile.KotlinGoals.INSTANCE.getTestCompile()) != false;
        hasJsExecution = allGoalsSet.contains(PomFile.KotlinGoals.INSTANCE.getJs()) != false || allGoalsSet.contains(PomFile.KotlinGoals.INSTANCE.getTestJs()) != false;
        pomKotlinPlugins = pom.findKotlinPlugins();
        list$iv = pomKotlinPlugins.iterator();
        while (list$iv.hasNext()) {
            kotlinPlugin = (MavenDomPlugin)list$iv.next();
            if (allGoalsSet.contains(PomFile.KotlinGoals.INSTANCE.getCompile()) ^ true && allGoalsSet.contains(PomFile.KotlinGoals.INSTANCE.getJs()) ^ true) {
                if (hasJavaFiles) {
                    v5 = new AddExecutionLocalFix[1];
                    v6 = domFileElement.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"domFileElement.file");
                    v7 = module;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"module");
                    v8 = kotlinPlugin;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"kotlinPlugin");
                    v5[0] = new AddExecutionLocalFix(v6, v7, v8, PomFile.KotlinGoals.INSTANCE.getCompile());
                    elements$iv = v5;
                    v9 = (AddExecutionLocalFix[])elements$iv;
                } else {
                    v10 = new AddExecutionLocalFix[2];
                    v11 = domFileElement.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"domFileElement.file");
                    v12 = module;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"module");
                    v13 = kotlinPlugin;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"kotlinPlugin");
                    v10[0] = new AddExecutionLocalFix(v11, v12, v13, PomFile.KotlinGoals.INSTANCE.getCompile());
                    v14 = domFileElement.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"domFileElement.file");
                    v10[1] = new AddExecutionLocalFix(v14, module, kotlinPlugin, PomFile.KotlinGoals.INSTANCE.getJs());
                    elements$iv = v10;
                    v9 = (AddExecutionLocalFix[])elements$iv;
                }
                fixes = v9;
                v15 = fixes;
                holder.createProblem(kotlinPlugin.getArtifactId().createStableCopy(), HighlightSeverity.WARNING, "Kotlin plugin has no compile executions", Arrays.copyOf(v15, v15.length));
                continue;
            }
            if (hasJavaFiles) {
                v16 = kotlinPlugin;
                Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"kotlinPlugin");
                $receiver$iv = KotlinMavenPluginPhaseInspectionKt.access$notAtPhase(pom.findExecutions(v16, new String[]{PomFile.KotlinGoals.INSTANCE.getCompile()}), PomFile.DefaultPhases.INSTANCE.getProcessSources());
                for (T element$iv : $receiver$iv) {
                    block27: {
                        badExecution = (MavenDomPluginExecution)element$iv /* !! */ ;
                        javacPlugin /* !! */  = mavenProject.findPlugin("org.apache.maven.plugins", "maven-compiler-plugin");
                        $receiver$iv = pom.getDomModel().getBuild().getPlugins().getPlugins();
                        for (T element$iv : $receiver$iv) {
                            it = (MavenDomPlugin)element$iv;
                            if (!(Intrinsics.areEqual((Object)it.getGroupId().getStringValue(), (Object)"org.apache.maven.plugins") != false && Intrinsics.areEqual((Object)it.getArtifactId().getStringValue(), (Object)"maven-compiler-plugin") != false)) continue;
                            v17 = element$iv;
                            break block27;
                        }
                        v17 = null;
                    }
                    if ((existingJavac /* !! */  = (MavenDomPlugin)v17) != null && pom.isPluginAfter(existingJavac /* !! */ , kotlinPlugin) && !pom.isExecutionEnabled(javacPlugin /* !! */ , "default-compile") && !pom.isExecutionEnabled(javacPlugin /* !! */ , "default-testCompile") && !pom.isPluginExecutionMissing(javacPlugin /* !! */ , "default-compile", "compile") && !pom.isPluginExecutionMissing(javacPlugin /* !! */ , "default-testCompile", "testCompile")) continue;
                    v18 = badExecution.getPhase().createStableCopy();
                    v19 = new LocalQuickFix[2];
                    v19[0] = new FixExecutionPhaseLocalFix(badExecution, PomFile.DefaultPhases.INSTANCE.getProcessSources());
                    v20 = module;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v20, (String)"module");
                    v21 = domFileElement.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v21, (String)"domFileElement.file");
                    v19[1] = new AddJavaExecutionsLocalFix(v20, v21, kotlinPlugin);
                    holder.createProblem(v18, HighlightSeverity.WARNING, "Kotlin plugin should run before javac so kotlin classes could be visible from Java", v19);
                }
                $receiver$iv = pom.findExecutions(kotlinPlugin, new String[]{PomFile.KotlinGoals.INSTANCE.getJs(), PomFile.KotlinGoals.INSTANCE.getTestJs()});
                for (T element$iv : $receiver$iv) {
                    block28: {
                        badExecution = (MavenDomPluginExecution)element$iv /* !! */ ;
                        javacPlugin /* !! */  = badExecution.getGoals().getGoals();
                        $receiver$iv = holder;
                        for (T element$iv : $receiver$iv) {
                            it = (MavenDomGoal)element$iv;
                            if (!KotlinMavenPluginPhaseInspectionKt.access$isJsGoal((MavenDomGoal)it)) continue;
                            break block28;
                        }
                        throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    existingJavac /* !! */  = element$iv;
                    $receiver$iv.createProblem(((MavenDomGoal)existingJavac /* !! */ ).createStableCopy(), HighlightSeverity.WARNING, "JavaScript goal configured for module with Java files");
                }
            }
            stdlibDependencies = mavenProject.findDependencies(KotlinMavenConfigurator.Companion.getGROUP_ID(), KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID());
            jsDependencies = mavenProject.findDependencies(KotlinMavenConfigurator.Companion.getGROUP_ID(), KotlinRuntimeLibraryUtilKt.getMAVEN_JS_STDLIB_ID());
            if (hasJvmExecution && stdlibDependencies.isEmpty()) {
                v22 = kotlinPlugin.getArtifactId().createStableCopy();
                v23 = "Kotlin JVM compiler configured but no " + KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID() + " dependency";
                v24 = new LocalQuickFix[1];
                v25 = domFileElement.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)v25, (String)"domFileElement.file");
                v24[0] = new FixAddStdlibLocalFix(v25, KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID(), kotlinPlugin.getVersion().getRawText());
                holder.createProblem(v22, HighlightSeverity.WARNING, v23, v24);
            }
            if (!hasJsExecution || !jsDependencies.isEmpty()) continue;
            v26 = kotlinPlugin.getArtifactId().createStableCopy();
            v27 = "Kotlin JavaScript compiler configured but no " + KotlinRuntimeLibraryUtilKt.getMAVEN_JS_STDLIB_ID() + " dependency";
            v28 = new LocalQuickFix[1];
            v29 = domFileElement.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)v29, (String)"domFileElement.file");
            v28[0] = new FixAddStdlibLocalFix(v29, KotlinRuntimeLibraryUtilKt.getMAVEN_JS_STDLIB_ID(), kotlinPlugin.getVersion().getRawText());
            holder.createProblem(v26, HighlightSeverity.WARNING, v27, v28);
        }
        stdlibDependencies = PomFile.findDependencies$default(pom, new MavenId(KotlinMavenConfigurator.Companion.getGROUP_ID(), KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID(), null), null, 2, null);
        if (!hasJvmExecution && (list$iv = (Collection)stdlibDependencies).isEmpty() == false) {
            $receiver$iv = stdlibDependencies;
            stdlibDependencies = $receiver$iv.iterator();
            while (stdlibDependencies.hasNext()) {
                element$iv = stdlibDependencies.next();
                dep = (MavenDomDependency)element$iv;
                v30 = dep.getArtifactId().createStableCopy();
                v31 = "You have " + dep.getArtifactId() + " configured but no corresponding plugin execution";
                v32 = new LocalQuickFix[1];
                v33 = module;
                Intrinsics.checkExpressionValueIsNotNull((Object)v33, (String)"module");
                v34 = domFileElement.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)v34, (String)"domFileElement.file");
                v32[0] = new ConfigurePluginExecutionLocalFix(v33, v34, PomFile.KotlinGoals.INSTANCE.getCompile(), dep.getVersion().getRawText());
                holder.createProblem(v30, HighlightSeverity.WARNING, v31, v32);
            }
        }
        stdlibJsDependencies = PomFile.findDependencies$default(pom, new MavenId(KotlinMavenConfigurator.Companion.getGROUP_ID(), KotlinRuntimeLibraryUtilKt.getMAVEN_JS_STDLIB_ID(), null), null, 2, null);
        if (!hasJsExecution && (stdlibDependencies = (Collection)stdlibJsDependencies).isEmpty() == false) {
            $receiver$iv = stdlibJsDependencies;
            for (T element$iv : $receiver$iv) {
                dep = (MavenDomDependency)element$iv /* !! */ ;
                v35 = dep.getArtifactId().createStableCopy();
                v36 = "You have " + dep.getArtifactId() + " configured but no corresponding plugin execution";
                v37 = new LocalQuickFix[1];
                v38 = module;
                Intrinsics.checkExpressionValueIsNotNull((Object)v38, (String)"module");
                v39 = domFileElement.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)v39, (String)"domFileElement.file");
                v37[0] = new ConfigurePluginExecutionLocalFix(v38, v39, PomFile.KotlinGoals.INSTANCE.getJs(), dep.getVersion().getRawText());
                holder.createProblem(v35, HighlightSeverity.WARNING, v36, v37);
            }
        }
        $receiver$iv = pom.findKotlinExecutions();
        element$iv = $receiver$iv;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            block30: {
                block29: {
                    it = (MavenDomPluginExecution)element$iv$iv;
                    $receiver$iv = it.getGoals().getGoals();
                    for (T element$iv : $receiver$iv) {
                        it = (MavenDomGoal)element$iv;
                        if (!(Intrinsics.areEqual((Object)it.getRawText(), (Object)PomFile.KotlinGoals.INSTANCE.getCompile()) != false || Intrinsics.areEqual((Object)it.getRawText(), (Object)PomFile.KotlinGoals.INSTANCE.getJs()) != false)) continue;
                        v40 = true;
                        break block29;
                    }
                    v40 = false;
                }
                if (!v40) ** GOTO lbl-1000
                $receiver$iv = it.getGoals().getGoals();
                for (T element$iv : $receiver$iv) {
                    it = (MavenDomGoal)element$iv;
                    if (!(Intrinsics.areEqual((Object)it.getRawText(), (Object)PomFile.KotlinGoals.INSTANCE.getTestCompile()) != false || Intrinsics.areEqual((Object)it.getRawText(), (Object)PomFile.KotlinGoals.INSTANCE.getTestJs()) != false)) continue;
                    v41 = true;
                    break block30;
                }
                v41 = false;
            }
            if (v41) {
                v42 = true;
            } else lbl-1000:
            // 2 sources

            {
                v42 = false;
            }
            if (!v42) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (T element$iv : $receiver$iv) {
            badExecution = (MavenDomPluginExecution)element$iv /* !! */ ;
            holder.createProblem(badExecution.getGoals().createStableCopy(), HighlightSeverity.WEAK_WARNING, "It is not recommended to have both test and compile goals in the same execution");
        }
    }

    public KotlinMavenPluginPhaseInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$AddExecutionLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "file", "Lcom/intellij/psi/xml/XmlFile;", "module", "Lcom/intellij/openapi/module/Module;", "kotlinPlugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "goal", "", "(Lcom/intellij/psi/xml/XmlFile;Lcom/intellij/openapi/module/Module;Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;Ljava/lang/String;)V", "getFile", "()Lcom/intellij/psi/xml/XmlFile;", "getGoal", "()Ljava/lang/String;", "getKotlinPlugin", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "getModule", "()Lcom/intellij/openapi/module/Module;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea-maven"})
    private static final class AddExecutionLocalFix
    implements LocalQuickFix {
        @NotNull
        private final XmlFile file;
        @NotNull
        private final Module module;
        @NotNull
        private final MavenDomPlugin kotlinPlugin;
        @NotNull
        private final String goal;

        @NotNull
        public String getName() {
            return "Create " + this.goal + " execution";
        }

        @NotNull
        public String getFamilyName() {
            return "Create kotlin execution";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                PomFile pomFile = PomFile.Companion.forFileOrNull(this.file);
                if (pomFile == null) break block0;
                pomFile.addKotlinExecution(this.module, this.kotlinPlugin, this.goal, PomFile.Companion.getPhase(KotlinMavenPluginPhaseInspectionKt.hasJavaFiles(this.module), false), false, CollectionsKt.listOf((Object)this.goal));
            }
        }

        @NotNull
        public final XmlFile getFile() {
            return this.file;
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final MavenDomPlugin getKotlinPlugin() {
            return this.kotlinPlugin;
        }

        @NotNull
        public final String getGoal() {
            return this.goal;
        }

        public AddExecutionLocalFix(@NotNull XmlFile file2, @NotNull Module module, @NotNull MavenDomPlugin kotlinPlugin, @NotNull String goal) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)kotlinPlugin, (String)"kotlinPlugin");
            Intrinsics.checkParameterIsNotNull((Object)goal, (String)"goal");
            this.file = file2;
            this.module = module;
            this.kotlinPlugin = kotlinPlugin;
            this.goal = goal;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$FixExecutionPhaseLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "execution", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPluginExecution;", "newPhase", "", "(Lorg/jetbrains/idea/maven/dom/model/MavenDomPluginExecution;Ljava/lang/String;)V", "getExecution", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomPluginExecution;", "getNewPhase", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea-maven"})
    private static final class FixExecutionPhaseLocalFix
    implements LocalQuickFix {
        @NotNull
        private final MavenDomPluginExecution execution;
        @NotNull
        private final String newPhase;

        @NotNull
        public String getName() {
            return "Change phase to " + this.newPhase;
        }

        @NotNull
        public String getFamilyName() {
            return "Change phase";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            this.execution.getPhase().setValue((Object)this.newPhase);
        }

        @NotNull
        public final MavenDomPluginExecution getExecution() {
            return this.execution;
        }

        @NotNull
        public final String getNewPhase() {
            return this.newPhase;
        }

        public FixExecutionPhaseLocalFix(@NotNull MavenDomPluginExecution execution, @NotNull String newPhase) {
            Intrinsics.checkParameterIsNotNull((Object)execution, (String)"execution");
            Intrinsics.checkParameterIsNotNull((Object)newPhase, (String)"newPhase");
            this.execution = execution;
            this.newPhase = newPhase;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$AddJavaExecutionsLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/xml/XmlFile;", "kotlinPlugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/xml/XmlFile;Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;)V", "getFile", "()Lcom/intellij/psi/xml/XmlFile;", "getKotlinPlugin", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "getModule", "()Lcom/intellij/openapi/module/Module;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea-maven"})
    private static final class AddJavaExecutionsLocalFix
    implements LocalQuickFix {
        @NotNull
        private final Module module;
        @NotNull
        private final XmlFile file;
        @NotNull
        private final MavenDomPlugin kotlinPlugin;

        @NotNull
        public String getName() {
            return "Configure maven-compiler-plugin executions in the right order";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                PomFile pomFile = PomFile.Companion.forFileOrNull(this.file);
                if (pomFile == null) break block0;
                pomFile.addJavacExecutions(this.module, this.kotlinPlugin);
            }
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final XmlFile getFile() {
            return this.file;
        }

        @NotNull
        public final MavenDomPlugin getKotlinPlugin() {
            return this.kotlinPlugin;
        }

        public AddJavaExecutionsLocalFix(@NotNull Module module, @NotNull XmlFile file2, @NotNull MavenDomPlugin kotlinPlugin) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)kotlinPlugin, (String)"kotlinPlugin");
            this.module = module;
            this.file = file2;
            this.kotlinPlugin = kotlinPlugin;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$FixAddStdlibLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "pomFile", "Lcom/intellij/psi/xml/XmlFile;", "id", "", "version", "(Lcom/intellij/psi/xml/XmlFile;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getPomFile", "()Lcom/intellij/psi/xml/XmlFile;", "getVersion", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea-maven"})
    private static final class FixAddStdlibLocalFix
    implements LocalQuickFix {
        @NotNull
        private final XmlFile pomFile;
        @NotNull
        private final String id;
        @Nullable
        private final String version;

        @NotNull
        public String getName() {
            return "Add " + this.id + " dependency";
        }

        @NotNull
        public String getFamilyName() {
            return "Add dependency";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                PomFile pomFile = PomFile.Companion.forFileOrNull(this.pomFile);
                if (pomFile == null) break block0;
                PomFile.addDependency$default(pomFile, new MavenId(KotlinMavenConfigurator.Companion.getGROUP_ID(), this.id, this.version), MavenArtifactScope.COMPILE, null, false, null, 28, null);
            }
        }

        @NotNull
        public final XmlFile getPomFile() {
            return this.pomFile;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        public FixAddStdlibLocalFix(@NotNull XmlFile pomFile, @NotNull String id, @Nullable String version) {
            Intrinsics.checkParameterIsNotNull((Object)pomFile, (String)"pomFile");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            this.pomFile = pomFile;
            this.id = id;
            this.version = version;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$ConfigurePluginExecutionLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "module", "Lcom/intellij/openapi/module/Module;", "xmlFile", "Lcom/intellij/psi/xml/XmlFile;", "goal", "", "version", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/xml/XmlFile;Ljava/lang/String;Ljava/lang/String;)V", "getGoal", "()Ljava/lang/String;", "getModule", "()Lcom/intellij/openapi/module/Module;", "getVersion", "getXmlFile", "()Lcom/intellij/psi/xml/XmlFile;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea-maven"})
    private static final class ConfigurePluginExecutionLocalFix
    implements LocalQuickFix {
        @NotNull
        private final Module module;
        @NotNull
        private final XmlFile xmlFile;
        @NotNull
        private final String goal;
        @Nullable
        private final String version;

        @NotNull
        public String getName() {
            return "Create " + this.goal + " execution of kotlin-maven-compiler";
        }

        @NotNull
        public String getFamilyName() {
            return "Create kotlin execution";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block0: {
                PomFile pomFile;
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                PomFile pomFile2 = PomFile.Companion.forFileOrNull(this.xmlFile);
                if (pomFile2 == null) break block0;
                PomFile pom = pomFile = pomFile2;
                MavenDomPlugin plugin = pom.addKotlinPlugin(this.version);
                pom.addKotlinExecution(this.module, plugin, "compile", PomFile.Companion.getPhase(KotlinMavenPluginPhaseInspectionKt.hasJavaFiles(this.module), false), false, CollectionsKt.listOf((Object)this.goal));
            }
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final XmlFile getXmlFile() {
            return this.xmlFile;
        }

        @NotNull
        public final String getGoal() {
            return this.goal;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        public ConfigurePluginExecutionLocalFix(@NotNull Module module, @NotNull XmlFile xmlFile, @NotNull String goal, @Nullable String version) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)xmlFile, (String)"xmlFile");
            Intrinsics.checkParameterIsNotNull((Object)goal, (String)"goal");
            this.module = module;
            this.xmlFile = xmlFile;
            this.goal = goal;
            this.version = version;
        }
    }
}

