/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettingsProvider;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.idea.framework.JsLibraryStdDetectionUtil;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

public class ProjectStructureUtil {
    private static final Key<CachedValue<TargetPlatform>> PLATFORM_FOR_MODULE = Key.create((String)"PLATFORM_FOR_MODULE");

    private ProjectStructureUtil() {
    }

    @NotNull
    static TargetPlatform getCachedPlatformForModule(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/project/ProjectStructureUtil", "getCachedPlatformForModule"));
        }
        CachedValue result2 = (CachedValue)module.getUserData(PLATFORM_FOR_MODULE);
        if (result2 == null) {
            result2 = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<TargetPlatform>(){

                public CachedValueProvider.Result<TargetPlatform> compute() {
                    TargetPlatform configuredInFacet = ProjectStructureUtil.getPlatformConfiguredInFacet(module);
                    TargetPlatform platform = configuredInFacet != null ? configuredInFacet : (ProjectStructureUtil.hasJsStandardLibraryInDependencies(module) ? JsPlatform.INSTANCE : JvmPlatform.INSTANCE);
                    return CachedValueProvider.Result.create((Object)platform, (Object[])new Object[]{ProjectRootModificationTracker.getInstance((Project)module.getProject())});
                }
            }, false);
            module.putUserData(PLATFORM_FOR_MODULE, (Object)result2);
        }
        TargetPlatform targetPlatform = (TargetPlatform)result2.getValue();
        if (targetPlatform == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/project/ProjectStructureUtil", "getCachedPlatformForModule"));
        }
        return targetPlatform;
    }

    @Nullable
    private static TargetPlatform getPlatformConfiguredInFacet(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/project/ProjectStructureUtil", "getPlatformConfiguredInFacet"));
        }
        KotlinFacetSettings settings2 = KotlinFacetSettingsProvider.Companion.getInstance(module.getProject()).getInitializedSettings(module);
        TargetPlatformKind<?> kind2 = settings2.getTargetPlatformKind();
        if (kind2 instanceof TargetPlatformKind.Jvm) {
            return JvmPlatform.INSTANCE;
        }
        if (kind2 instanceof TargetPlatformKind.JavaScript) {
            return JsPlatform.INSTANCE;
        }
        if (kind2 instanceof TargetPlatformKind.Common) {
            return TargetPlatform.Default.INSTANCE;
        }
        return null;
    }

    private static boolean hasJsStandardLibraryInDependencies(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/project/ProjectStructureUtil", "hasJsStandardLibraryInDependencies"));
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                final Ref jsLibrary = Ref.create();
                ModuleRootManager.getInstance((Module)module).orderEntries().librariesOnly().forEachLibrary((Processor)new Processor<Library>(){

                    public boolean process(Library library2) {
                        if (JsLibraryStdDetectionUtil.INSTANCE.hasJsStdlibJar(library2, false)) {
                            jsLibrary.set((Object)library2);
                            return false;
                        }
                        return true;
                    }
                });
                return jsLibrary.get() != null;
            }
        });
    }
}

