/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.inspections.jam;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.compiler.util.InspectionValidatorWrapper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.spring.ws.jam.SpringWebServiceEndpoint;
import com.intellij.spring.ws.util.SpringWebServiceJamUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringWebServiceJamModelInspectionBase
extends BaseJavaLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/ws/inspections/jam/SpringWebServiceJamModelInspectionBase", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/ws/inspections/jam/SpringWebServiceJamModelInspectionBase", "checkFile"));
        }
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)file)) {
            return null;
        }
        if (!SpringWebServiceJamModelInspectionBase.isFileAccepted(file.getContainingFile())) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        this.checkJavaFile((PsiJavaFile)file, holder, isOnTheFly);
        List problemDescriptors = holder.getResults();
        if (problemDescriptors != null) {
            return problemDescriptors.toArray(new ProblemDescriptor[problemDescriptors.size()]);
        }
        return null;
    }

    protected void checkJavaFile(@NotNull PsiJavaFile javaFile, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (javaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaFile", "com/intellij/spring/ws/inspections/jam/SpringWebServiceJamModelInspectionBase", "checkJavaFile"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/ws/inspections/jam/SpringWebServiceJamModelInspectionBase", "checkJavaFile"));
        }
        for (PsiClass psiClass : javaFile.getClasses()) {
            this.checkClassInternal(psiClass, holder);
        }
    }

    private void checkClassInternal(PsiClass aClass, ProblemsHolder holder) {
        this.checkClass(aClass, holder);
        for (PsiClass psiClass : aClass.getInnerClasses()) {
            this.checkClass(psiClass, holder);
        }
    }

    protected void checkClass(@NotNull PsiClass aClass, ProblemsHolder holder) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/ws/inspections/jam/SpringWebServiceJamModelInspectionBase", "checkClass"));
        }
        SpringWebServiceEndpoint jamEndpoint = SpringWebServiceJamUtil.getEndpoint(aClass);
        if (jamEndpoint != null) {
            this.checkSpringWebServiceEndpoint(jamEndpoint, holder);
        }
    }

    protected void checkSpringWebServiceEndpoint(SpringWebServiceEndpoint webServiceEndpoint, ProblemsHolder holder) {
    }

    protected static boolean isFileAccepted(PsiFile file) {
        if (!InspectionValidatorWrapper.isCompilationThread()) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return module != null;
    }
}

