/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStatusEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.model.task.event.OperationResult;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.events.ProgressEvent;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressEventConverter;

public class GradleProgressListener
implements ProgressListener,
org.gradle.tooling.events.ProgressListener {
    private final ExternalSystemTaskNotificationListener myListener;
    private final ExternalSystemTaskId myTaskId;
    private final Map<String, Integer> myStatusEventIds = new HashMap<String, Integer>();

    public GradleProgressListener(ExternalSystemTaskNotificationListener listener, ExternalSystemTaskId taskId) {
        this.myListener = listener;
        this.myTaskId = taskId;
    }

    public void statusChanged(org.gradle.tooling.ProgressEvent event) {
        this.myListener.onStatusChange(new ExternalSystemTaskNotificationEvent(this.myTaskId, event.getDescription()));
    }

    public void statusChanged(ProgressEvent event) {
        ExternalSystemTaskNotificationEvent notificationEvent = GradleProgressEventConverter.convert(this.myTaskId, event);
        this.myListener.onStatusChange(notificationEvent);
        if (notificationEvent instanceof ExternalSystemTaskExecutionEvent) {
            ExternalSystemFinishEvent progressEvent;
            if (((ExternalSystemTaskExecutionEvent)notificationEvent).getProgressEvent() instanceof ExternalSystemStatusEvent) {
                ExternalSystemStatusEvent progressEvent2 = (ExternalSystemStatusEvent)((ExternalSystemTaskExecutionEvent)notificationEvent).getProgressEvent();
                if ("bytes".equals(progressEvent2.getUnit())) {
                    Integer oldProgress = this.myStatusEventIds.get(progressEvent2.getEventId());
                    if (oldProgress == null) {
                        String totalSizeInfo = progressEvent2.getTotal() > 0L ? " (" + StringUtil.formatFileSize((long)progressEvent2.getTotal()) + ")" : "";
                        this.myListener.onTaskOutput(this.myTaskId, progressEvent2.getDisplayName() + totalSizeInfo + "\n", true);
                        this.myStatusEventIds.put(progressEvent2.getEventId(), 0);
                    } else {
                        double fraction = (double)progressEvent2.getProgress() / (double)progressEvent2.getTotal();
                        int progressBarSize = 14;
                        int progress = (int)(fraction * (double)progressBarSize + 0.5);
                        if (oldProgress != progress) {
                            this.myStatusEventIds.put(progressEvent2.getEventId(), progress);
                            if (progressEvent2.getTotal() > 0L) {
                                int remaining = progressBarSize - progress;
                                remaining = remaining < 0 ? 0 : remaining;
                                int offset = 3 - ((int)Math.log10(fraction * 100.0) + 1);
                                offset = offset < 0 ? 0 : offset;
                                this.myListener.onTaskOutput(this.myTaskId, "\r[" + StringUtil.repeat((String)" ", (int)offset) + (int)(fraction * 100.0) + "%" + ']' + " [ " + StringUtil.repeat((String)"=", (int)(progress * 4 - 3)) + ">" + StringUtil.repeat((String)" ", (int)(remaining * 4)) + " ] " + StringUtil.formatFileSize((long)progressEvent2.getProgress()), true);
                            } else {
                                this.myListener.onTaskOutput(this.myTaskId, StringUtil.formatFileSize((long)progressEvent2.getProgress()) + "\n", true);
                            }
                        }
                    }
                }
            } else if (((ExternalSystemTaskExecutionEvent)notificationEvent).getProgressEvent() instanceof ExternalSystemFinishEvent && this.myStatusEventIds.containsKey((progressEvent = (ExternalSystemFinishEvent)((ExternalSystemTaskExecutionEvent)notificationEvent).getProgressEvent()).getEventId())) {
                OperationResult operationResult = progressEvent.getOperationResult();
                String duration = StringUtil.formatDuration((long)(operationResult.getEndTime() - operationResult.getStartTime()));
                this.myListener.onTaskOutput(this.myTaskId, "\n" + progressEvent.getDisplayName() + " succeeded, took " + duration + "\n", true);
                this.myListener.onTaskOutput(this.myTaskId, "Unzipping ...\n\n", true);
                this.myStatusEventIds.remove(progressEvent.getEventId());
            }
        }
    }
}

