/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.util;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.Utils;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.layout.AbstractLayoutAction;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.geom.YPoint;
import com.intellij.openapi.graph.layout.LayoutGraph;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.NodeLayout;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.settings.GraphSettingsProvider;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DiagramUtils {
    private DiagramUtils() {
    }

    public static boolean setBestPopupSizeForGraph(JBPopup popup, DiagramBuilder builder) {
        Dimension size = DiagramUtils.calcGraphSize(builder);
        Dimension best = new Dimension(size.width + 40, size.height + 60);
        Dimension screenSize = popup.getContent().getToolkit().getScreenSize();
        boolean canFit = true;
        if (best.width > screenSize.width - 200) {
            canFit = false;
            best.width = screenSize.width - 200;
        }
        if (best.height > screenSize.height - 200) {
            canFit = false;
            best.height = screenSize.height - 200;
        }
        popup.setSize(best);
        return canFit;
    }

    public static Point getBestPositionForNode(DiagramBuilder builder) {
        double yy = -1.7976931348623157E308;
        double xx = -1.7976931348623157E308;
        double rightest = -1.7976931348623157E308;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double leftest = Double.MAX_VALUE;
        for (DiagramNode umlNode : builder.getNodeObjects()) {
            NodeLayout nodeLayout;
            Node node = builder.getNode(umlNode);
            if (node == null || (nodeLayout = builder.getGraph().getNodeLayout((Object)node)) == null) continue;
            double w = nodeLayout.getWidth();
            double nx = nodeLayout.getX();
            double x = nx + w;
            double h = nodeLayout.getHeight();
            double ny = nodeLayout.getY();
            double y = ny + h;
            if (x > rightest) {
                rightest = x;
            }
            if (x < leftest) {
                leftest = x - w;
            }
            if (!(y >= maxY)) continue;
            xx = y == maxY ? Math.max(xx, nx) : nx;
            yy = Math.max(yy, ny);
            maxX = y == maxY ? Math.max(x, maxX) : x;
            maxY = y;
        }
        if (maxY == -1.7976931348623157E308 || maxX == -1.7976931348623157E308) {
            return new Point(200, 200);
        }
        Point p = new Point();
        if (rightest - maxX < 100.0) {
            p.setLocation(leftest, maxY + 20.0);
        } else {
            p.setLocation(maxX + 20.0, yy);
        }
        return p;
    }

    public static Dimension calcGraphSize(DiagramBuilder builder) {
        NodeLayout layout;
        double x0 = 0.0;
        double y0 = 0.0;
        double xx = 0.0;
        double yy = 0.0;
        for (DiagramNode nodeObject : builder.getNodeObjects()) {
            Node node = builder.getNode(nodeObject);
            if (node == null || (layout = builder.getGraph().getNodeLayout((Object)node)) == null) continue;
            x0 = Math.min(x0, layout.getX());
            y0 = Math.min(y0, layout.getY());
            xx = Math.max(xx, layout.getX() + layout.getWidth());
            yy = Math.max(yy, layout.getY() + layout.getHeight());
        }
        for (DiagramEdge edgeObject : builder.getEdgeObjects()) {
            Edge edge = builder.getEdge(edgeObject);
            if (edge == null || (layout = builder.getGraph().getEdgeLayout((Object)edge)) == null) continue;
            for (int i = 0; i < layout.pointCount(); ++i) {
                YPoint p = layout.getPoint(i);
                x0 = Math.min(x0, p.getX());
                y0 = Math.min(y0, p.getY());
                xx = Math.max(xx, p.getX());
                yy = Math.max(yy, p.getY());
            }
        }
        int width = (int)(xx - x0);
        int height = (int)(yy - y0);
        if (width == 0) {
            width = 400;
        }
        if (height == 0) {
            height = 400;
        }
        return x0 == 0.0 && y0 == 0.0 && xx == 0.0 && yy == 0.0 ? new Dimension(400, 400) : new Dimension(width, height);
    }

    public static void updateGraphLayout(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/diagram/util/DiagramUtils", "updateGraphLayout"));
        }
        GraphSettings settings = GraphSettingsProvider.getInstance((Project)builder.getProject()).getSettings((Graph)builder.getGraph());
        AbstractLayoutAction.doLayout((Graph2DView)((Graph2DView)builder.getGraph().getCurrentView()), (Layouter)settings.getCurrentLayouter(), (Project)builder.getProject());
    }

    public static <NODE_TYPE> List<NODE_TYPE> getSelectedNodes(GraphBuilder<NODE_TYPE, ?> builder) {
        ArrayList<Object> selectedNodes = new ArrayList<Object>();
        NodeCursor nc = builder.getGraph().selectedNodes();
        while (nc.ok()) {
            Node node = nc.node();
            Object nodeObject = builder.getNodeObject(node);
            if (nodeObject != null) {
                selectedNodes.add(nodeObject);
            }
            nc.next();
        }
        return selectedNodes;
    }

    private static void doLayout(GraphBuilder builder) {
        Project project = builder.getProject();
        Layouter currentLayouter = GraphSettingsProvider.getInstance((Project)project).getSettings((Graph)builder.getGraph()).getCurrentLayouter();
        GraphManager.getGraphManager().createBufferedLayouter(currentLayouter).doLayout((LayoutGraph)builder.getGraph());
        builder.getView().fitContent();
    }

    public static ArrayList<DiagramNode> getSelectedNodes(DiagramBuilder builder) {
        ArrayList<DiagramNode> selectedNodes = new ArrayList<DiagramNode>();
        NodeCursor nc = builder.getGraph().selectedNodes();
        while (nc.ok()) {
            Node node = nc.node();
            DiagramNode nodeObject = builder.getNodeObject(node);
            if (nodeObject != null) {
                selectedNodes.add(nodeObject);
            }
            nc.next();
        }
        return selectedNodes;
    }

    public static boolean isNodeWithoutBody(DiagramBuilder builder, Node node) {
        NodeRealizer realizer = builder.getGraph().getRealizer(node);
        if (realizer == null) {
            return false;
        }
        return realizer.getHeight() < 30.0;
    }

    public static List<DiagramEdge> getSelectedEdges(DiagramBuilder builder) {
        ArrayList<DiagramEdge> selectedEdges = new ArrayList<DiagramEdge>();
        EdgeCursor ec = builder.getGraph().selectedEdges();
        while (ec.ok()) {
            Edge edge = ec.edge();
            DiagramEdge edgeObject = builder.getEdgeObject(edge);
            if (edgeObject != null) {
                selectedEdges.add(edgeObject);
            }
            ec.next();
        }
        return selectedEdges;
    }

    public static void navigateTo(DiagramNode node) {
        DiagramBuilder builder = (DiagramBuilder)node.getUserData(Utils.GRAPH_BUILDER);
        if (builder != null) {
            GraphViewUtil.navigateTo((Object)node, (GraphBuilder)((GraphBuilder)builder));
        }
    }
}

