/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.cloud;

import com.intellij.javaee.cloudfoundry.cloud.CFDeploymentConfiguration;
import com.intellij.javaee.cloudfoundry.cloud.CFServerConfiguration;
import com.intellij.javaee.cloudfoundry.cloud.CFServerRuntimeInstanceBase;
import com.intellij.javaee.cloudfoundry.cloud.CFServerRuntimeInstanceV1;
import com.intellij.javaee.cloudfoundry.cloud.CFServerRuntimeInstanceV2;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryDescription;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryManager;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CFConnector
extends ServerConnector<CFDeploymentConfiguration> {
    private static final Logger LOG = Logger.getInstance(CFConnector.class);
    private final CFServerConfiguration myConfiguration;
    private final ServerTaskExecutor myTasksExecutor;

    public CFConnector(CFServerConfiguration configuration, ServerTaskExecutor tasksExecutor) {
        this.myConfiguration = configuration;
        this.myTasksExecutor = tasksExecutor;
    }

    public void connect(@NotNull ServerConnector.ConnectionCallback<CFDeploymentConfiguration> callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javaee/cloudfoundry/cloud/CFConnector", "connect"));
        }
        this.myTasksExecutor.submit(() -> {
            List clientLibrary;
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javaee/cloudfoundry/cloud/CFConnector", "lambda$connect$0"));
            }
            try {
                ClientLibraryDescription libraryDescription = this.myConfiguration.getVersion().getLibraryDescription();
                clientLibrary = ClientLibraryManager.getInstance().download(libraryDescription);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                callback.errorOccurred("Failed to download client libraries: " + e.getMessage());
                return;
            }
            CFServerRuntimeInstanceBase serverRuntimeInstance = this.myConfiguration.isV2() ? new CFServerRuntimeInstanceV2(this.myConfiguration, this.myTasksExecutor, clientLibrary) : new CFServerRuntimeInstanceV1(this.myConfiguration, this.myTasksExecutor, clientLibrary);
            serverRuntimeInstance.connect(callback);
        }, callback);
    }
}

