/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.switchtoif;

import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.switchtoif.CaseUtil;
import org.intellij.idea.lang.javascript.psiutil.ParenthesesUtils;
import org.intellij.idea.lang.javascript.psiutil.SideEffectChecker;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSReplaceSwitchWithIfIntention
extends JSIntention {
    @NonNls
    private static final String IF_PREFIX = "if (";
    @NonNls
    private static final String IF_SUFFIX = ") {";
    @NonNls
    private static final String ELSE = "} else {";
    @NonNls
    private static final String ELSE_KEYWORD = "else ";
    @NonNls
    private static final String VAR_PREFIX = "var ";
    @NonNls
    private static final String BREAK_KEYWORD = "break ";
    @NonNls
    private static final String DEFAULT_LABEL_NAME = "Label";

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        SwitchPredicate switchPredicate = new SwitchPredicate();
        if (switchPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/switchtoif/JSReplaceSwitchWithIfIntention", "getElementPredicate"));
        }
        return switchPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        String ifStatementString;
        String declarationString;
        String expressionText;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/switchtoif/JSReplaceSwitchWithIfIntention", "processIntention"));
        }
        JSSwitchStatement switchStatement = (JSSwitchStatement)element.getParent();
        assert (switchStatement != null);
        PsiManager mgr = switchStatement.getManager();
        JSExpression switchExpression = switchStatement.getSwitchExpression();
        CodeStyleManager codeStyleMgr = CodeStyleManager.getInstance((Project)mgr.getProject());
        boolean hadSideEffects = SideEffectChecker.mayHaveSideEffects(switchExpression);
        if (hadSideEffects) {
            String variableName = "i";
            expressionText = "i";
            declarationString = "var i = " + switchExpression.getText() + ';';
        } else {
            declarationString = null;
            expressionText = switchExpression.getText();
        }
        boolean renameBreaks = false;
        for (JSCaseClause caseClause : switchStatement.getCaseClauses()) {
            if (!CaseUtil.containsHiddenBreak(caseClause)) continue;
            renameBreaks = true;
            break;
        }
        StringBuilder ifStatementBuffer = new StringBuilder(1024);
        String breakLabel = null;
        if (renameBreaks) {
            breakLabel = CaseUtil.findUniqueLabel((JSStatement)switchStatement, DEFAULT_LABEL_NAME);
            ifStatementBuffer.append(breakLabel).append(':');
        }
        ArrayList<SwitchStatementBranch> openBranches = new ArrayList<SwitchStatementBranch>();
        HashSet<JSVariable> declaredVars = new HashSet<JSVariable>(5);
        ArrayList<SwitchStatementBranch> allBranches = new ArrayList<SwitchStatementBranch>();
        SwitchStatementBranch currentBranch = null;
        for (JSCaseClause caseClause : switchStatement.getCaseClauses()) {
            PsiElement[] caseClauseChildren;
            for (PsiElement child : caseClauseChildren = caseClause.getChildren()) {
                if (child == caseClauseChildren[0]) {
                    if (currentBranch == null) {
                        openBranches.clear();
                        currentBranch = new SwitchStatementBranch();
                        currentBranch.addPendingVariableDeclarations(declaredVars);
                        allBranches.add(currentBranch);
                        openBranches.add(currentBranch);
                    } else if (currentBranch.hasStatements()) {
                        currentBranch = new SwitchStatementBranch();
                        allBranches.add(currentBranch);
                        openBranches.add(currentBranch);
                    }
                    if (caseClause.isDefault()) {
                        currentBranch.setDefault();
                    }
                }
                if (child instanceof JSExpression) {
                    JSExpression value = ParenthesesUtils.stripParentheses(caseClause.getCaseExpression());
                    assert (currentBranch != null);
                    currentBranch.addLabel(value.getText());
                    continue;
                }
                if (child instanceof JSStatement) {
                    JSStatement statement = (JSStatement)child;
                    if (statement instanceof JSVarStatement) {
                        Collections.addAll(declaredVars, ((JSVarStatement)statement).getVariables());
                    } else if (statement instanceof JSBlockStatement) {
                        for (PsiElement blockElement : statement.getChildren()) {
                            boolean isJsElement = blockElement instanceof JSElement;
                            boolean isWhiteSpace = blockElement instanceof PsiWhiteSpace;
                            for (SwitchStatementBranch branch : openBranches) {
                                if (isJsElement) {
                                    branch.addStatement((JSElement)blockElement);
                                    continue;
                                }
                                if (isWhiteSpace) {
                                    branch.addWhiteSpace(blockElement);
                                    continue;
                                }
                                branch.addComment(blockElement);
                            }
                        }
                    } else {
                        for (SwitchStatementBranch branch : openBranches) {
                            branch.addStatement((JSElement)statement);
                        }
                    }
                    if (ControlFlowUtils.statementMayCompleteNormally((JSStatement)statement)) continue;
                    currentBranch = null;
                    continue;
                }
                if (!(child instanceof PsiWhiteSpace) && !(child instanceof PsiComment)) continue;
                boolean isWhiteSpace = child instanceof PsiWhiteSpace;
                for (SwitchStatementBranch openBranch : openBranches) {
                    if (isWhiteSpace) {
                        openBranch.addWhiteSpace(child);
                        continue;
                    }
                    openBranch.addComment(child);
                }
            }
        }
        boolean firstBranch = true;
        SwitchStatementBranch defaultBranch = null;
        for (SwitchStatementBranch branch : allBranches) {
            if (branch.isDefault()) {
                defaultBranch = branch;
                continue;
            }
            List<String> labels = branch.getLabels();
            List<PsiElement> bodyElements = branch.getBodyElements();
            Set<JSVariable> pendingVariableDeclarations = branch.getPendingVariableDeclarations();
            JSReplaceSwitchWithIfIntention.dumpBranch(ifStatementBuffer, expressionText, labels, bodyElements, firstBranch, renameBreaks && CaseUtil.containsHiddenBreak(bodyElements), breakLabel, pendingVariableDeclarations);
            firstBranch = false;
        }
        if (defaultBranch != null) {
            List<PsiElement> bodyElements = defaultBranch.getBodyElements();
            Set<JSVariable> pendingVariableDeclarations = defaultBranch.getPendingVariableDeclarations();
            JSReplaceSwitchWithIfIntention.dumpDefaultBranch(ifStatementBuffer, bodyElements, firstBranch, renameBreaks, breakLabel, pendingVariableDeclarations);
        }
        JSLanguageDialect dialect = JSUtils.getDialect((PsiFile)element.getContainingFile());
        if (hadSideEffects) {
            ifStatementString = ifStatementBuffer.toString();
            JSStatement declarationStatement = (JSStatement)JSChangeUtil.createStatementFromText((Project)element.getProject(), (String)declarationString, (JSLanguageDialect)dialect).getPsi();
            JSStatement ifStatement = (JSStatement)JSChangeUtil.createStatementFromText((Project)element.getProject(), (String)ifStatementString, (JSLanguageDialect)dialect).getPsi();
            codeStyleMgr.reformat((PsiElement)declarationStatement);
            codeStyleMgr.reformat((PsiElement)ifStatement);
            JSElementFactory.replaceStatement((JSStatement)switchStatement, (String)(declarationStatement.getText() + '\n' + ifStatement.getText()));
        } else {
            ifStatementString = ifStatementBuffer.toString();
            JSStatement newStatement = (JSStatement)JSChangeUtil.createStatementFromText((Project)element.getProject(), (String)ifStatementString, (JSLanguageDialect)dialect).getPsi();
            codeStyleMgr.reformat((PsiElement)newStatement);
            JSElementFactory.replaceStatement((JSStatement)switchStatement, (String)newStatement.getText());
        }
    }

    private static void dumpBranch(StringBuilder ifStatementString, String expressionText, List<String> labels, List<PsiElement> bodyStatements, boolean firstBranch, boolean renameBreaks, String breakLabel, Set<JSVariable> variableDecls) {
        if (!firstBranch) {
            ifStatementString.append(ELSE_KEYWORD);
        }
        JSReplaceSwitchWithIfIntention.dumpLabels(ifStatementString, expressionText, labels);
        JSReplaceSwitchWithIfIntention.dumpBody(ifStatementString, bodyStatements, renameBreaks, breakLabel, variableDecls);
    }

    private static void dumpDefaultBranch(StringBuilder ifStatementString, List<PsiElement> bodyStatements, boolean firstBranch, boolean renameBreaks, String breakLabel, Set<JSVariable> variableDecls) {
        if (!firstBranch) {
            ifStatementString.append(ELSE_KEYWORD);
        }
        JSReplaceSwitchWithIfIntention.dumpBody(ifStatementString, bodyStatements, renameBreaks, breakLabel, variableDecls);
    }

    private static void dumpLabels(StringBuilder ifStatementString, String expressionText, List<String> labels) {
        boolean firstLabel = true;
        ifStatementString.append(IF_PREFIX);
        for (String label : labels) {
            if (!firstLabel) {
                ifStatementString.append("||");
            }
            firstLabel = false;
            ifStatementString.append(expressionText).append("===").append(label);
        }
        ifStatementString.append(')');
    }

    private static void dumpBody(StringBuilder ifStatementString, List<PsiElement> bodyStatements, boolean renameBreaks, String breakLabel, Set<JSVariable> variableDecls) {
        ifStatementString.append('{');
        for (JSVariable var : variableDecls) {
            if (!CaseUtil.isUsedByStatementList(var, bodyStatements)) continue;
            ifStatementString.append(VAR_PREFIX).append(var.getName()).append(';');
        }
        for (PsiElement bodyStatement : bodyStatements) {
            if (bodyStatement instanceof JSBreakStatement) continue;
            JSReplaceSwitchWithIfIntention.appendElement(ifStatementString, bodyStatement, renameBreaks, breakLabel);
        }
        ifStatementString.append('}');
    }

    private static void appendElement(StringBuilder ifStatementString, PsiElement element, boolean renameBreakElements, String breakLabelString) {
        if (!renameBreakElements) {
            String text = element.getText();
            ifStatementString.append(text);
        } else if (element instanceof JSBreakStatement) {
            String identifier = ((JSBreakStatement)element).getLabel();
            if (identifier == null || identifier.length() == 0) {
                ifStatementString.append(BREAK_KEYWORD).append(breakLabelString).append(';');
            } else {
                String text = element.getText();
                ifStatementString.append(text);
            }
        } else if (element instanceof JSBlockStatement) {
            for (PsiElement child : element.getChildren()) {
                JSReplaceSwitchWithIfIntention.appendElement(ifStatementString, child, renameBreakElements, breakLabelString);
            }
        } else if (element instanceof JSIfStatement) {
            JSIfStatement ifStatement = (JSIfStatement)element;
            JSStatement elseBranch = ifStatement.getElse();
            ifStatementString.append(IF_PREFIX).append(ifStatement.getCondition().getText()).append(IF_SUFFIX);
            JSReplaceSwitchWithIfIntention.appendElement(ifStatementString, (PsiElement)ifStatement.getThen(), renameBreakElements, breakLabelString);
            if (elseBranch != null) {
                ifStatementString.append(ELSE);
                JSReplaceSwitchWithIfIntention.appendElement(ifStatementString, (PsiElement)elseBranch, renameBreakElements, breakLabelString);
            }
            ifStatementString.append('}');
        } else {
            ifStatementString.append(element.getText());
        }
    }

    private static class SwitchStatementBranch {
        private final Set<JSVariable> pendingVariableDeclarations = new HashSet<JSVariable>(5);
        private final List<String> labels = new ArrayList<String>(2);
        private final List<PsiElement> bodyElements = new ArrayList<PsiElement>(5);
        private final List<PsiElement> pendingWhiteSpace = new ArrayList<PsiElement>(2);
        private boolean isDefault;
        private boolean hasStatements;

        private SwitchStatementBranch() {
        }

        public void addLabel(String labelString) {
            this.labels.add(labelString);
        }

        public void addStatement(JSElement statement) {
            this.hasStatements = true;
            this.addElement((PsiElement)statement);
        }

        public void addComment(PsiElement comment) {
            this.addElement(comment);
        }

        private void addElement(PsiElement element) {
            this.bodyElements.addAll(this.pendingWhiteSpace);
            this.pendingWhiteSpace.clear();
            this.bodyElements.add(element);
        }

        public void addWhiteSpace(PsiElement whiteSpace) {
            if (this.bodyElements.size() > 0) {
                this.pendingWhiteSpace.add(whiteSpace);
            }
        }

        public List<String> getLabels() {
            return Collections.unmodifiableList(this.labels);
        }

        public List<PsiElement> getBodyElements() {
            return Collections.unmodifiableList(this.bodyElements);
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void setDefault() {
            this.isDefault = true;
        }

        public boolean hasStatements() {
            return this.hasStatements;
        }

        public void addPendingVariableDeclarations(Set<JSVariable> vars) {
            this.pendingVariableDeclarations.addAll(vars);
        }

        public Set<JSVariable> getPendingVariableDeclarations() {
            return Collections.unmodifiableSet(this.pendingVariableDeclarations);
        }
    }

    private static class SwitchPredicate
    implements JSElementPredicate {
        private SwitchPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/switchtoif/JSReplaceSwitchWithIfIntention$SwitchPredicate", "satisfiedBy"));
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof JSSwitchStatement)) {
                return false;
            }
            JSSwitchStatement switchStatement = (JSSwitchStatement)parent;
            if (ErrorUtil.containsError((PsiElement)switchStatement)) {
                return false;
            }
            JSExpression expression = switchStatement.getSwitchExpression();
            return expression != null && expression.isValid();
        }
    }
}

