/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections.htmltagreplace;

import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class HtmlTagReplaceUtil {
    public static XmlFile generateXmlFile(@NotNull Project project, String filetext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/htmltools/codeInspection/htmlInspections/htmltagreplace/HtmlTagReplaceUtil", "generateXmlFile"));
        }
        return (XmlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("dummy.xml", (Language)XMLLanguage.INSTANCE, (CharSequence)filetext);
    }

    public static XmlFile genereateXmlFileWithSingleTag(@NotNull Project project, String tagname) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/htmltools/codeInspection/htmlInspections/htmltagreplace/HtmlTagReplaceUtil", "genereateXmlFileWithSingleTag"));
        }
        String filetext = "<" + tagname + "></" + tagname + ">";
        return HtmlTagReplaceUtil.generateXmlFile(project, filetext);
    }

    public static PsiElement[] getXmlNamesFromSingleTagFile(XmlFile xmlFile) {
        XmlTag tag = xmlFile.getDocument().getRootTag();
        assert (tag != null);
        PsiElement[] answer = new PsiElement[2];
        int cnt = 0;
        for (PsiElement child : tag.getChildren()) {
            IElementType type;
            if (!(child instanceof XmlToken) || (type = ((XmlToken)child).getTokenType()) != XmlTokenType.XML_NAME) continue;
            answer[cnt++] = child;
        }
        return answer;
    }
}

