/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.maven;

import java.io.File;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.logging.Logger;

public final class AdditionalSourceRootUtil {
    public static void addByUnknownGeneratorMojo(MavenProject project) {
        File[] files;
        File generatedSources = new File(project.getBuild().getDirectory(), "/generated-sources");
        if (generatedSources.isDirectory() && (files = generatedSources.listFiles()) != null) {
            for (File file : files) {
                if (!file.isDirectory() || file.isHidden()) continue;
                AdditionalSourceRootUtil.addCompilerSourceRoot(project, file);
            }
        }
    }

    private static void addCompilerSourceRoot(MavenProject project, File file) {
        String filename = file.getAbsolutePath();
        if (!project.getCompileSourceRoots().contains(filename)) {
            project.addCompileSourceRoot(filename);
        }
    }

    private static Object evaluate(ExpressionEvaluator expressionEvaluator, String value, Logger logger) {
        try {
            return expressionEvaluator.evaluate(value);
        }
        catch (ExpressionEvaluationException e) {
            logger.error("Can't evaluate " + value, (Throwable)e);
            return null;
        }
    }

    public static void addResourcesAsCompileSourceRoots(MavenProject project) {
        for (Resource resource : project.getResources()) {
            File resourceFolder = new File(resource.getDirectory());
            if (!resourceFolder.exists() || !resourceFolder.isDirectory()) continue;
            AdditionalSourceRootUtil.addCompilerSourceRoot(project, resourceFolder);
        }
    }

    public static void addByBuildHelper(MojoExecution mojoExecution, MavenSession session, MavenProject project, Logger logger) {
        XmlPlexusConfiguration parentConfiguration = new XmlPlexusConfiguration(mojoExecution.getConfiguration());
        PlexusConfiguration configuration = parentConfiguration.getChild("sources");
        if (configuration == null) {
            return;
        }
        PlexusConfiguration[] sources = configuration.getChildren();
        if (sources == null) {
            return;
        }
        PluginParameterExpressionEvaluator expressionEvaluator = new PluginParameterExpressionEvaluator(session, mojoExecution);
        for (PlexusConfiguration source : sources) {
            AdditionalSourceRootUtil.addFile(AdditionalSourceRootUtil.evaluate((ExpressionEvaluator)expressionEvaluator, source.getValue(), logger), project, (ExpressionEvaluator)expressionEvaluator);
        }
    }

    public static void addByGeneratorMojo(MojoExecution mojoExecution, MavenSession session, MavenProject project, Logger logger) {
        PluginParameterExpressionEvaluator expressionEvaluator = new PluginParameterExpressionEvaluator(session, mojoExecution);
        XmlPlexusConfiguration configuration = new XmlPlexusConfiguration(mojoExecution.getConfiguration());
        for (String parameterName : new String[]{"baseOutputDirectory", "outputDirectory"}) {
            AdditionalSourceRootUtil.collectGeneratedSource((PlexusConfiguration)configuration, parameterName, project, expressionEvaluator, logger);
        }
    }

    private static void collectGeneratedSource(PlexusConfiguration parentConfiguration, String parameterName, MavenProject project, PluginParameterExpressionEvaluator expressionEvaluator, Logger logger) {
        PlexusConfiguration configuration = parentConfiguration.getChild(parameterName);
        if (configuration == null) {
            return;
        }
        String filepath = configuration.getValue();
        if (filepath == null) {
            String defaultValue = configuration.getAttribute("default-value");
            if (defaultValue == null) {
                return;
            }
            filepath = (String)AdditionalSourceRootUtil.evaluate((ExpressionEvaluator)expressionEvaluator, defaultValue, logger);
        }
        if (filepath != null) {
            AdditionalSourceRootUtil.addFile(filepath, project, (ExpressionEvaluator)expressionEvaluator);
        }
    }

    private static void addFile(Object path, MavenProject project, ExpressionEvaluator expressionEvaluator) {
        if (path == null) {
            return;
        }
        AdditionalSourceRootUtil.addCompilerSourceRoot(project, expressionEvaluator.alignToBaseDirectory(new File((String)path)));
    }
}

