/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.intentions;

import com.intellij.guice.GuiceBundle;
import com.intellij.guice.intentions.Intention;
import com.intellij.guice.intentions.MoveBindingScopeToClassPredicate;
import com.intellij.guice.intentions.PsiElementPredicate;
import com.intellij.guice.utils.GuiceUtils;
import com.intellij.guice.utils.MutationUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MoveBindingScopeToClassIntention
extends Intention {
    @NotNull
    public String getText() {
        String string = GuiceBundle.message("move.binding.scope.to.class.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/intentions/MoveBindingScopeToClassIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GuiceBundle.message("move.binding.scope.to.class.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/intentions/MoveBindingScopeToClassIntention", "getFamilyName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        MoveBindingScopeToClassPredicate moveBindingScopeToClassPredicate = new MoveBindingScopeToClassPredicate();
        if (moveBindingScopeToClassPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/intentions/MoveBindingScopeToClassIntention", "getElementPredicate"));
        }
        return moveBindingScopeToClassPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/guice/intentions/MoveBindingScopeToClassIntention", "processIntention"));
        }
        PsiMethodCallExpression originalCall = (PsiMethodCallExpression)element;
        PsiClass bindingClass = GuiceUtils.findImplementingClassForBinding(originalCall);
        PsiMethodCallExpression scopeCall = GuiceUtils.findScopeCallForBinding(originalCall);
        PsiExpression arg = scopeCall.getArgumentList().getExpressions()[0];
        String scopeAnnotation = GuiceUtils.getScopeAnnotationForScopeExpression(arg);
        MutationUtils.addAnnotation((PsiModifierListOwner)bindingClass, "@" + scopeAnnotation);
        PsiExpression qualifier = scopeCall.getMethodExpression().getQualifierExpression();
        assert (qualifier != null);
        MutationUtils.replaceExpression(qualifier.getText(), (PsiExpression)scopeCall);
    }
}

