/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jpa.model.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringImplicitBean;
import com.intellij.spring.model.custom.CustomLocalComponentsDiscoverer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringDataJpaAuditingBeansProvider
extends CustomLocalComponentsDiscoverer {
    private static final String ENABLE_JPA_AUDITING_ANNO = "org.springframework.data.jpa.repository.config.EnableJpaAuditing";
    private static final String AUDITING_ENTITY_LISTENER = "org.springframework.data.jpa.domain.support.AuditingEntityListener";
    private static final String JPA_MAPPING_CONTEXT = "org.springframework.data.jpa.xml.config.JpaMetamodelMappingContextFactoryBean";

    @NotNull
    public Collection<CommonSpringBean> getCustomComponents(@NotNull LocalModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/data/jpa/model/jam/SpringDataJpaAuditingBeansProvider", "getCustomComponents"));
        }
        Module module = model.getModule();
        if (module == null || module.isDisposed() || !(model instanceof LocalAnnotationModel)) {
            Set<CommonSpringBean> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/jpa/model/jam/SpringDataJpaAuditingBeansProvider", "getCustomComponents"));
            }
            return set;
        }
        PsiClass psiClass = (PsiClass)((LocalAnnotationModel)model).getConfig();
        List beans = ContainerUtil.newSmartList();
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)ENABLE_JPA_AUDITING_ANNO, (boolean)true)) {
            ContainerUtil.addIfNotNull((Collection)beans, (Object)SpringImplicitBean.create((Module)module, (String)"@EnableJpaAuditing", (String)AUDITING_ENTITY_LISTENER, (String)"auditingEntityListener"));
            ContainerUtil.addIfNotNull((Collection)beans, (Object)SpringImplicitBean.create((Module)module, (String)"@EnableJpaAuditing", (String)JPA_MAPPING_CONTEXT, (String)"jpaMappingContext"));
        }
        List list = beans;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/jpa/model/jam/SpringDataJpaAuditingBeansProvider", "getCustomComponents"));
        }
        return list;
    }
}

