/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitNewBranchOptions;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0015"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "collectData", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "createBranch", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "createBranchStartingFrom", "repository", "commit", "Lcom/intellij/vcs/log/Hash;", "update", "Data", "git4idea"})
public final class GitCreateNewBranchAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Data data;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Data data2 = data = this.collectData(e);
        if (data2 instanceof Data.WithCommit) {
            this.createBranchStartingFrom(((Data.WithCommit)data).getRepository(), ((Data.WithCommit)data).getHash());
        } else if (data2 instanceof Data.NoCommit) {
            this.createBranch(((Data.NoCommit)data).getProject(), ((Data.NoCommit)data).getRepositories());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Data data;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        super.update(e);
        Data data2 = data = this.collectData(e);
        if (data2 instanceof Data.Invisible) {
            e.getPresentation().setEnabledAndVisible(false);
        } else if (data2 instanceof Data.Disabled) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(false);
        } else {
            e.getPresentation().setEnabledAndVisible(true);
        }
    }

    private final Data collectData(AnActionEvent e) {
        List repositories;
        Project project;
        block18: {
            block17: {
                boolean bl;
                block16: {
                    List list;
                    Project project2 = e.getProject();
                    if (project2 == null) {
                        return new Data.Invisible();
                    }
                    project = project2;
                    GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
                    if (manager.getRepositories().isEmpty()) {
                        return new Data.Invisible();
                    }
                    VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
                    if (log != null) {
                        List commits2 = log.getSelectedCommits();
                        if (commits2.isEmpty()) {
                            return new Data.Invisible();
                        }
                        if (commits2.size() > 1) {
                            return new Data.Disabled();
                        }
                        CommitId commit = (CommitId)CollectionsKt.first((List)commits2);
                        GitRepository repository = (GitRepository)manager.getRepositoryForRootQuick(commit.getRoot());
                        if (repository != null) {
                            Hash hash = commit.getHash();
                            Intrinsics.checkExpressionValueIsNotNull((Object)hash, (String)"commit.hash");
                            return new Data.WithCommit(repository, hash);
                        }
                    }
                    if (manager.moreThanOneRoot()) {
                        if (Intrinsics.areEqual((Object)GitVcsSettings.getInstance(project).getSyncSetting(), (Object)DvcsSyncSettings.Value.SYNC)) {
                            list = manager.getRepositories();
                        } else {
                            GitRepository repository;
                            GitRepository gitRepository = repository = (GitRepository)manager.getRepositoryForRootQuick(DvcsUtil.guessVcsRoot((Project)project, (VirtualFile)((VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE))));
                            if (gitRepository != null) {
                                Object object;
                                Object it = object = gitRepository;
                                list = CollectionsKt.listOf((Object)repository);
                            } else {
                                list = null;
                            }
                        }
                    } else {
                        list = repositories = CollectionsKt.listOf((Object)CollectionsKt.first(manager.getRepositories()));
                    }
                    if (repositories == null) break block17;
                    Iterable $receiver$iv = repositories;
                    for (Object element$iv : $receiver$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        if (!it.isFresh()) continue;
                        bl = true;
                        break block16;
                    }
                    bl = false;
                }
                if (!bl) break block18;
            }
            return new Data.Invisible();
        }
        Project project3 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        return new Data.NoCommit(project3, repositories);
    }

    /*
     * WARNING - void declaration
     */
    public final void createBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        GitNewBranchOptions options = GitBranchUtil.getNewBranchNameFromUser(project, (Collection<GitRepository>)repositories, "Create New Branch");
        if (options != null) {
            GitBrancher brancher = GitBrancher.getInstance(project);
            if (options.shouldCheckout()) {
                brancher.checkoutNewBranch(options.getName(), repositories);
            } else {
                Collection<Pair> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = repositories;
                String string = options.getName();
                GitBrancher gitBrancher = brancher;
                void var6_8 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    GitRepository gitRepository = (GitRepository)item$iv$iv;
                    collection = destination$iv$iv;
                    Pair pair = TuplesKt.to((Object)it, (Object)"HEAD");
                    collection.add(pair);
                }
                collection = (List)destination$iv$iv;
                gitBrancher.createBranch(string, MapsKt.toMap((Iterable)collection));
            }
        }
    }

    public final void createBranchStartingFrom(@NotNull GitRepository repository, @NotNull Hash commit) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        Project project = repository.getProject();
        GitNewBranchOptions options = GitBranchUtil.getNewBranchNameFromUser(project, SetsKt.setOf((Object)repository), "Create New Branch From " + commit.toShortString());
        if (options != null) {
            GitBrancher brancher = GitBrancher.getInstance(project);
            if (options.shouldCheckout()) {
                brancher.checkoutNewBranchStartingFrom(options.getName(), commit.asString(), CollectionsKt.listOf((Object)repository), null);
            } else {
                brancher.createBranch(options.getName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)repository, (Object)commit.asString())));
            }
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data;", "", "()V", "Disabled", "Invisible", "NoCommit", "WithCommit", "Lgit4idea/actions/GitCreateNewBranchAction$Data$Invisible;", "Lgit4idea/actions/GitCreateNewBranchAction$Data$Disabled;", "Lgit4idea/actions/GitCreateNewBranchAction$Data$WithCommit;", "Lgit4idea/actions/GitCreateNewBranchAction$Data$NoCommit;", "git4idea"})
    private static abstract class Data {
        private Data() {
        }

        public /* synthetic */ Data(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data$Invisible;", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "()V", "git4idea"})
        public static final class Invisible
        extends Data {
            public Invisible() {
                super(null);
            }
        }

        @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data$Disabled;", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "()V", "git4idea"})
        public static final class Disabled
        extends Data {
            public Disabled() {
                super(null);
            }
        }

        @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data$WithCommit;", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "repository", "Lgit4idea/repo/GitRepository;", "hash", "Lcom/intellij/vcs/log/Hash;", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/Hash;)V", "getHash", "()Lcom/intellij/vcs/log/Hash;", "getRepository", "()Lgit4idea/repo/GitRepository;", "git4idea"})
        public static final class WithCommit
        extends Data {
            @NotNull
            private final GitRepository repository;
            @NotNull
            private final Hash hash;

            @NotNull
            public final GitRepository getRepository() {
                return this.repository;
            }

            @NotNull
            public final Hash getHash() {
                return this.hash;
            }

            public WithCommit(@NotNull GitRepository repository, @NotNull Hash hash) {
                Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
                Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
                super(null);
                this.repository = repository;
                this.hash = hash;
            }
        }

        @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data$NoCommit;", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRepositories", "()Ljava/util/List;", "git4idea"})
        public static final class NoCommit
        extends Data {
            @NotNull
            private final Project project;
            @NotNull
            private final List<GitRepository> repositories;

            @NotNull
            public final Project getProject() {
                return this.project;
            }

            @NotNull
            public final List<GitRepository> getRepositories() {
                return this.repositories;
            }

            public NoCommit(@NotNull Project project, @NotNull List<? extends GitRepository> repositories) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
                super(null);
                this.project = project;
                this.repositories = repositories;
            }
        }
    }
}

