/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.vcs.AnnotationProviderEx;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.annotate.GitFileAnnotation;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.history.GitHistoryProvider;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.util.StringScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitAnnotationProvider
implements AnnotationProviderEx {
    private final Project myProject;
    @NonNls
    private static final String SUBJECT_KEY = "summary";
    @NonNls
    private static final String FILENAME_KEY = "filename";
    @NonNls
    private static final String PREVIOUS_KEY = "previous";
    @NonNls
    private static final String AUTHOR_KEY = "author";
    @NonNls
    private static final String AUTHOR_EMAIL_KEY = "author-mail";
    @NonNls
    private static final String COMMITTER_TIME_KEY = "committer-time";
    private static final Logger LOG = Logger.getInstance(GitAnnotationProvider.class);
    @NotNull
    private final VcsHistoryCache myCache;
    @NotNull
    private final VcsUserRegistry myUserRegistry;

    public GitAnnotationProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/annotate/GitAnnotationProvider", "<init>"));
        }
        this.myProject = project;
        this.myCache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsHistoryCache();
        this.myUserRegistry = (VcsUserRegistry)ServiceManager.getService((Project)project, VcsUserRegistry.class);
    }

    public boolean isCaching() {
        return true;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/annotate/GitAnnotationProvider", "annotate"));
        }
        FileAnnotation fileAnnotation = this.annotate(file, null);
        if (fileAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitAnnotationProvider", "annotate"));
        }
        return fileAnnotation;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file, @Nullable VcsFileRevision revision) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/annotate/GitAnnotationProvider", "annotate"));
        }
        if (file.isDirectory()) {
            throw new VcsException("Cannot annotate a directory");
        }
        FilePath currentFilePath = VcsUtil.getFilePath((String)file.getPath());
        FilePath realFilePath = revision == null ? GitHistoryUtils.getLastCommitName(this.myProject, currentFilePath) : ((VcsFileRevisionEx)revision).getPath();
        VcsRevisionNumber revisionNumber = revision != null ? revision.getRevisionNumber() : null;
        GitFileAnnotation gitFileAnnotation = this.annotate(realFilePath, revisionNumber, file);
        if (gitFileAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitAnnotationProvider", "annotate"));
        }
        return gitFileAnnotation;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull FilePath path, @NotNull VcsRevisionNumber revision) throws VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/annotate/GitAnnotationProvider", "annotate"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "git4idea/annotate/GitAnnotationProvider", "annotate"));
        }
        GitFileRevision fileRevision = new GitFileRevision(this.myProject, path, (GitRevisionNumber)revision);
        VcsVirtualFile file = new VcsVirtualFile(path.getPath(), (VcsFileRevision)fileRevision, (VirtualFileSystem)VcsFileSystem.getInstance());
        GitFileAnnotation gitFileAnnotation = this.annotate(path, revision, (VirtualFile)file);
        if (gitFileAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitAnnotationProvider", "annotate"));
        }
        return gitFileAnnotation;
    }

    private static void setProgressIndicatorText(@Nullable String text) {
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            progress.setText(text);
        }
    }

    @NotNull
    private GitFileAnnotation annotate(@NotNull FilePath repositoryFilePath, @Nullable VcsRevisionNumber revision, @NotNull VirtualFile file) throws VcsException {
        Object annotatedData;
        VcsRevisionNumber actualRevision;
        if (repositoryFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryFilePath", "git4idea/annotate/GitAnnotationProvider", "annotate"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/annotate/GitAnnotationProvider", "annotate"));
        }
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        assert (vcs != null);
        VcsRevisionNumber vcsRevisionNumber = actualRevision = revision != null ? revision : vcs.getDiffProvider().getCurrentRevision(file);
        if (actualRevision != null && (annotatedData = this.myCache.get(repositoryFilePath, GitVcs.getKey(), actualRevision)) instanceof CachedData) {
            GitFileAnnotation gitFileAnnotation = this.restoreFromCache(file, actualRevision, (CachedData)annotatedData);
            if (gitFileAnnotation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitAnnotationProvider", "annotate"));
            }
            return gitFileAnnotation;
        }
        GitFileAnnotation fileAnnotation = this.doAnnotate(repositoryFilePath, actualRevision, file);
        if (actualRevision != null) {
            this.myCache.put(repositoryFilePath, GitVcs.getKey(), actualRevision, (Object)this.cacheData(fileAnnotation));
        }
        GitFileAnnotation gitFileAnnotation = fileAnnotation;
        if (gitFileAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitAnnotationProvider", "annotate"));
        }
        return gitFileAnnotation;
    }

    @NotNull
    private GitFileAnnotation doAnnotate(@NotNull FilePath repositoryFilePath, @Nullable VcsRevisionNumber revision, @NotNull VirtualFile file) throws VcsException {
        if (repositoryFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryFilePath", "git4idea/annotate/GitAnnotationProvider", "doAnnotate"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/annotate/GitAnnotationProvider", "doAnnotate"));
        }
        GitAnnotationProvider.setProgressIndicatorText(GitBundle.message("computing.annotation", file.getName()));
        VirtualFile root = GitUtil.getGitRoot(repositoryFilePath);
        GitSimpleHandler h = new GitSimpleHandler(this.myProject, root, GitCommand.BLAME);
        h.setStdoutSuppressed(true);
        h.addParameters("--porcelain", "-l", "-t", "-w");
        if (revision == null) {
            h.addParameters("HEAD");
        } else {
            h.addParameters(revision.asString());
        }
        h.endOptions();
        h.addRelativePaths(repositoryFilePath);
        String output = h.run();
        GitFileAnnotation fileAnnotation = this.parseAnnotations(revision, file, root, output);
        this.loadFileHistoryInBackground(fileAnnotation);
        GitFileAnnotation gitFileAnnotation = fileAnnotation;
        if (gitFileAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitAnnotationProvider", "doAnnotate"));
        }
        return gitFileAnnotation;
    }

    private void loadFileHistoryInBackground(@NotNull GitFileAnnotation fileAnnotation) {
        if (fileAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAnnotation", "git4idea/annotate/GitAnnotationProvider", "loadFileHistoryInBackground"));
        }
        List fileRevisions = (List)BackgroundTaskUtil.computeInBackgroundAndTryWait(() -> {
            if (fileAnnotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAnnotation", "git4idea/annotate/GitAnnotationProvider", "lambda$loadFileHistoryInBackground$0"));
            }
            try {
                VirtualFile file = fileAnnotation.getFile();
                FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
                VcsRevisionNumber currentRevision = fileAnnotation.getCurrentRevision();
                if (file.isInLocalFileSystem() || currentRevision == null) {
                    return this.loadFileHistory(filePath);
                }
                return GitHistoryUtils.history(this.myProject, filePath, null, currentRevision, new String[0]);
            }
            catch (VcsException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }, revisions -> {
            if (fileAnnotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAnnotation", "git4idea/annotate/GitAnnotationProvider", "lambda$loadFileHistoryInBackground$2"));
            }
            if (revisions == null) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (fileAnnotation == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAnnotation", "git4idea/annotate/GitAnnotationProvider", "lambda$null$1"));
                }
                GitFileAnnotation newFileAnnotation = new GitFileAnnotation(fileAnnotation);
                newFileAnnotation.setRevisions((List<VcsFileRevision>)revisions);
                fileAnnotation.reload(newFileAnnotation);
            }, this.myProject.getDisposed());
        }, (long)300L);
        if (fileRevisions != null) {
            fileAnnotation.setRevisions(fileRevisions);
        }
    }

    @Nullable
    private List<VcsFileRevision> loadFileHistory(@NotNull FilePath filePath) throws VcsException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/annotate/GitAnnotationProvider", "loadFileHistory"));
        }
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        if (vcs == null) {
            return null;
        }
        GitHistoryProvider historyProvider = vcs.getVcsHistoryProvider();
        VcsAbstractHistorySession cachedSession = this.myCache.getFull(filePath, vcs.getKeyInstanceMethod(), (VcsCacheableHistorySessionFactory)historyProvider);
        if (cachedSession != null && !ContainerUtil.isEmpty((Collection)cachedSession.getRevisionList())) {
            return cachedSession.getRevisionList();
        }
        VcsAbstractHistorySession session = historyProvider.createSessionFor(filePath);
        if (session == null) {
            return null;
        }
        this.myCache.put(filePath, null, vcs.getKeyInstanceMethod(), session, (VcsCacheableHistorySessionFactory)historyProvider, true);
        return session.getRevisionList();
    }

    @NotNull
    private GitFileAnnotation parseAnnotations(@Nullable VcsRevisionNumber revision, @NotNull VirtualFile file, @NotNull VirtualFile root, @NotNull String output) throws VcsException {
        GitFileAnnotation gitFileAnnotation;
        block19: {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/annotate/GitAnnotationProvider", "parseAnnotations"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/annotate/GitAnnotationProvider", "parseAnnotations"));
            }
            if (output == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "git4idea/annotate/GitAnnotationProvider", "parseAnnotations"));
            }
            Interner pathInterner = new Interner();
            try {
                ArrayList<GitFileAnnotation.LineInfo> lines = new ArrayList<GitFileAnnotation.LineInfo>();
                HashMap<String, GitFileAnnotation.LineInfo> commits2 = new HashMap<String, GitFileAnnotation.LineInfo>();
                StringScanner s = new StringScanner(output);
                while (s.hasMoreData()) {
                    String commitHash = s.spaceToken();
                    if (commitHash.equals(GitRevisionNumber.NOT_COMMITTED_HASH)) {
                        commitHash = null;
                    }
                    s.spaceToken();
                    String s1 = s.spaceToken();
                    int lineNum = Integer.parseInt(s1);
                    s.nextLine();
                    GitFileAnnotation.LineInfo commit = (GitFileAnnotation.LineInfo)commits2.get(commitHash);
                    if (commit != null || commitHash == null) {
                        while (s.hasMoreData() && !s.startsWith('\t')) {
                            s.nextLine();
                        }
                    } else {
                        Date committerDate = null;
                        FilePath filePath = null;
                        String subject = null;
                        String authorName = null;
                        String authorEmail = null;
                        String previousRevision = null;
                        FilePath previousFilePath = null;
                        while (s.hasMoreData() && !s.startsWith('\t')) {
                            int index;
                            String key = s.spaceToken();
                            String value = s.line();
                            if (SUBJECT_KEY.equals(key)) {
                                subject = value;
                                continue;
                            }
                            if (AUTHOR_KEY.equals(key)) {
                                authorName = value;
                                continue;
                            }
                            if (COMMITTER_TIME_KEY.equals(key)) {
                                committerDate = GitUtil.parseTimestamp(value);
                                continue;
                            }
                            if (FILENAME_KEY.equals(key)) {
                                filePath = VcsUtil.getFilePath((VirtualFile)root, (String)value);
                                continue;
                            }
                            if (AUTHOR_EMAIL_KEY.equals(key)) {
                                authorEmail = value;
                                if (!authorEmail.startsWith("<") || !authorEmail.endsWith(">")) continue;
                                authorEmail = authorEmail.substring(1, authorEmail.length() - 1);
                                continue;
                            }
                            if (!PREVIOUS_KEY.equals(key) || (index = value.indexOf(32)) == -1) continue;
                            previousRevision = value.substring(0, index);
                            previousFilePath = VcsUtil.getFilePath((VirtualFile)root, (String)value.substring(index + 1, value.length()));
                        }
                        if (committerDate == null || filePath == null || authorName == null || authorEmail == null || subject == null) {
                            throw new VcsException("Output for line " + lineNum + " lacks necessary data");
                        }
                        GitRevisionNumber revisionNumber = new GitRevisionNumber(commitHash, committerDate);
                        VcsUser author = this.myUserRegistry.createUser(authorName, authorEmail);
                        GitRevisionNumber previousRevisionNumber = previousRevision != null ? new GitRevisionNumber(previousRevision) : null;
                        filePath = (FilePath)pathInterner.intern(filePath);
                        if (previousFilePath != null) {
                            previousFilePath = (FilePath)pathInterner.intern(previousFilePath);
                        }
                        commit = new GitFileAnnotation.LineInfo(this.myProject, revisionNumber, filePath, committerDate, author, subject, previousRevisionNumber, previousFilePath);
                        commits2.put(commitHash, commit);
                    }
                    s.nextLine();
                    int expectedLineNum = lines.size() + 1;
                    if (lineNum != expectedLineNum) {
                        throw new VcsException("Adding for info for line " + lineNum + " but we are expecting it to be for " + expectedLineNum);
                    }
                    lines.add(commit);
                }
                gitFileAnnotation = new GitFileAnnotation(this.myProject, file, revision, lines);
                if (gitFileAnnotation != null) break block19;
            }
            catch (Exception e) {
                LOG.error("Couldn't parse annotation: " + e, new Attachment[]{new Attachment("output.txt", output)});
                throw new VcsException((Throwable)e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitAnnotationProvider", "parseAnnotations"));
        }
        return gitFileAnnotation;
    }

    @NotNull
    private GitFileAnnotation restoreFromCache(@NotNull VirtualFile file, @Nullable VcsRevisionNumber revisionNumber, @NotNull CachedData data) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/annotate/GitAnnotationProvider", "restoreFromCache"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "git4idea/annotate/GitAnnotationProvider", "restoreFromCache"));
        }
        GitFileAnnotation fileAnnotation = new GitFileAnnotation(this.myProject, file, revisionNumber, data.lines);
        this.loadFileHistoryInBackground(fileAnnotation);
        GitFileAnnotation gitFileAnnotation = fileAnnotation;
        if (gitFileAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitAnnotationProvider", "restoreFromCache"));
        }
        return gitFileAnnotation;
    }

    @NotNull
    private CachedData cacheData(@NotNull GitFileAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "git4idea/annotate/GitAnnotationProvider", "cacheData"));
        }
        CachedData cachedData = new CachedData(annotation.getLines());
        if (cachedData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitAnnotationProvider", "cacheData"));
        }
        return cachedData;
    }

    private static class CachedData {
        public final List<GitFileAnnotation.LineInfo> lines;

        public CachedData(List<GitFileAnnotation.LineInfo> lines) {
            this.lines = lines;
        }
    }
}

