/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.LogDataImpl;
import com.intellij.vcs.log.util.StopWatch;
import git4idea.GitCommit;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitSimpleHandler;
import git4idea.commands.GitTextHandler;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitLogOutputSplitter;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogRecordCollector;
import git4idea.log.GitLogProvider;
import git4idea.log.GitRefManager;
import git4idea.util.GitUIUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogUtil {
    private static final Logger LOG = Logger.getInstance(GitLogUtil.class);
    public static final List<String> LOG_ALL = Arrays.asList("HEAD", "--branches", "--remotes", "--tags");
    public static final String STDIN = "--stdin";

    @NotNull
    public static List<? extends VcsShortCommitDetails> collectShortDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> hashes2) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitLogUtil", "collectShortDetails"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitLogUtil", "collectShortDetails"));
        }
        if (hashes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "git4idea/history/GitLogUtil", "collectShortDetails"));
        }
        VcsLogObjectsFactory factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogUtil", "collectShortDetails"));
            }
            return list;
        }
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.AUTHOR_TIME);
        h.setSilent(true);
        h.addParameters("--no-walk");
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(new ArrayList<String>(hashes2));
        h.endOptions();
        String output = h.run();
        List<GitLogRecord> records = parser.parse(output);
        List list = ContainerUtil.map(records, record -> {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitLogUtil", "lambda$collectShortDetails$0"));
            }
            SmartList parents = new SmartList();
            for (String parent : record.getParentsHashes()) {
                parents.add(HashImpl.build((String)parent));
            }
            return factory.createShortDetails(HashImpl.build((String)record.getHash()), (List)parents, record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail(), record.getCommitterName(), record.getCommitterEmail(), record.getAuthorTimeStamp());
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogUtil", "collectShortDetails"));
        }
        return list;
    }

    public static void readTimedCommits(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> parameters, @NotNull Consumer<VcsUser> userConsumer, @NotNull Consumer<VcsRef> refConsumer, @NotNull Consumer<TimedVcsCommit> commitConsumer) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitLogUtil", "readTimedCommits"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitLogUtil", "readTimedCommits"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "git4idea/history/GitLogUtil", "readTimedCommits"));
        }
        if (userConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userConsumer", "git4idea/history/GitLogUtil", "readTimedCommits"));
        }
        if (refConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refConsumer", "git4idea/history/GitLogUtil", "readTimedCommits"));
        }
        if (commitConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitConsumer", "git4idea/history/GitLogUtil", "readTimedCommits"));
        }
        VcsLogObjectsFactory factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return;
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.REF_NAMES);
        handler.setStdoutSuppressed(true);
        handler.addParameters(parser.getPretty(), "--encoding=UTF-8");
        handler.addParameters("--decorate=full");
        handler.addParameters(parameters);
        handler.endOptions();
        GitLogOutputSplitter handlerListener = new GitLogOutputSplitter(handler, (Consumer<StringBuilder>)((Consumer)output -> {
            if (commitConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitConsumer", "git4idea/history/GitLogUtil", "lambda$readTimedCommits$1"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitLogUtil", "lambda$readTimedCommits$1"));
            }
            if (refConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refConsumer", "git4idea/history/GitLogUtil", "lambda$readTimedCommits$1"));
            }
            if (userConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userConsumer", "git4idea/history/GitLogUtil", "lambda$readTimedCommits$1"));
            }
            List<GitLogRecord> records = parser.parse((CharSequence)output);
            for (GitLogRecord record : records) {
                if (record == null) continue;
                Hash hash = HashImpl.build((String)record.getHash());
                List<Hash> parents = GitLogUtil.getParentHashes(factory, record);
                commitConsumer.consume((Object)factory.createTimedCommit(hash, parents, record.getCommitTime()));
                for (VcsRef ref : GitLogUtil.parseRefs(record.getRefs(), hash, factory, root)) {
                    refConsumer.consume((Object)ref);
                }
                userConsumer.consume((Object)factory.createUser(record.getAuthorName(), record.getAuthorEmail()));
            }
        }));
        handler.runInCurrentThread(null);
        handlerListener.reportErrors();
    }

    @NotNull
    private static Collection<VcsRef> parseRefs(@NotNull Collection<String> refs, @NotNull Hash hash, @NotNull VcsLogObjectsFactory factory, @NotNull VirtualFile root) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "git4idea/history/GitLogUtil", "parseRefs"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "git4idea/history/GitLogUtil", "parseRefs"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "git4idea/history/GitLogUtil", "parseRefs"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitLogUtil", "parseRefs"));
        }
        List list = ContainerUtil.mapNotNull(refs, refName -> {
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "git4idea/history/GitLogUtil", "lambda$parseRefs$2"));
            }
            if (hash == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "git4idea/history/GitLogUtil", "lambda$parseRefs$2"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitLogUtil", "lambda$parseRefs$2"));
            }
            if (refName.equals("grafted") || refName.equals("replaced")) {
                return null;
            }
            VcsRefType type = GitRefManager.getRefType(refName);
            return (refName = GitBranchUtil.stripRefsPrefix(refName)).equals("origin/HEAD") ? null : factory.createRef(hash, refName, type, root);
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogUtil", "parseRefs"));
        }
        return list;
    }

    @NotNull
    public static VcsLogProvider.DetailedLogData collectMetadata(@NotNull Project project, @NotNull VirtualFile root, String ... params) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitLogUtil", "collectMetadata"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitLogUtil", "collectMetadata"));
        }
        VcsLogObjectsFactory factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            LogDataImpl logDataImpl = LogDataImpl.empty();
            if (logDataImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogUtil", "collectMetadata"));
            }
            return logDataImpl;
        }
        OpenTHashSet refs = new OpenTHashSet(GitLogProvider.DONT_CONSIDER_SHA);
        List<VcsCommitMetadata> commits2 = GitLogUtil.collectMetadata(project, root, (NullableFunction<GitLogRecord, VcsCommitMetadata>)((NullableFunction)arg_0 -> GitLogUtil.lambda$collectMetadata$4(project, root, factory, (Set)refs, arg_0)), params);
        LogDataImpl logDataImpl = new LogDataImpl((Set)refs, commits2);
        if (logDataImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogUtil", "collectMetadata"));
        }
        return logDataImpl;
    }

    @NotNull
    private static List<VcsCommitMetadata> collectMetadata(@NotNull Project project, @NotNull VirtualFile root, @NotNull NullableFunction<GitLogRecord, VcsCommitMetadata> converter, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitLogUtil", "collectMetadata"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitLogUtil", "collectMetadata"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "git4idea/history/GitLogUtil", "collectMetadata"));
        }
        ArrayList commits2 = ContainerUtil.newArrayList();
        try {
            GitLogUtil.readRecords(project, root, true, false, false, (Consumer<GitLogRecord>)((Consumer)record -> {
                if (converter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "git4idea/history/GitLogUtil", "lambda$collectMetadata$5"));
                }
                commits2.add(converter.fun(record));
            }), parameters);
        }
        catch (VcsException e) {
            if (commits2.isEmpty()) {
                throw e;
            }
            LOG.warn("Error during loading details, returning partially loaded commits\n", (Throwable)e);
        }
        ArrayList arrayList = commits2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogUtil", "collectMetadata"));
        }
        return arrayList;
    }

    @Nullable
    public static VcsLogObjectsFactory getObjectsFactoryWithDisposeCheck(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitLogUtil", "getObjectsFactoryWithDisposeCheck"));
        }
        return (VcsLogObjectsFactory)ReadAction.compute(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitLogUtil", "lambda$getObjectsFactoryWithDisposeCheck$6"));
            }
            if (!project.isDisposed()) {
                return (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
            }
            return null;
        });
    }

    @NotNull
    private static GitCommit createCommit(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<GitLogRecord> records, @NotNull VcsLogObjectsFactory factory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitLogUtil", "createCommit"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitLogUtil", "createCommit"));
        }
        if (records == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "git4idea/history/GitLogUtil", "createCommit"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "git4idea/history/GitLogUtil", "createCommit"));
        }
        GitLogRecord record = (GitLogRecord)ObjectUtils.notNull((Object)ContainerUtil.getLastItem(records));
        List<Hash> parents = GitLogUtil.getParentHashes(factory, record);
        GitCommit gitCommit = new GitCommit(project, HashImpl.build((String)record.getHash()), parents, record.getCommitTime(), root, record.getSubject(), factory.createUser(record.getAuthorName(), record.getAuthorEmail()), record.getFullMessage(), factory.createUser(record.getCommitterName(), record.getCommitterEmail()), record.getAuthorTimeStamp(), ContainerUtil.map(records, GitLogRecord::getStatusInfos));
        if (gitCommit == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogUtil", "createCommit"));
        }
        return gitCommit;
    }

    @NotNull
    public static List<Hash> getParentHashes(@NotNull VcsLogObjectsFactory factory, @NotNull GitLogRecord record) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "git4idea/history/GitLogUtil", "getParentHashes"));
        }
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "git4idea/history/GitLogUtil", "getParentHashes"));
        }
        List list = ContainerUtil.map((Object[])record.getParentsHashes(), arg_0 -> ((VcsLogObjectsFactory)factory).createHash(arg_0));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogUtil", "getParentHashes"));
        }
        return list;
    }

    @NotNull
    public static List<GitCommit> collectFullDetails(@NotNull Project project, @NotNull VirtualFile root, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitLogUtil", "collectFullDetails"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitLogUtil", "collectFullDetails"));
        }
        ArrayList commits2 = ContainerUtil.newArrayList();
        try {
            GitLogUtil.readFullDetails(project, root, (Consumer<? super GitCommit>)((Consumer)commits2::add), parameters);
        }
        catch (VcsException e) {
            if (commits2.isEmpty()) {
                throw e;
            }
            LOG.warn("Error during loading details, returning partially loaded commits\n", (Throwable)e);
        }
        ArrayList arrayList = commits2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogUtil", "collectFullDetails"));
        }
        return arrayList;
    }

    public static void readFullDetails(final @NotNull Project project, final @NotNull VirtualFile root, final @NotNull Consumer<? super GitCommit> commitConsumer, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitLogUtil", "readFullDetails"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitLogUtil", "readFullDetails"));
        }
        if (commitConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitConsumer", "git4idea/history/GitLogUtil", "readFullDetails"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "git4idea/history/GitLogUtil", "readFullDetails"));
        }
        final VcsLogObjectsFactory factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return;
        }
        GitLogRecordCollector recordCollector = new GitLogRecordCollector(project, root){

            @Override
            public void consume(@NotNull List<GitLogRecord> records) {
                if (records == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "git4idea/history/GitLogUtil$1", "consume"));
                }
                commitConsumer.consume((Object)GitLogUtil.createCommit(project, root, records, factory));
            }
        };
        GitLogUtil.readRecords(project, root, false, true, true, recordCollector, parameters);
        recordCollector.finish();
    }

    private static void readRecords(@NotNull Project project, @NotNull VirtualFile root, boolean withRefs, boolean withChanges, boolean fast, @NotNull Consumer<GitLogRecord> converter, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitLogUtil", "readRecords"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitLogUtil", "readRecords"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "git4idea/history/GitLogUtil", "readRecords"));
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.LOG, GitLogUtil.createConfigParameters(withChanges, fast));
        GitLogUtil.readRecordsFromHandler(project, root, withRefs, withChanges, converter, handler, parameters);
    }

    private static void readRecordsFromHandler(@NotNull Project project, @NotNull VirtualFile root, boolean withRefs, boolean withChanges, @NotNull Consumer<GitLogRecord> converter, @NotNull GitLineHandler handler, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitLogUtil", "readRecordsFromHandler"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitLogUtil", "readRecordsFromHandler"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "git4idea/history/GitLogUtil", "readRecordsFromHandler"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "git4idea/history/GitLogUtil", "readRecordsFromHandler"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "git4idea/history/GitLogUtil", "readRecordsFromHandler"));
        }
        GitLogParser parser = GitLogUtil.createParserForDetails(handler, project, withRefs, withChanges, parameters);
        StopWatch sw = StopWatch.start((String)("loading details in [" + root.getName() + "]"));
        Ref parseError = new Ref();
        GitLogOutputSplitter handlerListener = new GitLogOutputSplitter(handler, (Consumer<StringBuilder>)((Consumer)output -> {
            block6: {
                if (converter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "git4idea/history/GitLogUtil", "lambda$readRecordsFromHandler$7"));
                }
                if (handler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "git4idea/history/GitLogUtil", "lambda$readRecordsFromHandler$7"));
                }
                try {
                    GitLogRecord record = parser.parseOneRecord((CharSequence)output);
                    if (record != null) {
                        converter.consume((Object)record);
                    }
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Throwable t) {
                    if (!parseError.isNull()) break block6;
                    parseError.set((Object)t);
                    LOG.error("Could not parse \" " + GitLogParser.getTruncatedEscapedOutput(output) + "\"\nCommand " + handler.printableCommandLine(), t);
                }
            }
        }));
        handler.runInCurrentThread(null);
        handlerListener.reportErrors();
        if (!parseError.isNull()) {
            throw new VcsException((Throwable)parseError.get());
        }
        sw.report();
    }

    @NotNull
    private static GitLogParser createParserForDetails(@NotNull GitTextHandler h, @NotNull Project project, boolean withRefs, boolean withChanges, String ... parameters) {
        if (h == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "h", "git4idea/history/GitLogUtil", "createParserForDetails"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitLogUtil", "createParserForDetails"));
        }
        GitLogParser.NameStatus status = withChanges ? GitLogParser.NameStatus.STATUS : GitLogParser.NameStatus.NONE;
        GitLogParser.GitLogOption[] options = new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY};
        if (withRefs) {
            options = (GitLogParser.GitLogOption[])ArrayUtil.append((Object[])options, (Object)((Object)GitLogParser.GitLogOption.REF_NAMES));
        }
        GitLogParser parser = new GitLogParser(project, status, options);
        h.setStdoutSuppressed(true);
        h.addParameters(parameters);
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        if (withRefs) {
            h.addParameters("--decorate=full");
        }
        if (withChanges) {
            h.addParameters("-M", "--name-status", "-m");
        }
        h.endOptions();
        GitLogParser gitLogParser = parser;
        if (gitLogParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogUtil", "createParserForDetails"));
        }
        return gitLogParser;
    }

    public static void readFullDetailsForHashes(final @NotNull Project project, final @NotNull VirtualFile root, @NotNull GitVcs vcs, final @NotNull Consumer<? super GitCommit> commitConsumer, @NotNull List<String> hashes2, boolean fast) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitLogUtil", "readFullDetailsForHashes"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitLogUtil", "readFullDetailsForHashes"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "git4idea/history/GitLogUtil", "readFullDetailsForHashes"));
        }
        if (commitConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitConsumer", "git4idea/history/GitLogUtil", "readFullDetailsForHashes"));
        }
        if (hashes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "git4idea/history/GitLogUtil", "readFullDetailsForHashes"));
        }
        final VcsLogObjectsFactory factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return;
        }
        GitLogRecordCollector recordCollector = new GitLogRecordCollector(project, root){

            @Override
            public void consume(@NotNull List<GitLogRecord> records) {
                if (records == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "git4idea/history/GitLogUtil$2", "consume"));
                }
                commitConsumer.consume((Object)GitLogUtil.createCommit(project, root, records, factory));
            }
        };
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.LOG, GitLogUtil.createConfigParameters(true, fast));
        GitLogUtil.sendHashesToStdin(vcs, hashes2, handler);
        GitLogUtil.readRecordsFromHandler(project, root, false, true, recordCollector, handler, GitLogUtil.getNoWalkParameter(vcs), STDIN);
        recordCollector.finish();
        if (!handler.errors().isEmpty()) {
            throw new VcsException(GitUIUtil.stringifyErrors(handler.errors()));
        }
    }

    public static void sendHashesToStdin(@NotNull GitVcs vcs, @NotNull Collection<String> hashes2, @NotNull GitHandler handler) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "git4idea/history/GitLogUtil", "sendHashesToStdin"));
        }
        if (hashes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "git4idea/history/GitLogUtil", "sendHashesToStdin"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "git4idea/history/GitLogUtil", "sendHashesToStdin"));
        }
        String separator = GitLogUtil.getSeparator(vcs);
        handler.setInputProcessor((ThrowableConsumer<OutputStream, IOException>)((ThrowableConsumer)stream -> {
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "git4idea/history/GitLogUtil", "lambda$sendHashesToStdin$8"));
            }
            if (hashes2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "git4idea/history/GitLogUtil", "lambda$sendHashesToStdin$8"));
            }
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, handler.getCharset());){
                for (String hash : hashes2) {
                    writer.write(hash);
                    writer.write(separator);
                }
                writer.write(separator);
                writer.flush();
            }
        }));
    }

    @NotNull
    private static String getSeparator(@NotNull GitVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "git4idea/history/GitLogUtil", "getSeparator"));
        }
        if (GitVersionSpecialty.LF_SEPARATORS_IN_STDIN.existsIn(vcs.getVersion())) {
            if ("\n" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogUtil", "getSeparator"));
            }
            return "\n";
        }
        String string = System.lineSeparator();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogUtil", "getSeparator"));
        }
        return string;
    }

    @NotNull
    public static String getNoWalkParameter(@NotNull GitVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "git4idea/history/GitLogUtil", "getNoWalkParameter"));
        }
        String string = GitVersionSpecialty.NO_WALK_UNSORTED.existsIn(vcs.getVersion()) ? "--no-walk=unsorted" : "--no-walk";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogUtil", "getNoWalkParameter"));
        }
        return string;
    }

    @NotNull
    private static List<String> createConfigParameters(boolean withChanges, boolean fast) {
        if (!withChanges) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogUtil", "createConfigParameters"));
            }
            return list;
        }
        List<String> list = fast ? GitLogUtil.renameLimit(Registry.intValue((String)"git.diff.renameLimit")) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogUtil", "createConfigParameters"));
        }
        return list;
    }

    @NotNull
    private static List<String> renameLimit(int limit) {
        List<String> list = Collections.singletonList("diff.renameLimit=" + limit);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogUtil", "renameLimit"));
        }
        return list;
    }

    private static /* synthetic */ VcsCommitMetadata lambda$collectMetadata$4(@NotNull Project project, @NotNull VirtualFile root, VcsLogObjectsFactory factory, Set refs, GitLogRecord record) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitLogUtil", "lambda$collectMetadata$4"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitLogUtil", "lambda$collectMetadata$4"));
        }
        GitCommit commit = GitLogUtil.createCommit(project, root, Collections.singletonList(record), factory);
        Collection<VcsRef> refsInRecord = GitLogUtil.parseRefs(record.getRefs(), commit.getId(), factory, root);
        for (VcsRef ref : refsInRecord) {
            if (refs.add(ref)) continue;
            VcsRef otherRef = (VcsRef)ContainerUtil.find((Iterable)refs, r -> GitLogProvider.DONT_CONSIDER_SHA.equals(r, (Object)ref));
            LOG.error("Adding duplicate element " + ref + " to the set containing " + otherRef);
        }
        return commit;
    }
}

