/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogStandardColors;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.impl.SimpleRefGroup;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import com.intellij.vcs.log.impl.VcsLogUtil;
import git4idea.GitRemoteBranch;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRefManager
implements VcsLogRefManager {
    public static final VcsRefType HEAD = new SimpleRefType(true, VcsLogStandardColors.Refs.TIP, "HEAD");
    public static final VcsRefType LOCAL_BRANCH = new SimpleRefType(true, VcsLogStandardColors.Refs.BRANCH, "LOCAL_BRANCH");
    public static final VcsRefType REMOTE_BRANCH = new SimpleRefType(true, VcsLogStandardColors.Refs.BRANCH_REF, "REMOTE_BRANCH");
    public static final VcsRefType TAG = new SimpleRefType(false, VcsLogStandardColors.Refs.TAG, "TAG");
    public static final VcsRefType OTHER = new SimpleRefType(false, VcsLogStandardColors.Refs.TAG, "OTHER");
    private static final List<VcsRefType> REF_TYPE_INDEX = Arrays.asList(HEAD, LOCAL_BRANCH, REMOTE_BRANCH, TAG, OTHER);
    public static final String MASTER = "master";
    public static final String ORIGIN_MASTER = "origin/master";
    private static final Logger LOG = Logger.getInstance(GitRefManager.class);
    private static final String REMOTE_TABLE_SEPARATOR = " & ";
    private static final String SEPARATOR = "/";
    @NotNull
    private final RepositoryManager<GitRepository> myRepositoryManager;
    @NotNull
    private final Comparator<VcsRef> myLabelsComparator;
    @NotNull
    private final Comparator<VcsRef> myBranchLayoutComparator;

    public GitRefManager(@NotNull RepositoryManager<GitRepository> repositoryManager) {
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "git4idea/log/GitRefManager", "<init>"));
        }
        this.myRepositoryManager = repositoryManager;
        this.myBranchLayoutComparator = new GitBranchLayoutComparator(repositoryManager);
        this.myLabelsComparator = new GitLabelComparator(repositoryManager);
    }

    @NotNull
    public Comparator<VcsRef> getLabelsOrderComparator() {
        Comparator<VcsRef> comparator = this.myLabelsComparator;
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getLabelsOrderComparator"));
        }
        return comparator;
    }

    @NotNull
    public Comparator<VcsRef> getBranchLayoutComparator() {
        Comparator<VcsRef> comparator = this.myBranchLayoutComparator;
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getBranchLayoutComparator"));
        }
        return comparator;
    }

    @NotNull
    public List<RefGroup> groupForBranchFilter(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "git4idea/log/GitRefManager", "groupForBranchFilter"));
        }
        ArrayList simpleGroups = ContainerUtil.newArrayList();
        ArrayList localBranches = ContainerUtil.newArrayList();
        ArrayList trackedBranches = ContainerUtil.newArrayList();
        MultiMap remoteRefGroups = MultiMap.create();
        MultiMap<VirtualFile, VcsRef> refsByRoot = GitRefManager.groupRefsByRoot(refs);
        for (Map.Entry entry : refsByRoot.entrySet()) {
            VirtualFile root = (VirtualFile)entry.getKey();
            List refsInRoot = ContainerUtil.sorted((Collection)((Collection)entry.getValue()), this.myLabelsComparator);
            GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
            if (repository == null) {
                LOG.warn("No repository for root: " + root);
                continue;
            }
            Set<String> locals = GitRefManager.getLocalBranches(repository);
            Set<String> tracked = GitRefManager.getTrackedRemoteBranches(repository);
            Map<String, GitRemote> allRemote = GitRefManager.getAllRemoteBranches(repository);
            for (VcsRef ref : refsInRoot) {
                if (ref.getType() == HEAD) {
                    simpleGroups.add(new SingletonRefGroup(ref));
                    continue;
                }
                String refName = ref.getName();
                if (locals.contains(refName)) {
                    localBranches.add(ref);
                    continue;
                }
                if (allRemote.containsKey(refName)) {
                    remoteRefGroups.putValue((Object)allRemote.get(refName), (Object)ref);
                    if (!tracked.contains(refName)) continue;
                    trackedBranches.add(ref);
                    continue;
                }
                LOG.debug("Didn't find ref neither in local nor in remote branches: " + ref);
            }
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        result2.addAll(simpleGroups);
        if (!localBranches.isEmpty()) {
            result2.add(new LogicalRefGroup("Local", localBranches));
        }
        if (!trackedBranches.isEmpty()) {
            result2.add(new LogicalRefGroup("Tracked", trackedBranches));
        }
        for (Map.Entry entry : remoteRefGroups.entrySet()) {
            GitRemote remote = (GitRemote)entry.getKey();
            Collection branches = (Collection)entry.getValue();
            result2.add(new RemoteRefGroup(remote, branches));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "groupForBranchFilter"));
        }
        return arrayList;
    }

    @NotNull
    public List<RefGroup> groupForTable(@NotNull Collection<VcsRef> references, boolean compact, boolean showTagNames) {
        GitRepository repository;
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "git4idea/log/GitRefManager", "groupForTable"));
        }
        List sortedReferences = ContainerUtil.sorted(references, this.myLabelsComparator);
        MultiMap groupedRefs = ContainerUtil.groupBy((Iterable)sortedReferences, VcsRef::getType);
        ArrayList result2 = ContainerUtil.newArrayList();
        if (groupedRefs.isEmpty()) {
            ArrayList arrayList = result2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "groupForTable"));
            }
            return arrayList;
        }
        VcsRef head = null;
        Map.Entry firstGroup = (Map.Entry)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((Collection)groupedRefs.entrySet()));
        if (((VcsRefType)firstGroup.getKey()).equals(HEAD)) {
            head = (VcsRef)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)((Collection)firstGroup.getValue())));
            groupedRefs.remove((Object)HEAD, (Object)head);
        }
        if ((repository = this.getRepository(references)) != null) {
            result2.addAll(GitRefManager.getTrackedRefs((MultiMap<VcsRefType, VcsRef>)groupedRefs, repository));
        }
        result2.forEach(refGroup -> {
            groupedRefs.remove((Object)LOCAL_BRANCH, refGroup.getRefs().get(0));
            groupedRefs.remove((Object)REMOTE_BRANCH, refGroup.getRefs().get(1));
        });
        SimpleRefGroup.buildGroups((MultiMap)groupedRefs, (boolean)compact, (boolean)showTagNames, (List)result2);
        if (head != null) {
            if (repository != null && !repository.isOnBranch()) {
                result2.add(0, new SimpleRefGroup("!", Collections.singletonList(head)));
            } else if (!result2.isEmpty()) {
                RefGroup first = (RefGroup)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((List)result2));
                first.getRefs().add(0, head);
            } else {
                result2.add(0, new SimpleRefGroup("", Collections.singletonList(head)));
            }
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "groupForTable"));
        }
        return arrayList;
    }

    @NotNull
    private static List<RefGroup> getTrackedRefs(@NotNull MultiMap<VcsRefType, VcsRef> groupedRefs, @NotNull GitRepository repository) {
        if (groupedRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupedRefs", "git4idea/log/GitRefManager", "getTrackedRefs"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/log/GitRefManager", "getTrackedRefs"));
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        Collection locals = groupedRefs.get((Object)LOCAL_BRANCH);
        Collection remotes = groupedRefs.get((Object)REMOTE_BRANCH);
        for (VcsRef localRef : locals) {
            SimpleRefGroup group = GitRefManager.createTrackedGroup(repository, remotes, localRef);
            if (group == null) continue;
            result2.add(group);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getTrackedRefs"));
        }
        return arrayList;
    }

    @Nullable
    private static SimpleRefGroup createTrackedGroup(@NotNull GitRepository repository, @NotNull Collection<VcsRef> references, @NotNull VcsRef localRef) {
        VcsRef trackedRef;
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/log/GitRefManager", "createTrackedGroup"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "git4idea/log/GitRefManager", "createTrackedGroup"));
        }
        if (localRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localRef", "git4idea/log/GitRefManager", "createTrackedGroup"));
        }
        List remoteBranches = ContainerUtil.filter(references, ref -> ref.getType().equals(REMOTE_BRANCH));
        GitBranchTrackInfo trackInfo = (GitBranchTrackInfo)ContainerUtil.find(repository.getBranchTrackInfos(), info -> {
            if (localRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localRef", "git4idea/log/GitRefManager", "lambda$createTrackedGroup$2"));
            }
            return info.getLocalBranch().getName().equals(localRef.getName());
        });
        if (trackInfo != null && (trackedRef = (VcsRef)ContainerUtil.find((Iterable)remoteBranches, ref -> ref.getName().equals(trackInfo.getRemoteBranch().getName()))) != null) {
            return new SimpleRefGroup(trackInfo.getRemote().getName() + REMOTE_TABLE_SEPARATOR + localRef.getName(), (List)ContainerUtil.newArrayList((Object[])new VcsRef[]{localRef, trackedRef}));
        }
        List trackingCandidates = ContainerUtil.filter((Collection)remoteBranches, ref -> {
            if (localRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localRef", "git4idea/log/GitRefManager", "lambda$createTrackedGroup$4"));
            }
            return ref.getName().endsWith(SEPARATOR + localRef.getName());
        });
        for (GitRemote remote : repository.getRemotes()) {
            for (VcsRef candidate : trackingCandidates) {
                if (!candidate.getName().equals(remote.getName() + SEPARATOR + localRef.getName())) continue;
                return new SimpleRefGroup(remote.getName() + REMOTE_TABLE_SEPARATOR + localRef.getName(), (List)ContainerUtil.newArrayList((Object[])new VcsRef[]{localRef, candidate}));
            }
        }
        return null;
    }

    @Nullable
    private GitRepository getRepository(@NotNull Collection<VcsRef> references) {
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "git4idea/log/GitRefManager", "getRepository"));
        }
        if (references.isEmpty()) {
            return null;
        }
        VcsRef ref = (VcsRef)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(references));
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(ref.getRoot());
        if (repository == null) {
            LOG.warn("No repository for root: " + ref.getRoot());
        }
        return repository;
    }

    public void serialize(@NotNull DataOutput out, @NotNull VcsRefType type) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "git4idea/log/GitRefManager", "serialize"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "git4idea/log/GitRefManager", "serialize"));
        }
        out.writeInt(REF_TYPE_INDEX.indexOf(type));
    }

    @NotNull
    public VcsRefType deserialize(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "git4idea/log/GitRefManager", "deserialize"));
        }
        int id = in.readInt();
        if (id < 0 || id > REF_TYPE_INDEX.size() - 1) {
            throw new IOException("Reference type by id " + id + " does not exist");
        }
        VcsRefType vcsRefType = REF_TYPE_INDEX.get(id);
        if (vcsRefType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "deserialize"));
        }
        return vcsRefType;
    }

    private static Set<String> getLocalBranches(GitRepository repository) {
        return ContainerUtil.map2Set(repository.getBranches().getLocalBranches(), branch -> branch.getName());
    }

    @NotNull
    private static Set<String> getTrackedRemoteBranches(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/log/GitRefManager", "getTrackedRemoteBranches"));
        }
        HashSet<GitRemoteBranch> all = new HashSet<GitRemoteBranch>(repository.getBranches().getRemoteBranches());
        HashSet<String> tracked = new HashSet<String>();
        for (GitBranchTrackInfo info : repository.getBranchTrackInfos()) {
            GitRemoteBranch trackedRemoteBranch = info.getRemoteBranch();
            if (!all.contains(trackedRemoteBranch)) continue;
            tracked.add(trackedRemoteBranch.getName());
        }
        HashSet<String> hashSet = tracked;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getTrackedRemoteBranches"));
        }
        return hashSet;
    }

    @NotNull
    private static Map<String, GitRemote> getAllRemoteBranches(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/log/GitRefManager", "getAllRemoteBranches"));
        }
        HashSet<GitRemoteBranch> all = new HashSet<GitRemoteBranch>(repository.getBranches().getRemoteBranches());
        HashMap allRemote = ContainerUtil.newHashMap();
        for (GitRemoteBranch remoteBranch : all) {
            allRemote.put(remoteBranch.getName(), remoteBranch.getRemote());
        }
        HashMap hashMap = allRemote;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getAllRemoteBranches"));
        }
        return hashMap;
    }

    private static Set<String> getTrackedRemoteBranchesFromConfig(GitRepository repository) {
        return ContainerUtil.map2Set(repository.getBranchTrackInfos(), trackInfo -> trackInfo.getRemoteBranch().getName());
    }

    @NotNull
    private static MultiMap<VirtualFile, VcsRef> groupRefsByRoot(@NotNull Iterable<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "git4idea/log/GitRefManager", "groupRefsByRoot"));
        }
        MultiMap grouped = MultiMap.create();
        for (VcsRef ref : refs) {
            grouped.putValue((Object)ref.getRoot(), (Object)ref);
        }
        MultiMap multiMap = grouped;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "groupRefsByRoot"));
        }
        return multiMap;
    }

    @NotNull
    public static VcsRefType getRefType(@NotNull String refName) {
        if (refName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refName", "git4idea/log/GitRefManager", "getRefType"));
        }
        if (refName.startsWith("refs/heads/")) {
            VcsRefType vcsRefType = LOCAL_BRANCH;
            if (vcsRefType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getRefType"));
            }
            return vcsRefType;
        }
        if (refName.startsWith("refs/remotes/")) {
            VcsRefType vcsRefType = REMOTE_BRANCH;
            if (vcsRefType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getRefType"));
            }
            return vcsRefType;
        }
        if (refName.startsWith("refs/tags/")) {
            VcsRefType vcsRefType = TAG;
            if (vcsRefType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getRefType"));
            }
            return vcsRefType;
        }
        if (refName.startsWith("HEAD")) {
            VcsRefType vcsRefType = HEAD;
            if (vcsRefType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getRefType"));
            }
            return vcsRefType;
        }
        VcsRefType vcsRefType = OTHER;
        if (vcsRefType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getRefType"));
        }
        return vcsRefType;
    }

    private static abstract class GitRefComparator
    implements Comparator<VcsRef> {
        @NotNull
        private final RepositoryManager<GitRepository> myRepositoryManager;

        GitRefComparator(@NotNull RepositoryManager<GitRepository> repositoryManager) {
            if (repositoryManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "git4idea/log/GitRefManager$GitRefComparator", "<init>"));
            }
            this.myRepositoryManager = repositoryManager;
        }

        @Override
        public int compare(@NotNull VcsRef ref1, @NotNull VcsRef ref2) {
            int power2;
            if (ref1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref1", "git4idea/log/GitRefManager$GitRefComparator", "compare"));
            }
            if (ref2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref2", "git4idea/log/GitRefManager$GitRefComparator", "compare"));
            }
            int power1 = ArrayUtil.find((Object[])this.getOrderedTypes(), (Object)((Object)this.getType(ref1)));
            if (power1 != (power2 = ArrayUtil.find((Object[])this.getOrderedTypes(), (Object)((Object)this.getType(ref2))))) {
                return power1 - power2;
            }
            int namesComparison = ref1.getName().compareTo(ref2.getName());
            if (namesComparison != 0) {
                return namesComparison;
            }
            return VcsLogUtil.compareRoots((VirtualFile)ref1.getRoot(), (VirtualFile)ref2.getRoot());
        }

        protected abstract RefType[] getOrderedTypes();

        @NotNull
        private RefType getType(@NotNull VcsRef ref) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "git4idea/log/GitRefManager$GitRefComparator", "getType"));
            }
            VcsRefType type = ref.getType();
            if (type == HEAD) {
                RefType refType = RefType.HEAD;
                if (refType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$GitRefComparator", "getType"));
                }
                return refType;
            }
            if (type == TAG) {
                RefType refType = RefType.TAG;
                if (refType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$GitRefComparator", "getType"));
                }
                return refType;
            }
            if (type == LOCAL_BRANCH) {
                if (ref.getName().equals(GitRefManager.MASTER)) {
                    RefType refType = RefType.MASTER;
                    if (refType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$GitRefComparator", "getType"));
                    }
                    return refType;
                }
                RefType refType = this.isTracked(ref, false) ? RefType.TRACKING_LOCAL_BRANCH : RefType.NON_TRACKING_LOCAL_BRANCH;
                if (refType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$GitRefComparator", "getType"));
                }
                return refType;
            }
            if (type == REMOTE_BRANCH) {
                if (ref.getName().equals(GitRefManager.ORIGIN_MASTER)) {
                    RefType refType = RefType.ORIGIN_MASTER;
                    if (refType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$GitRefComparator", "getType"));
                    }
                    return refType;
                }
                RefType refType = this.isTracked(ref, true) ? RefType.TRACKED_REMOTE_BRANCH : RefType.NON_TRACKED_REMOTE_BRANCH;
                if (refType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$GitRefComparator", "getType"));
                }
                return refType;
            }
            RefType refType = RefType.OTHER;
            if (refType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$GitRefComparator", "getType"));
            }
            return refType;
        }

        private boolean isTracked(@NotNull VcsRef ref, boolean remoteBranch) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "git4idea/log/GitRefManager$GitRefComparator", "isTracked"));
            }
            GitRepository repo = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(ref.getRoot());
            if (repo == null) {
                LOG.error("Undefined root " + ref.getRoot());
                return false;
            }
            return ContainerUtil.exists(repo.getBranchTrackInfos(), info -> {
                if (ref == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "git4idea/log/GitRefManager$GitRefComparator", "lambda$isTracked$0"));
                }
                return remoteBranch ? info.getRemoteBranch().getNameForLocalOperations().equals(ref.getName()) : info.getLocalBranch().getName().equals(ref.getName());
            });
        }
    }

    private static class GitBranchLayoutComparator
    extends GitRefComparator {
        private static final RefType[] ORDERED_TYPES = new RefType[]{RefType.ORIGIN_MASTER, RefType.TRACKED_REMOTE_BRANCH, RefType.MASTER, RefType.TRACKING_LOCAL_BRANCH, RefType.NON_TRACKING_LOCAL_BRANCH, RefType.NON_TRACKED_REMOTE_BRANCH, RefType.TAG, RefType.HEAD, RefType.OTHER};

        GitBranchLayoutComparator(@NotNull RepositoryManager<GitRepository> repositoryManager) {
            if (repositoryManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "git4idea/log/GitRefManager$GitBranchLayoutComparator", "<init>"));
            }
            super(repositoryManager);
        }

        @Override
        protected RefType[] getOrderedTypes() {
            return ORDERED_TYPES;
        }
    }

    private static class GitLabelComparator
    extends GitRefComparator {
        private static final RefType[] ORDERED_TYPES = new RefType[]{RefType.HEAD, RefType.MASTER, RefType.TRACKING_LOCAL_BRANCH, RefType.NON_TRACKING_LOCAL_BRANCH, RefType.ORIGIN_MASTER, RefType.TRACKED_REMOTE_BRANCH, RefType.NON_TRACKED_REMOTE_BRANCH, RefType.TAG, RefType.OTHER};

        GitLabelComparator(@NotNull RepositoryManager<GitRepository> repositoryManager) {
            if (repositoryManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "git4idea/log/GitRefManager$GitLabelComparator", "<init>"));
            }
            super(repositoryManager);
        }

        @Override
        protected RefType[] getOrderedTypes() {
            return ORDERED_TYPES;
        }
    }

    private class RemoteRefGroup
    implements RefGroup {
        private final GitRemote myRemote;
        private final Collection<VcsRef> myBranches;

        public RemoteRefGroup(GitRemote remote, Collection<VcsRef> branches) {
            this.myRemote = remote;
            this.myBranches = branches;
        }

        public boolean isExpanded() {
            return false;
        }

        @NotNull
        public String getName() {
            String string = this.myRemote.getName() + "/...";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$RemoteRefGroup", "getName"));
            }
            return string;
        }

        @NotNull
        public List<VcsRef> getRefs() {
            List list = ContainerUtil.sorted(this.myBranches, GitRefManager.this.getLabelsOrderComparator());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$RemoteRefGroup", "getRefs"));
            }
            return list;
        }

        @NotNull
        public List<Color> getColors() {
            List<Color> list = Collections.singletonList(VcsLogStandardColors.Refs.BRANCH_REF);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$RemoteRefGroup", "getColors"));
            }
            return list;
        }
    }

    private static class LogicalRefGroup
    implements RefGroup {
        private final String myGroupName;
        private final List<VcsRef> myRefs;

        private LogicalRefGroup(String groupName, List<VcsRef> refs) {
            this.myGroupName = groupName;
            this.myRefs = refs;
        }

        public boolean isExpanded() {
            return true;
        }

        @NotNull
        public String getName() {
            String string = this.myGroupName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$LogicalRefGroup", "getName"));
            }
            return string;
        }

        @NotNull
        public List<VcsRef> getRefs() {
            List<VcsRef> list = this.myRefs;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$LogicalRefGroup", "getRefs"));
            }
            return list;
        }

        @NotNull
        public List<Color> getColors() {
            List<Color> list = Collections.singletonList(VcsLogStandardColors.Refs.TIP);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$LogicalRefGroup", "getColors"));
            }
            return list;
        }
    }

    private static class SimpleRefType
    implements VcsRefType {
        private final boolean myIsBranch;
        @NotNull
        private final Color myColor;
        @NotNull
        private final String myName;

        public SimpleRefType(boolean isBranch, @NotNull Color color, @NotNull String typeName) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "git4idea/log/GitRefManager$SimpleRefType", "<init>"));
            }
            if (typeName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "git4idea/log/GitRefManager$SimpleRefType", "<init>"));
            }
            this.myIsBranch = isBranch;
            this.myColor = color;
            this.myName = typeName;
        }

        public boolean isBranch() {
            return this.myIsBranch;
        }

        @NotNull
        public Color getBackgroundColor() {
            Color color = this.myColor;
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$SimpleRefType", "getBackgroundColor"));
            }
            return color;
        }

        public String toString() {
            return this.myName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleRefType type = (SimpleRefType)o;
            return this.myIsBranch == type.myIsBranch && Objects.equals(this.myName, type.myName);
        }

        public int hashCode() {
            return Objects.hash(this.myIsBranch, this.myName);
        }
    }

    protected static enum RefType {
        OTHER,
        HEAD,
        TAG,
        NON_TRACKING_LOCAL_BRANCH,
        NON_TRACKED_REMOTE_BRANCH,
        TRACKING_LOCAL_BRANCH,
        MASTER,
        TRACKED_REMOTE_BRANCH,
        ORIGIN_MASTER;

    }
}

