/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class GitRebaseEntry {
    private static final Logger log = Logger.getInstance((String)GitRebaseEntry.class.getName());
    private final String myCommit;
    private final String mySubject;
    private Action myAction;

    public GitRebaseEntry(String action, String commit, String subject) {
        this(Action.fromString(action), commit, subject);
    }

    public GitRebaseEntry(Action action, String commit, String subject) {
        this.myCommit = commit;
        this.mySubject = subject;
        this.myAction = action;
    }

    public String getCommit() {
        return this.myCommit;
    }

    public String getSubject() {
        return this.mySubject;
    }

    public Action getAction() {
        return this.myAction;
    }

    public void setAction(Action action) {
        if (action == null) {
            log.error("The action must not be null");
        } else {
            this.myAction = action;
        }
    }

    public static enum Action {
        pick,
        edit,
        skip,
        squash,
        reword,
        fixup;


        @NotNull
        static Action fromString(@NonNls @NotNull String actionName) {
            Action action;
            if (actionName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionName", "git4idea/rebase/GitRebaseEntry$Action", "fromString"));
            }
            try {
                action = Action.valueOf(actionName.toLowerCase());
            }
            catch (IllegalArgumentException e) {
                log.error((Throwable)e);
                Action action2 = pick;
                if (action2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseEntry$Action", "fromString"));
                }
                return action2;
            }
            if (action == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseEntry$Action", "fromString"));
            }
            return action;
        }
    }
}

