/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.rebase.GitAbortRebaseProcess;
import git4idea.rebase.GitRebaseProcess;
import git4idea.rebase.GitRebaseResumeMode;
import git4idea.rebase.GitRebaseSpec;
import git4idea.repo.GitRepository;
import git4idea.stash.GitChangesSaver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseUtils {
    public static final String CONTINUE_PROGRESS_TITLE = "Continue Rebase Process...";
    private static final Logger LOG = Logger.getInstance((String)GitRebaseUtils.class.getName());

    private GitRebaseUtils() {
    }

    public static void rebase(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull GitRebaseParams params, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseUtils", "rebase"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseUtils", "rebase"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "git4idea/rebase/GitRebaseUtils", "rebase"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseUtils", "rebase"));
        }
        if (!GitRebaseUtils.isRebaseAllowed(project, repositories)) {
            return;
        }
        new GitRebaseProcess(project, GitRebaseSpec.forNewRebase(project, params, repositories, indicator), null).rebase();
    }

    public static void continueRebase(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseUtils", "continueRebase"));
        }
        GitRebaseSpec spec = GitUtil.getRepositoryManager(project).getOngoingRebaseSpec();
        if (spec != null) {
            new GitRebaseProcess(project, spec, GitRebaseResumeMode.CONTINUE).rebase();
        } else {
            LOG.warn("Refusing to continue: no rebase spec");
            VcsNotifier.getInstance((Project)project).notifyError("Can't Continue Rebase", "No rebase in progress");
        }
    }

    public static void continueRebase(@NotNull Project project, @NotNull GitRepository repository, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseUtils", "continueRebase"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/rebase/GitRebaseUtils", "continueRebase"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseUtils", "continueRebase"));
        }
        GitRebaseSpec spec = GitRebaseSpec.forResumeInSingleRepository(project, repository, indicator);
        if (spec != null) {
            new GitRebaseProcess(project, spec, GitRebaseResumeMode.CONTINUE).rebase();
        } else {
            LOG.warn("Refusing to continue: no rebase spec");
            VcsNotifier.getInstance((Project)project).notifyError("Can't Continue Rebase", "No rebase in progress");
        }
    }

    public static void skipRebase(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseUtils", "skipRebase"));
        }
        GitRebaseSpec spec = GitUtil.getRepositoryManager(project).getOngoingRebaseSpec();
        if (spec != null) {
            new GitRebaseProcess(project, spec, GitRebaseResumeMode.SKIP).rebase();
        } else {
            LOG.warn("Refusing to skip: no rebase spec");
            VcsNotifier.getInstance((Project)project).notifyError("Can't Continue Rebase", "No rebase in progress");
        }
    }

    public static void skipRebase(@NotNull Project project, @NotNull GitRepository repository, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseUtils", "skipRebase"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/rebase/GitRebaseUtils", "skipRebase"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseUtils", "skipRebase"));
        }
        GitRebaseSpec spec = GitRebaseSpec.forResumeInSingleRepository(project, repository, indicator);
        if (spec != null) {
            new GitRebaseProcess(project, spec, GitRebaseResumeMode.SKIP).rebase();
        } else {
            LOG.warn("Refusing to skip: no rebase spec");
            VcsNotifier.getInstance((Project)project).notifyError("Can't Continue Rebase", "No rebase in progress");
        }
    }

    public static void abort(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseUtils", "abort"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseUtils", "abort"));
        }
        GitRebaseSpec spec = GitUtil.getRepositoryManager(project).getOngoingRebaseSpec();
        if (spec != null) {
            new GitAbortRebaseProcess(project, spec.getOngoingRebase(), spec.getHeadPositionsToRollback(), spec.getInitialBranchNames(), indicator, spec.getSaver(), true).abortWithConfirmation();
        } else {
            LOG.warn("Refusing to abort: no rebase spec");
            VcsNotifier.getInstance((Project)project).notifyError("Can't Abort Rebase", "No rebase in progress");
        }
    }

    public static void abort(@NotNull Project project, @Nullable GitRepository repository, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseUtils", "abort"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseUtils", "abort"));
        }
        new GitAbortRebaseProcess(project, repository, Collections.emptyMap(), Collections.emptyMap(), indicator, null, true).abortWithConfirmation();
    }

    private static boolean isRebaseAllowed(@NotNull Project project, @NotNull Collection<GitRepository> repositories) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseUtils", "isRebaseAllowed"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseUtils", "isRebaseAllowed"));
        }
        for (GitRepository repository : repositories) {
            Repository.State state = repository.getState();
            String in = GitUtil.mention(repository);
            String message = null;
            switch (state) {
                case NORMAL: {
                    if (!repository.isFresh()) break;
                    message = "Repository" + in + " is empty.";
                    break;
                }
                case MERGING: {
                    message = "There is an unfinished merge process" + in + ".<br/>You should complete the merge before starting a rebase";
                    break;
                }
                case REBASING: {
                    message = "There is an unfinished rebase process" + in + ".<br/>You should complete it before starting another rebase";
                    break;
                }
                case GRAFTING: {
                    message = "There is an unfinished cherry-pick process" + in + ".<br/>You should finish it before starting a rebase.";
                    break;
                }
                case DETACHED: {
                    message = "You are in the detached HEAD state" + in + ".<br/>Rebase is not possible.";
                    break;
                }
                default: {
                    LOG.error("Unknown state [" + state.name() + "]");
                    message = "Rebase is not possible" + in;
                }
            }
            if (message == null) continue;
            VcsNotifier.getInstance((Project)project).notifyError("Rebase not Allowed", message);
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean isRebaseInTheProgress(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseUtils", "isRebaseInTheProgress"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/rebase/GitRebaseUtils", "isRebaseInTheProgress"));
        }
        return GitRebaseUtils.getRebaseDir(project, root) != null;
    }

    @Nullable
    private static File getRebaseDir(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseUtils", "getRebaseDir"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/rebase/GitRebaseUtils", "getRebaseDir"));
        }
        GitRepository repository = (GitRepository)ObjectUtils.assertNotNull((Object)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root));
        File f = repository.getRepositoryFiles().getRebaseApplyDir();
        if (f.exists()) {
            return f;
        }
        f = repository.getRepositoryFiles().getRebaseMergeDir();
        if (f.exists()) {
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CommitInfo getCurrentRebaseCommit(@NotNull Project project, @NotNull VirtualFile root) {
        int next;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseUtils", "getCurrentRebaseCommit"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/rebase/GitRebaseUtils", "getCurrentRebaseCommit"));
        }
        File rebaseDir = GitRebaseUtils.getRebaseDir(project, root);
        if (rebaseDir == null) {
            LOG.warn("No rebase dir found for " + root.getPath());
            return null;
        }
        File nextFile = new File(rebaseDir, "next");
        try {
            next = Integer.parseInt(FileUtil.loadFile((File)nextFile, (Charset)CharsetToolkit.UTF8_CHARSET).trim());
        }
        catch (Exception e) {
            LOG.warn("Failed to load next commit number from file " + nextFile.getPath(), (Throwable)e);
            return null;
        }
        File commitFile = new File(rebaseDir, String.format("%04d", next));
        String hash = null;
        String subject = null;
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(commitFile), CharsetToolkit.UTF8_CHARSET));){
            String line;
            while ((line = in.readLine()) != null) {
                if (line.startsWith("From ")) {
                    hash = line.substring(5, 45);
                }
                if (line.startsWith("Subject: ")) {
                    subject = line.substring("Subject: ".length());
                }
                if (hash == null || subject == null) continue;
                break;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to load next commit number from file " + commitFile, (Throwable)e);
            return null;
        }
        if (subject == null || hash == null) {
            LOG.info("Unable to extract information from " + commitFile + " " + hash + ": " + subject);
            return null;
        }
        return new CommitInfo(new GitRevisionNumber(hash), subject);
    }

    @NotNull
    static String mentionLocalChangesRemainingInStash(@Nullable GitChangesSaver saver) {
        String string = saver != null && saver.wereChangesSaved() ? "<br/>Note that some local changes were <a href='stash'>" + GitRebaseUtils.toPast(saver.getOperationName()) + "</a> before rebase." : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseUtils", "mentionLocalChangesRemainingInStash"));
        }
        return string;
    }

    @NotNull
    private static String toPast(@NotNull String word) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "git4idea/rebase/GitRebaseUtils", "toPast"));
        }
        String string = word.endsWith("e") ? word + "d" : word + "ed";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseUtils", "toPast"));
        }
        return string;
    }

    @NotNull
    public static Collection<GitRepository> getRebasingRepositories(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseUtils", "getRebasingRepositories"));
        }
        List list = ContainerUtil.filter(GitUtil.getRepositories(project), repository -> repository.getState() == Repository.State.REBASING);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseUtils", "getRebasingRepositories"));
        }
        return list;
    }

    public static class CommitInfo {
        public final GitRevisionNumber revision;
        public final String subject;

        public CommitInfo(GitRevisionNumber revision, String subject) {
            this.revision = revision;
            this.subject = subject;
        }

        public String toString() {
            return this.revision.toString();
        }
    }
}

