/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.Hash;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import git4idea.util.GitPreservingProcess;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitResetOperation {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<GitRepository, Hash> myCommits;
    @NotNull
    private final GitResetMode myMode;
    @NotNull
    private final ProgressIndicator myIndicator;
    @NotNull
    private final Git myGit;
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final GitBranchUiHandlerImpl myUiHandler;

    public GitResetOperation(@NotNull Project project, @NotNull Map<GitRepository, Hash> targetCommits, @NotNull GitResetMode mode, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/reset/GitResetOperation", "<init>"));
        }
        if (targetCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetCommits", "git4idea/reset/GitResetOperation", "<init>"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "git4idea/reset/GitResetOperation", "<init>"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/reset/GitResetOperation", "<init>"));
        }
        this.myProject = project;
        this.myCommits = targetCommits;
        this.myMode = mode;
        this.myIndicator = indicator;
        this.myGit = Git.getInstance();
        this.myNotifier = VcsNotifier.getInstance((Project)project);
        this.myUiHandler = new GitBranchUiHandlerImpl(this.myProject, this.myGit, indicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        GitResetOperation.saveAllDocuments();
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        HashMap results = ContainerUtil.newHashMap();
        try {
            for (Map.Entry<GitRepository, Hash> entry : this.myCommits.entrySet()) {
                GitCommandResult smartResult;
                GitLocalChangesWouldBeOverwrittenDetector detector;
                GitRepository repository = entry.getKey();
                VirtualFile root = repository.getRoot();
                String target = entry.getValue().asString();
                GitCommandResult result2 = this.myGit.reset(repository, this.myMode, target, detector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.RESET));
                if (!result2.success() && detector.wasMessageDetected() && (smartResult = this.proposeSmartReset(detector, repository, target)) != null) {
                    result2 = smartResult;
                }
                results.put(repository, result2);
                repository.update();
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{root});
                VcsDirtyScopeManager.getInstance((Project)this.myProject).dirDirtyRecursively(root);
            }
        }
        finally {
            token.finish();
        }
        this.notifyResult(results);
    }

    private GitCommandResult proposeSmartReset(@NotNull GitLocalChangesWouldBeOverwrittenDetector detector, @NotNull GitRepository repository, @NotNull String target) {
        if (detector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detector", "git4idea/reset/GitResetOperation", "proposeSmartReset"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/reset/GitResetOperation", "proposeSmartReset"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "git4idea/reset/GitResetOperation", "proposeSmartReset"));
        }
        Collection<String> absolutePaths = GitUtil.toAbsolute(repository.getRoot(), detector.getRelativeFilePaths());
        List<Change> affectedChanges = GitUtil.findLocalChangesForPaths(this.myProject, repository.getRoot(), absolutePaths, false);
        int choice = this.myUiHandler.showSmartOperationDialog(this.myProject, affectedChanges, absolutePaths, "reset", "&Hard Reset");
        if (choice == 0) {
            Ref result2 = Ref.create();
            new GitPreservingProcess(this.myProject, this.myGit, Collections.singleton(repository.getRoot()), "reset", target, GitVcsSettings.UpdateChangesPolicy.STASH, this.myIndicator, () -> {
                if (repository == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/reset/GitResetOperation", "lambda$proposeSmartReset$0"));
                }
                if (target == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "git4idea/reset/GitResetOperation", "lambda$proposeSmartReset$0"));
                }
                result2.set((Object)this.myGit.reset(repository, this.myMode, target, new GitLineHandlerListener[0]));
            }).execute();
            return (GitCommandResult)result2.get();
        }
        if (choice == 2) {
            return this.myGit.reset(repository, GitResetMode.HARD, target, new GitLineHandlerListener[0]);
        }
        return null;
    }

    private void notifyResult(@NotNull Map<GitRepository, GitCommandResult> results) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "git4idea/reset/GitResetOperation", "notifyResult"));
        }
        HashMap successes = ContainerUtil.newHashMap();
        HashMap errors = ContainerUtil.newHashMap();
        for (Map.Entry<GitRepository, GitCommandResult> entry : results.entrySet()) {
            GitCommandResult result2 = entry.getValue();
            GitRepository repository = entry.getKey();
            if (result2.success()) {
                successes.put(repository, result2);
                continue;
            }
            errors.put(repository, result2);
        }
        if (errors.isEmpty()) {
            this.myNotifier.notifySuccess("", "Reset successful");
        } else if (!successes.isEmpty()) {
            this.myNotifier.notifyImportantWarning("Reset partially failed", "Reset was successful for " + GitResetOperation.joinRepos(successes.keySet()) + "<br/>but failed for " + GitResetOperation.joinRepos(errors.keySet()) + ": <br/>" + GitResetOperation.formErrorReport(errors));
        } else {
            this.myNotifier.notifyError("Reset Failed", GitResetOperation.formErrorReport(errors));
        }
    }

    @NotNull
    private static String formErrorReport(@NotNull Map<GitRepository, GitCommandResult> errorResults) {
        if (errorResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorResults", "git4idea/reset/GitResetOperation", "formErrorReport"));
        }
        MultiMap<String, GitRepository> grouped = GitResetOperation.groupByResult(errorResults);
        if (grouped.size() == 1) {
            String string = "<code>" + (String)grouped.keySet().iterator().next() + "</code>";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/reset/GitResetOperation", "formErrorReport"));
            }
            return string;
        }
        String string = StringUtil.join((Collection)grouped.entrySet(), entry -> GitResetOperation.joinRepos((Collection)entry.getValue()) + ":<br/><code>" + (String)entry.getKey() + "</code>", (String)"<br/>");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/reset/GitResetOperation", "formErrorReport"));
        }
        return string;
    }

    @NotNull
    private static MultiMap<String, GitRepository> groupByResult(@NotNull Map<GitRepository, GitCommandResult> results) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "git4idea/reset/GitResetOperation", "groupByResult"));
        }
        MultiMap grouped = MultiMap.create();
        for (Map.Entry<GitRepository, GitCommandResult> entry : results.entrySet()) {
            grouped.putValue((Object)entry.getValue().getErrorOutputAsHtmlString(), (Object)entry.getKey());
        }
        MultiMap multiMap = grouped;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/reset/GitResetOperation", "groupByResult"));
        }
        return multiMap;
    }

    @NotNull
    private static String joinRepos(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/reset/GitResetOperation", "joinRepos"));
        }
        String string = StringUtil.join((Iterable)DvcsUtil.sortRepositories(repositories), (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/reset/GitResetOperation", "joinRepos"));
        }
        return string;
    }

    private static void saveAllDocuments() {
        ApplicationManager.getApplication().invokeAndWait(() -> FileDocumentManager.getInstance().saveAllDocuments());
    }
}

