/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import git4idea.config.GitVcsSettings;
import git4idea.util.GitCommitCompareInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

class GitCompareBranchesDiffPanel
extends JPanel {
    private final String myBranchName;
    private final String myCurrentBranchName;
    private final GitCommitCompareInfo myCompareInfo;
    private final GitVcsSettings myVcsSettings;
    private final JBLabel myLabel;
    private final MyChangesBrowser myChangesBrowser;

    public GitCompareBranchesDiffPanel(Project project, String branchName, String currentBranchName, GitCommitCompareInfo compareInfo) {
        this.myCurrentBranchName = currentBranchName;
        this.myCompareInfo = compareInfo;
        this.myBranchName = branchName;
        this.myVcsSettings = GitVcsSettings.getInstance(project);
        this.myLabel = new JBLabel();
        this.myChangesBrowser = new MyChangesBrowser(project, Collections.emptyList());
        HyperlinkLabel swapSidesLabel = new HyperlinkLabel("Swap branches");
        swapSidesLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                boolean swapSides = GitCompareBranchesDiffPanel.this.myVcsSettings.shouldSwapSidesInCompareBranches();
                GitCompareBranchesDiffPanel.this.myVcsSettings.setSwapSidesInCompareBranches(!swapSides);
                GitCompareBranchesDiffPanel.this.refreshView();
            }
        });
        JPanel topPanel = new JPanel((LayoutManager)new HorizontalLayout(JBUI.scale((int)10)));
        topPanel.add((Component)this.myLabel);
        topPanel.add((Component)swapSidesLabel);
        this.setLayout(new BorderLayout(4, 10));
        this.add((Component)topPanel, "North");
        this.add((Component)((Object)this.myChangesBrowser));
        this.refreshView();
    }

    private void refreshView() {
        boolean swapSides = this.myVcsSettings.shouldSwapSidesInCompareBranches();
        String currentBranchText = String.format("current working tree on <b><code>%s</code></b>", this.myCurrentBranchName);
        String otherBranchText = String.format("files in <b><code>%s</code></b>", this.myBranchName);
        this.myLabel.setText(String.format("<html>Difference between %s and %s:</html>", swapSides ? otherBranchText : currentBranchText, swapSides ? currentBranchText : otherBranchText));
        List<Change> diff = this.myCompareInfo.getTotalDiff();
        if (swapSides) {
            diff = GitCompareBranchesDiffPanel.swapRevisions(diff);
        }
        this.myChangesBrowser.setChangesToDisplay(diff);
    }

    @NotNull
    private static List<Change> swapRevisions(@NotNull List<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "git4idea/ui/branch/GitCompareBranchesDiffPanel", "swapRevisions"));
        }
        List list = ContainerUtil.map(changes, change -> new Change(change.getAfterRevision(), change.getBeforeRevision()));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitCompareBranchesDiffPanel", "swapRevisions"));
        }
        return list;
    }

    private static class MyChangesBrowser
    extends ChangesBrowser {
        public MyChangesBrowser(@NotNull Project project, @NotNull List<Change> changes) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitCompareBranchesDiffPanel$MyChangesBrowser", "<init>"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "git4idea/ui/branch/GitCompareBranchesDiffPanel$MyChangesBrowser", "<init>"));
            }
            super(project, null, changes, null, false, true, null, ChangesBrowser.MyUseCase.COMMITTED_CHANGES, null);
        }

        public void setChangesToDisplay(List<Change> changes) {
            List oldSelection = this.myViewer.getSelectedChanges();
            super.setChangesToDisplay(changes);
            this.myViewer.select((Collection)GitCompareBranchesDiffPanel.swapRevisions(oldSelection));
        }
    }
}

