/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListViewerDialog;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchPair;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitSimpleHandler;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitMerger;
import git4idea.repo.GitRepository;
import git4idea.update.GitUpdateResult;
import git4idea.update.GitUpdater;
import git4idea.util.GitUIUtil;
import git4idea.util.GitUntrackedFilesHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitMergeUpdater
extends GitUpdater {
    private static final Logger LOG = Logger.getInstance(GitMergeUpdater.class);
    private final ChangeListManager myChangeListManager;

    public GitMergeUpdater(Project project, @NotNull Git git, VirtualFile root, GitBranchPair branchAndTracked, ProgressIndicator progressIndicator, UpdatedFiles updatedFiles) {
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/update/GitMergeUpdater", "<init>"));
        }
        super(project, git, root, branchAndTracked, progressIndicator, updatedFiles);
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
    }

    @Override
    @NotNull
    protected GitUpdateResult doUpdate() {
        GitUpdateResult gitUpdateResult;
        LOG.info("doUpdate ");
        GitMerger merger = new GitMerger(this.myProject);
        MergeLineListener mergeLineListener = new MergeLineListener();
        GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(this.myRoot);
        String originalText = this.myProgressIndicator.getText();
        this.myProgressIndicator.setText("Merging" + GitUtil.mention(this.myRepository) + "...");
        try {
            GitCommandResult result2 = this.myGit.merge(this.myRepository, ((GitRemoteBranch)ObjectUtils.assertNotNull((Object)this.myBranchPair.getDest())).getName(), Arrays.asList("--no-stat", "-v"), mergeLineListener, untrackedFilesDetector, GitStandardProgressAnalyzer.createListener(this.myProgressIndicator));
            this.myProgressIndicator.setText(originalText);
            gitUpdateResult = result2.success() ? GitUpdateResult.SUCCESS : this.handleMergeFailure(mergeLineListener, untrackedFilesDetector, merger, result2.getErrorOutputAsJoinedString());
        }
        catch (ProcessCanceledException pce) {
            this.cancel();
            GitUpdateResult gitUpdateResult2 = GitUpdateResult.CANCEL;
            if (gitUpdateResult2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitMergeUpdater", "doUpdate"));
            }
            return gitUpdateResult2;
        }
        if (gitUpdateResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitMergeUpdater", "doUpdate"));
        }
        return gitUpdateResult;
    }

    @NotNull
    private GitUpdateResult handleMergeFailure(MergeLineListener mergeLineListener, GitMessageWithFilesDetector untrackedFilesWouldBeOverwrittenByMergeDetector, GitMerger merger, String errorMessage) {
        MergeError error = mergeLineListener.getMergeError();
        LOG.info("merge error: " + (Object)((Object)error));
        if (error == MergeError.CONFLICT) {
            LOG.info("Conflict detected");
            boolean allMerged = new MyConflictResolver(this.myProject, this.myGit, merger, this.myRoot).merge();
            GitUpdateResult gitUpdateResult = allMerged ? GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS : GitUpdateResult.INCOMPLETE;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitMergeUpdater", "handleMergeFailure"));
            }
            return gitUpdateResult;
        }
        if (error == MergeError.LOCAL_CHANGES) {
            LOG.info("Local changes would be overwritten by merge");
            List<FilePath> paths = this.getFilesOverwrittenByMerge(mergeLineListener.getOutput());
            Collection<Change> changes = this.getLocalChangesFilteredByFiles(paths);
            UIUtil.invokeAndWaitIfNeeded(() -> {
                ChangeListViewerDialog dialog = new ChangeListViewerDialog(this.myProject, changes, false){

                    protected String getDescription() {
                        return "Your local changes to the following files would be overwritten by merge.<br/>Please, commit your changes or stash them before you can merge.";
                    }
                };
                dialog.show();
            });
            GitUpdateResult gitUpdateResult = GitUpdateResult.ERROR;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitMergeUpdater", "handleMergeFailure"));
            }
            return gitUpdateResult;
        }
        if (untrackedFilesWouldBeOverwrittenByMergeDetector.wasMessageDetected()) {
            LOG.info("handleMergeFailure: untracked files would be overwritten by merge");
            GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.myProject, this.myRoot, untrackedFilesWouldBeOverwrittenByMergeDetector.getRelativeFilePaths(), "merge", null);
            GitUpdateResult gitUpdateResult = GitUpdateResult.ERROR;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitMergeUpdater", "handleMergeFailure"));
            }
            return gitUpdateResult;
        }
        LOG.info("Unknown error: " + errorMessage);
        GitUIUtil.notifyImportantError(this.myProject, "Error merging", errorMessage);
        GitUpdateResult gitUpdateResult = GitUpdateResult.ERROR;
        if (gitUpdateResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitMergeUpdater", "handleMergeFailure"));
        }
        return gitUpdateResult;
    }

    @Override
    public boolean isSaveNeeded() {
        try {
            if (GitUtil.hasLocalChanges(true, this.myProject, this.myRoot)) {
                return true;
            }
        }
        catch (VcsException e) {
            LOG.info("isSaveNeeded failed to check staging area", (Throwable)e);
            return true;
        }
        String currentBranch = this.myBranchPair.getBranch().getName();
        String remoteBranch = this.myBranchPair.getDest().getName();
        try {
            GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(this.myRoot);
            if (repository == null) {
                LOG.error("Repository is null for root " + this.myRoot);
                return true;
            }
            Collection<String> remotelyChanged = GitUtil.getPathsDiffBetweenRefs(Git.getInstance(), repository, currentBranch, remoteBranch);
            List locallyChanged = this.myChangeListManager.getAffectedPaths();
            for (File localPath : locallyChanged) {
                if (!ContainerUtil.exists(remotelyChanged, remotelyChangedPath -> FileUtil.pathsEqual((String)localPath.getPath(), (String)remotelyChangedPath))) continue;
                return true;
            }
            return false;
        }
        catch (VcsException e) {
            LOG.info("failed to get remotely changed files for " + currentBranch + ".." + remoteBranch, (Throwable)e);
            return true;
        }
    }

    private void cancel() {
        try {
            GitSimpleHandler h = new GitSimpleHandler(this.myProject, this.myRoot, GitCommand.RESET);
            h.addParameters("--merge");
            h.run();
        }
        catch (VcsException e) {
            LOG.info("cancel git reset --merge", (Throwable)e);
            GitUIUtil.notifyImportantError(this.myProject, "Couldn't reset merge", e.getLocalizedMessage());
        }
    }

    private List<FilePath> getFilesOverwrittenByMerge(@NotNull List<String> mergeOutput) {
        if (mergeOutput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeOutput", "git4idea/update/GitMergeUpdater", "getFilesOverwrittenByMerge"));
        }
        ArrayList<FilePath> paths = new ArrayList<FilePath>();
        for (String line : mergeOutput) {
            if (StringUtil.isEmptyOrSpaces((String)line)) continue;
            if (line.contains("Please, commit your changes or stash them before you can merge")) break;
            line = line.trim();
            try {
                String path = this.myRoot.getPath() + "/" + GitUtil.unescapePath(line);
                File file = new File(path);
                if (!file.exists()) continue;
                paths.add(VcsUtil.getFilePath((File)file, (boolean)false));
            }
            catch (VcsException vcsException) {}
        }
        return paths;
    }

    private Collection<Change> getLocalChangesFilteredByFiles(List<FilePath> paths) {
        HashSet<Change> changes = new HashSet<Change>();
        for (LocalChangeList list : this.myChangeListManager.getChangeLists()) {
            for (Change change : list.getChanges()) {
                ContentRevision afterRevision = change.getAfterRevision();
                ContentRevision beforeRevision = change.getBeforeRevision();
                if ((afterRevision == null || !paths.contains(afterRevision.getFile())) && (beforeRevision == null || !paths.contains(beforeRevision.getFile()))) continue;
                changes.add(change);
            }
        }
        return changes;
    }

    public String toString() {
        return "Merge updater";
    }

    private static class MyConflictResolver
    extends GitConflictResolver {
        private final GitMerger myMerger;
        private final VirtualFile myRoot;

        public MyConflictResolver(Project project, @NotNull Git git, GitMerger merger, VirtualFile root) {
            if (git == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/update/GitMergeUpdater$MyConflictResolver", "<init>"));
            }
            super(project, git, Collections.singleton(root), MyConflictResolver.makeParams());
            this.myMerger = merger;
            this.myRoot = root;
        }

        private static GitConflictResolver.Params makeParams() {
            GitConflictResolver.Params params = new GitConflictResolver.Params();
            params.setErrorNotificationTitle("Can't complete update");
            params.setMergeDescription("Merge conflicts detected. Resolve them before continuing update.");
            return params;
        }

        @Override
        protected boolean proceedIfNothingToMerge() throws VcsException {
            this.myMerger.mergeCommit(this.myRoot);
            return true;
        }

        @Override
        protected boolean proceedAfterAllMerged() throws VcsException {
            this.myMerger.mergeCommit(this.myRoot);
            return true;
        }
    }

    private static class MergeLineListener
    extends GitLineHandlerAdapter {
        private MergeError myMergeError;
        private List<String> myOutput = new ArrayList<String>();
        private boolean myLocalChangesError = false;

        private MergeLineListener() {
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            if (this.myLocalChangesError) {
                this.myOutput.add(line);
            } else if (line.contains("Automatic merge failed; fix conflicts and then commit the result")) {
                this.myMergeError = MergeError.CONFLICT;
            } else if (line.contains("Your local changes to the following files would be overwritten by merge")) {
                this.myMergeError = MergeError.LOCAL_CHANGES;
                this.myLocalChangesError = true;
            }
        }

        public MergeError getMergeError() {
            return this.myMergeError;
        }

        public List<String> getOutput() {
            return this.myOutput;
        }
    }

    private static enum MergeError {
        CONFLICT,
        LOCAL_CHANGES,
        OTHER;

    }
}

