/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ee.websocket.highlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ee.websocket.highlighting.WebSocketBaseInspection;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.websocket.jam.WebSocketEndpoint;
import com.intellij.websocket.resources.WebSocketInspectionBundle;
import com.intellij.websocket.utils.WebSocketCommonUtils;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IncorrectOnMessageMethodsInspection
extends WebSocketBaseInspection {
    @Override
    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ee/websocket/highlighting/IncorrectOnMessageMethodsInspection", "checkClass"));
        }
        WebSocketEndpoint endpoint = WebSocketCommonUtils.getWebsocketEndpoint(aClass);
        if (endpoint == null && !InheritanceUtil.isInheritor((PsiClass)aClass, (String)"javax.websocket.Endpoint")) {
            return;
        }
        for (PsiMethod method : aClass.getMethods()) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, Collections.singleton("javax.websocket.OnMessage"));
            if (annotation == null) continue;
            IncorrectOnMessageMethodsInspection.checkParameters(method, holder, endpoint != null ? endpoint.getDecoders() : Collections.emptySet());
            IncorrectOnMessageMethodsInspection.checkReturnType(method, holder, endpoint != null ? endpoint.getEncoders() : Collections.emptySet());
        }
    }

    private static void checkParameters(@NotNull PsiMethod method, ProblemsHolder holder, Set<PsiClass> decoders) {
        PsiIdentifier identifier;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/ee/websocket/highlighting/IncorrectOnMessageMethodsInspection", "checkParameters"));
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length == 0 && (identifier = method.getNameIdentifier()) != null) {
            holder.registerProblem((PsiElement)identifier, WebSocketInspectionBundle.message("IncorrectOnMessageMethodsInspection.incorrect.on.message.no.parameter", new Object[0]), new LocalQuickFix[0]);
        }
        HashSet textMessageParameters = new HashSet();
        HashSet binaryMessageParameters = new HashSet();
        HashSet pongMessageParameters = new HashSet();
        HashSet sessionMessageParameters = new HashSet();
        HashSet unknownTypeParameters = new HashSet();
        for (PsiParameter parameter : parameters) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"javax.websocket.server.PathParam", (boolean)true)) {
                IncorrectOnMessageMethodsInspection.checkPathParamParameter(parameter, holder);
                continue;
            }
            PsiType type = parameter.getType();
            if (WebSocketCommonUtils.isTextMessageParameterType(type, parameter.getProject(), decoders)) {
                textMessageParameters.add(parameter);
                continue;
            }
            if (WebSocketCommonUtils.isBinaryMessageParameterType(type, parameter.getProject(), decoders)) {
                binaryMessageParameters.add(parameter);
                continue;
            }
            if (WebSocketCommonUtils.isPongMessageParameterType(type)) {
                pongMessageParameters.add(parameter);
                continue;
            }
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"javax.websocket.Session")) {
                sessionMessageParameters.add(parameter);
                continue;
            }
            unknownTypeParameters.add(parameter);
        }
        IncorrectOnMessageMethodsInspection.checkMultipleParameters(holder, (Set<PsiParameter>)textMessageParameters, "text");
        IncorrectOnMessageMethodsInspection.checkMultipleParameters(holder, (Set<PsiParameter>)binaryMessageParameters, "binary");
        IncorrectOnMessageMethodsInspection.checkMultipleParameters(holder, (Set<PsiParameter>)pongMessageParameters, "pong");
        IncorrectOnMessageMethodsInspection.checkMultipleParameters(holder, (Set<PsiParameter>)sessionMessageParameters, "Session");
        for (PsiParameter unknownTypeParameter : unknownTypeParameters) {
            PsiTypeElement typeElement = unknownTypeParameter.getTypeElement();
            if (typeElement == null) continue;
            holder.registerProblem((PsiElement)typeElement, WebSocketInspectionBundle.message("IncorrectOnMessageMethodsInspection.incorrect.on.message.parameter.type", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkMultipleParameters(@NotNull ProblemsHolder holder, @NotNull Set<PsiParameter> textMessageParameters, @NotNull String type) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/ee/websocket/highlighting/IncorrectOnMessageMethodsInspection", "checkMultipleParameters"));
        }
        if (textMessageParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textMessageParameters", "com/intellij/ee/websocket/highlighting/IncorrectOnMessageMethodsInspection", "checkMultipleParameters"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/ee/websocket/highlighting/IncorrectOnMessageMethodsInspection", "checkMultipleParameters"));
        }
        if (textMessageParameters.size() > 1) {
            for (PsiParameter parameter : textMessageParameters) {
                PsiTypeElement typeElement = parameter.getTypeElement();
                if (typeElement == null) continue;
                holder.registerProblem((PsiElement)typeElement, WebSocketInspectionBundle.message("IncorrectOnMessageMethodsInspection.incorrect.on.message.multiple.parameter.type", type), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkPathParamParameter(PsiParameter parameter, ProblemsHolder holder) {
        PsiType type = parameter.getType();
        if (type instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)type) != null) {
            return;
        }
        if ("java.lang.String".equals(type.getCanonicalText())) {
            return;
        }
        holder.registerProblem((PsiElement)parameter, WebSocketInspectionBundle.message("IncorrectOnMessageMethodsInspection.incorrect.on.message.path.parameter.type", new Object[0]), new LocalQuickFix[0]);
    }

    private static void checkReturnType(@NotNull PsiMethod method, ProblemsHolder holder, Set<PsiClass> encoders) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/ee/websocket/highlighting/IncorrectOnMessageMethodsInspection", "checkReturnType"));
        }
        PsiType type = method.getReturnType();
        if (type == null) {
            return;
        }
        if (type instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)type) != null) {
            return;
        }
        if ("java.lang.String".equals(type.getCanonicalText())) {
            return;
        }
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.nio.ByteBuffer")) {
            return;
        }
        if (type instanceof PsiArrayType && ((PsiArrayType)type).getComponentType().equals(PsiType.BYTE)) {
            return;
        }
        if (WebSocketCommonUtils.hasEncoderForType(type, encoders, method.getProject())) {
            return;
        }
        PsiTypeElement typeElement = method.getReturnTypeElement();
        if (typeElement != null) {
            holder.registerProblem((PsiElement)typeElement, WebSocketInspectionBundle.message("IncorrectOnMessageMethodsInspection.incorrect.on.message.return.type", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = WebSocketInspectionBundle.message("inspection.name.incorrect.on.message.methods.errors", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ee/websocket/highlighting/IncorrectOnMessageMethodsInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("IncorrectOnMessageMethodsInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ee/websocket/highlighting/IncorrectOnMessageMethodsInspection", "getShortName"));
        }
        return "IncorrectOnMessageMethodsInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ee/websocket/highlighting/IncorrectOnMessageMethodsInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

