/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ee.websocket.highlighting;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.compiler.util.InspectionValidatorWrapper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.websocket.resources.WebSocketInspectionBundle;
import com.intellij.websocket.utils.WebSocketCommonUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebSocketBaseInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = WebSocketInspectionBundle.message("model.inspection.group.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ee/websocket/highlighting/WebSocketBaseInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ee/websocket/highlighting/WebSocketBaseInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/ee/websocket/highlighting/WebSocketBaseInspection", "checkFile"));
        }
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)file)) {
            return null;
        }
        if (!WebSocketBaseInspection.isFileAccepted(file.getContainingFile())) {
            return null;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null || !WebSocketCommonUtils.isWebSocketInstalled(module)) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        this.checkJavaFile((PsiJavaFile)file, holder, isOnTheFly, module);
        List problemDescriptors = holder.getResults();
        return problemDescriptors.toArray(new ProblemDescriptor[problemDescriptors.size()]);
    }

    protected void checkJavaFile(@NotNull PsiJavaFile javaFile, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull Module module) {
        if (javaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaFile", "com/intellij/ee/websocket/highlighting/WebSocketBaseInspection", "checkJavaFile"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/ee/websocket/highlighting/WebSocketBaseInspection", "checkJavaFile"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ee/websocket/highlighting/WebSocketBaseInspection", "checkJavaFile"));
        }
        for (PsiClass psiClass : javaFile.getClasses()) {
            this.checkClassInternal(psiClass, holder, module);
        }
    }

    private void checkClassInternal(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ee/websocket/highlighting/WebSocketBaseInspection", "checkClassInternal"));
        }
        this.checkClass(aClass, holder, module);
        for (PsiClass psiClass : aClass.getInnerClasses()) {
            this.checkClass(psiClass, holder, module);
        }
    }

    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ee/websocket/highlighting/WebSocketBaseInspection", "checkClass"));
        }
    }

    protected static boolean isFileAccepted(PsiFile file) {
        if (!InspectionValidatorWrapper.isCompilationThread()) {
            return true;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        return module != null;
    }
}

