/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.facet;

import com.intellij.appengine.cloud.AppEngineAuthData;
import com.intellij.appengine.cloud.AppEngineCloudConfigurable;
import com.intellij.appengine.cloud.AppEngineServerConfiguration;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineAccountDialog {
    private static final String PASSWORD_KEY = "GOOGLE_APP_ENGINE_PASSWORD";

    @Nullable
    public static AppEngineAuthData createAuthData(@NotNull Project project, @NotNull AppEngineServerConfiguration configuration) {
        String password;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/appengine/facet/AppEngineAccountDialog", "createAuthData"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/appengine/facet/AppEngineAccountDialog", "createAuthData"));
        }
        if (configuration.isOAuth2()) {
            return AppEngineAuthData.oauth2();
        }
        String email = configuration.getEmail();
        if (!StringUtil.isEmpty((String)email) && configuration.isPasswordStored() && !StringUtil.isEmpty((String)(password = AppEngineAccountDialog.getStoredPassword(email)))) {
            return AppEngineAuthData.login(email, password);
        }
        AppEngineCloudConfigurable configurable = new AppEngineCloudConfigurable(configuration, project, false);
        boolean ok = ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable);
        if (!ok) {
            return null;
        }
        if (configurable.isOAuth2()) {
            return AppEngineAuthData.oauth2();
        }
        return AppEngineAuthData.login(configurable.getEmail(), configurable.getPassword());
    }

    public static void storePassword(@NotNull String email, @NotNull String password) {
        if (email == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "com/intellij/appengine/facet/AppEngineAccountDialog", "storePassword"));
        }
        if (password == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "password", "com/intellij/appengine/facet/AppEngineAccountDialog", "storePassword"));
        }
        PasswordSafe.getInstance().setPassword(AppEngineAccountDialog.class, AppEngineAccountDialog.getPasswordKey(email), password);
    }

    private static String getPasswordKey(String email) {
        return "GOOGLE_APP_ENGINE_PASSWORD_" + email;
    }

    @Nullable
    private static String getStoredPassword(String email) {
        if (StringUtil.isEmpty((String)email)) {
            return null;
        }
        return PasswordSafe.getInstance().getPassword(AppEngineAccountDialog.class, AppEngineAccountDialog.getPasswordKey(email));
    }
}

