/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiExpressionPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.pom.references.PomService;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.ELImplicitVariable;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.web.mvc.jam.RequestMapping;
import com.intellij.spring.web.mvc.jam.SpringMVCModelAttribute;
import com.intellij.spring.web.mvc.jsp.SpringModelELVariable;
import com.intellij.spring.web.mvc.views.SpringMVCViewReferenceProvider;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringControllerClassInfo {
    @NonNls
    private static final String MODEL = "org.springframework.ui.Model";
    @NonNls
    private static final String MODEL_MAP = "org.springframework.ui.ModelMap";
    @NonNls
    private static final String REDIRECT_ATTRIBUTES = "org.springframework.web.servlet.mvc.support.RedirectAttributes";
    private static final PsiJavaElementPattern.Capture<PsiElement> ATTRIBUTE_PATTERN = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement((Class[])new Class[]{PsiLiteral.class, PsiReferenceExpression.class}).with(SpringMvcLibraryUtil.IS_SPRING_MVC_PROJECT)).andOr(new ElementPattern[]{PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addObject")).inClass("org.springframework.web.servlet.ModelAndView")), PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addAttribute")).inClass("org.springframework.ui.Model")), PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"addAttribute", "addObject"}))).inClass("org.springframework.ui.ModelMap")), PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addFlashAttribute")).inClass("org.springframework.web.servlet.mvc.support.RedirectAttributes")), PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("put")).inClass("java.util.Map")), PsiJavaPatterns.psiExpression().annotationParam("org.springframework.web.bind.annotation.ModelAttribute", "value"), PsiJavaPatterns.psiExpression().annotationParam("org.springframework.web.bind.annotation.ModelAttribute", "name"), PsiJavaPatterns.psiExpression().constructorParameter(1, new String[]{"org.springframework.web.servlet.ModelAndView"}), PsiJavaPatterns.psiExpression().constructorParameter(0, new String[]{"org.springframework.ui.ModelMap"})});
    private static final PsiJavaElementPattern.Capture<PsiElement> IMPLICIT_ATTRIBUTE_PATTERN = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().andOr(new ElementPattern[]{PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addObject")).withParameterCount(1).inClass("org.springframework.web.servlet.ModelAndView")), PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addAttribute")).withParameterCount(1).inClass("org.springframework.ui.Model")), PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"addAttribute", "addObject"}))).withParameterCount(1).inClass("org.springframework.ui.ModelMap"))});
    private static final PsiExpressionPattern.Capture<PsiExpression> SESSION_ATTRIBUTES_PATTERN = (PsiExpressionPattern.Capture)PsiJavaPatterns.psiExpression().annotationParam("org.springframework.web.bind.annotation.SessionAttributes", "value");
    private final boolean myController;
    private final boolean myInheritedController;
    private final boolean myHasClassLevelResponseBody;
    private final PsiClass myClass;
    private static final UserDataCache<CachedValue<SpringControllerClassInfo>, PsiClass, Object> CACHE = new UserDataCache<CachedValue<SpringControllerClassInfo>, PsiClass, Object>("mvc controller info"){

        protected CachedValue<SpringControllerClassInfo> compute(PsiClass psiClass, Object p) {
            return CachedValuesManager.getManager((Project)psiClass.getProject()).createCachedValue(() -> CachedValueProvider.Result.createSingleDependency((Object)new SpringControllerClassInfo(psiClass), (Object)psiClass), false);
        }
    };

    public static SpringControllerClassInfo getInfo(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/web/mvc/SpringControllerClassInfo", "getInfo"));
        }
        return (SpringControllerClassInfo)((CachedValue)CACHE.get((UserDataHolder)psiClass, null)).getValue();
    }

    private SpringControllerClassInfo(PsiClass psiClass) {
        this.myClass = psiClass;
        this.myInheritedController = InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.web.servlet.mvc.Controller");
        SpringController controller = (SpringController)JamService.getJamService((Project)psiClass.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringController.META});
        this.myController = this.myInheritedController || controller != null;
        this.myHasClassLevelResponseBody = this.calcHasClassLevelResponseBody(controller);
    }

    public boolean isController() {
        return this.myController;
    }

    public boolean hasClassLevelResponseBody() {
        return this.myHasClassLevelResponseBody;
    }

    private boolean calcHasClassLevelResponseBody(@Nullable SpringController controller) {
        if (controller == null) {
            return false;
        }
        String definingAnnotation = controller.getDefiningAnnotation();
        assert (definingAnnotation != null) : this.myClass;
        if ("org.springframework.stereotype.Controller".equals(definingAnnotation)) {
            return false;
        }
        PsiClass metaControllerAnnoClass = JavaPsiFacade.getInstance((Project)this.myClass.getProject()).findClass(definingAnnotation, controller.getPsiElement().getResolveScope());
        return metaControllerAnnoClass != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)metaControllerAnnoClass, (String)"org.springframework.web.bind.annotation.ResponseBody", (boolean)false);
    }

    public boolean isRequestHandler(PsiMethod method) {
        if (!this.isController()) {
            return false;
        }
        if (!SpringControllerClassInfo.isRequestHandlerCandidate(method)) {
            return false;
        }
        if (this.myInheritedController) {
            return "handleRequest".equals(method.getName()) || "handleRequestInternal".equals(method.getName());
        }
        return SpringControllerClassInfo.hasRequestMappingJam(method);
    }

    public static boolean isRequestHandlerCandidate(PsiMethod method) {
        return (method.hasModifierProperty("public") || method.hasModifierProperty("protected")) && !method.hasModifierProperty("static") && !method.isConstructor();
    }

    public static boolean isJamRequestHandler(PsiMethod method) {
        return SpringControllerClassInfo.isRequestHandlerCandidate(method) && SpringControllerClassInfo.hasRequestMappingJam(method);
    }

    private static boolean hasRequestMappingJam(PsiMethod method) {
        return JamService.getJamService((Project)method.getProject()).getJamElement(RequestMapping.METHOD_JAM_KEY, (PsiElement)method) != null;
    }

    @Nullable
    private static String getLiteralName(PsiElement element) {
        Pair pair = StringExpressionHelper.evaluateExpression((PsiElement)element);
        return pair == null ? null : (String)pair.getSecond();
    }

    public MultiMap<String, PsiVariable> getVariables() {
        return (MultiMap)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> CachedValueProvider.Result.create(this.computeVariables(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private MultiMap<String, PsiVariable> computeVariables() {
        MultiMap result = new MultiMap();
        final HashSet<String> visitorViews = new HashSet<String>();
        SmartList visitorVariables = new SmartList();
        PsiRecursiveElementVisitor visitor = new PsiRecursiveElementVisitor((List)visitorVariables){
            private final Set<PsiMethod> visited = new HashSet<PsiMethod>();
            final /* synthetic */ List val$visitorVariables;
            {
                this.val$visitorVariables = list;
            }

            public void visitElement(PsiElement element) {
                PsiMethod method;
                if (element instanceof PsiLiteral || element instanceof PsiReferenceExpression) {
                    if (SpringMVCViewReferenceProvider.VIEW_PATTERN.accepts((Object)element)) {
                        String literalName = SpringControllerClassInfo.getLiteralName(element);
                        ContainerUtil.addIfNotNull((Collection)visitorViews, (Object)literalName);
                    } else if (ATTRIBUTE_PATTERN.accepts((Object)element)) {
                        ELImplicitVariable variable = SpringControllerClassInfo.createVariable((PsiElement)SpringControllerClassInfo.this.myClass.getContainingFile(), element);
                        ContainerUtil.addIfNotNull((Collection)this.val$visitorVariables, (Object)variable);
                    }
                }
                if (element instanceof PsiExpression && IMPLICIT_ATTRIBUTE_PATTERN.accepts((Object)element)) {
                    PsiType type = ((PsiExpression)element).getType();
                    String variableName = SpringControllerClassInfo.getVariableName(type);
                    if (variableName != null) {
                        SpringModelELVariable elVariable = new SpringModelELVariable((PsiElement)SpringControllerClassInfo.this.myClass.getContainingFile(), variableName, type, element, "NESTED");
                        this.val$visitorVariables.add(elVariable);
                    }
                } else if (element instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)element).resolveMethod()) != null && !(method instanceof PsiCompiledElement) && this.visited.add(method)) {
                    super.visitElement((PsiElement)method);
                }
                super.visitElement(element);
            }
        };
        for (PsiMethod method : this.myClass.getAllMethods()) {
            if (!this.isRequestHandler(method)) continue;
            SpringControllerClassInfo.visitMethod((MultiMap<String, PsiVariable>)result, visitorViews, (List<PsiVariable>)visitorVariables, visitor, method);
            visitorViews.clear();
            visitorVariables.clear();
        }
        if (!this.myInheritedController) {
            this.processGlobalModelAttributes((MultiMap<String, PsiVariable>)result, (List<PsiVariable>)visitorVariables, visitor);
        }
        return result;
    }

    @Nullable
    public static String getVariableName(@Nullable PsiType psiType) {
        if (psiType instanceof PsiClassType) {
            PsiClassType psiClassType = (PsiClassType)psiType;
            PsiClass psiClass = psiClassType.resolve();
            if (psiClass == null) {
                return null;
            }
            if (psiClassType.getParameterCount() == 1 && InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.List") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.Set")) {
                PsiType collectionElementType = psiClassType.getParameters()[0];
                return SpringControllerClassInfo.pluralize(SpringControllerClassInfo.getComponentName(collectionElementType));
            }
            return StringUtil.decapitalize((String)psiClass.getName());
        }
        if (psiType instanceof PsiArrayType) {
            PsiArrayType psiArrayType = (PsiArrayType)psiType;
            PsiType arrayElementType = psiArrayType.getComponentType();
            return SpringControllerClassInfo.pluralize(SpringControllerClassInfo.getComponentName(arrayElementType));
        }
        return null;
    }

    @Nullable
    private static String getComponentName(PsiType psiType) {
        if (!(psiType instanceof PsiClassType)) {
            return null;
        }
        PsiClass resolve = ((PsiClassType)psiType).resolve();
        return resolve != null ? StringUtil.decapitalize((String)resolve.getName()) : null;
    }

    @Nullable
    private static String pluralize(@Nullable String componentName) {
        return componentName == null ? null : componentName + "List";
    }

    private void processGlobalModelAttributes(MultiMap<String, PsiVariable> result, List<PsiVariable> visitorVariables, PsiRecursiveElementVisitor visitor) {
        for (PsiMethod method : this.myClass.getAllMethods()) {
            SpringMVCModelAttribute modelAttribute;
            if (!method.hasModifierProperty("public") || method.hasModifierProperty("static") || method.isConstructor() || (modelAttribute = (SpringMVCModelAttribute)SpringMVCModelAttribute.METHOD_META.getJamElement((PsiModifierListOwner)method)) == null) continue;
            if (PsiType.VOID.equals((Object)method.getReturnType())) {
                visitorVariables.clear();
                method.accept((PsiElementVisitor)visitor);
                for (Map.Entry entry : result.entrySet()) {
                    ((Collection)entry.getValue()).addAll(visitorVariables);
                }
                continue;
            }
            String name = modelAttribute.getName();
            if (name == null) continue;
            SpringModelELVariable var = new SpringModelELVariable((PsiElement)this.myClass, name, modelAttribute.getType(), PomService.convertToPsi((PsiTarget)modelAttribute.getPsiTarget()), "NESTED");
            for (Map.Entry entry : result.entrySet()) {
                ((Collection)entry.getValue()).add(var);
            }
        }
    }

    public MultiMap<String, PsiMethod> getViews(@Nullable PsiMethod method) {
        final MultiMap result = new MultiMap();
        PsiRecursiveElementVisitor visitor = new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof PsiLiteral || element instanceof PsiReferenceExpression) {
                    String name;
                    if (SpringMVCViewReferenceProvider.VIEW_PATTERN.accepts((Object)element) && (name = SpringControllerClassInfo.getLiteralName(element)) != null) {
                        result.putValue((Object)name, (Object)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class));
                    }
                } else {
                    super.visitElement(element);
                }
            }
        };
        if (method != null) {
            visitor.visitElement((PsiElement)method);
        } else {
            for (PsiMethod psiMethod : this.myClass.getAllMethods()) {
                visitor.visitElement((PsiElement)psiMethod);
            }
        }
        return result;
    }

    private static void visitMethod(MultiMap<String, PsiVariable> map, Set<String> views, List<PsiVariable> variables, PsiRecursiveElementVisitor visitor, PsiMethod method) {
        visitor.visitElement((PsiElement)method);
        for (String view : views) {
            map.putValues((Object)view, (Collection)new SmartList(variables));
        }
    }

    @Nullable
    private static ELImplicitVariable createVariable(PsiElement scope, PsiElement declaration) {
        PsiMethod psiMethod;
        PsiParameter psiParameter;
        String name = SpringControllerClassInfo.getLiteralName(declaration);
        if (name == null) {
            return null;
        }
        PsiExpression typeExpression = (PsiExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)declaration, PsiExpression.class);
        PsiType type = typeExpression != null ? typeExpression.getType() : ((psiParameter = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)declaration, PsiParameter.class)) != null ? psiParameter.getType() : ((psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)declaration, PsiMethod.class)) == null ? null : psiMethod.getReturnType()));
        return new SpringModelELVariable(scope, name, type, declaration, "NESTED");
    }

    public static void registerVariablesReferenceProvider(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(ATTRIBUTE_PATTERN, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                PsiReference[] psiReferenceArray;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/web/mvc/SpringControllerClassInfo$4", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/web/mvc/SpringControllerClassInfo$4", "getReferencesByElement"));
                }
                PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
                if (psiClass == null) {
                    psiReferenceArray = PsiReference.EMPTY_ARRAY;
                } else {
                    PsiReference[] psiReferenceArray2 = new PsiReference[1];
                    psiReferenceArray = psiReferenceArray2;
                    psiReferenceArray2[0] = PsiReferenceBase.createSelfReference((PsiElement)element, (PsiElement)SpringControllerClassInfo.createVariable((PsiElement)psiClass, element));
                }
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/SpringControllerClassInfo$4", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
        registrar.registerReferenceProvider(SESSION_ATTRIBUTES_PATTERN, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/web/mvc/SpringControllerClassInfo$5", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/web/mvc/SpringControllerClassInfo$5", "getReferencesByElement"));
                }
                PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
                if (psiClass == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/SpringControllerClassInfo$5", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String name = ElementManipulators.getValueText((PsiElement)element);
                SpringControllerClassInfo info = SpringControllerClassInfo.getInfo(psiClass);
                MultiMap<String, PsiVariable> variables = info.getVariables();
                for (PsiVariable variable : variables.values()) {
                    if (!name.equals(variable.getName())) continue;
                    PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase.Immediate<PsiLiteralExpression>((PsiLiteralExpression)element, (PsiElement)variable){

                        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                            ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myElement);
                            return manipulator.handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
                        }
                    }};
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/SpringControllerClassInfo$5", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/SpringControllerClassInfo$5", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        });
    }
}

