/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.spring.model.xml.mvc.CorsHeadersVariantsConverter;
import com.intellij.spring.model.xml.mvc.CorsMappingAllowedMethodsConverter;
import com.intellij.spring.web.config.webXml.SpringWebConfigLocationReferenceProvider;
import com.intellij.spring.web.mvc.SpringControllerClassInfo;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.web.mvc.pathVariables.MVCPathVariableReferenceProvider;
import com.intellij.spring.web.mvc.pathVariables.MVCRequestMappingReferenceProvider;
import com.intellij.spring.web.mvc.views.SpringMVCViewReferenceProvider;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringMVCReferenceContributor
extends PsiReferenceContributor {
    @NonNls
    private static final String CORS_REGISTRATION = "org.springframework.web.servlet.config.annotation.CorsRegistration";

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/web/mvc/SpringMVCReferenceContributor", "registerReferenceProviders"));
        }
        SpringWebConfigLocationReferenceProvider.register(registrar);
        SpringMVCViewReferenceProvider.register(registrar);
        SpringControllerClassInfo.registerVariablesReferenceProvider(registrar);
        MVCPathVariableReferenceProvider.register(registrar);
        MVCRequestMappingReferenceProvider.register(registrar);
        SpringMVCReferenceContributor.registerCors(registrar);
    }

    private static void registerCors(PsiReferenceRegistrar registrar) {
        SpringMVCReferenceContributor.registerCorsRegistrationHeaders(registrar, "allowedHeaders", true);
        SpringMVCReferenceContributor.registerCorsRegistrationHeaders(registrar, "exposedHeaders", false);
        registrar.registerReferenceProvider((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiLiteral.class).with(SpringMvcLibraryUtil.IS_SPRING_MVC_PROJECT)).and((ElementPattern)PsiJavaPatterns.psiExpression().methodCallParameter((ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("allowedMethods")).inClass(CORS_REGISTRATION))), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/web/mvc/SpringMVCReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/web/mvc/SpringMVCReferenceContributor$1", "getReferencesByElement"));
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase.Immediate<PsiElement>(element, element){

                    @NotNull
                    public Object[] getVariants() {
                        Object[] objectArray = CorsMappingAllowedMethodsConverter.getVariants();
                        if (objectArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/SpringMVCReferenceContributor$1$1", "getVariants"));
                        }
                        return objectArray;
                    }
                }};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/SpringMVCReferenceContributor$1", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }, 100.0);
    }

    private static void registerCorsRegistrationHeaders(PsiReferenceRegistrar registrar, String methodName, final boolean includeAll) {
        registrar.registerReferenceProvider((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiLiteral.class).with(SpringMvcLibraryUtil.IS_SPRING_MVC_PROJECT)).and((ElementPattern)PsiJavaPatterns.psiExpression().methodCallParameter((ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(methodName)).inClass(CORS_REGISTRATION))), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/web/mvc/SpringMVCReferenceContributor$2", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/web/mvc/SpringMVCReferenceContributor$2", "getReferencesByElement"));
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase.Immediate<PsiElement>(element, element){

                    @NotNull
                    public Object[] getVariants() {
                        Object[] objectArray = CorsHeadersVariantsConverter.getVariants(includeAll);
                        if (objectArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/SpringMVCReferenceContributor$2$1", "getVariants"));
                        }
                        return objectArray;
                    }
                }};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/SpringMVCReferenceContributor$2", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }, 100.0);
    }
}

