/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.pathVariables;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.spring.model.utils.PlaceholderTextRanges;
import com.intellij.spring.web.mvc.pathVariables.MVCPathVariableReference;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.intellij.lang.regexp.RegExpLanguage;
import org.jetbrains.annotations.NotNull;

public class MVCRequestMappingRegexInjector
implements MultiHostInjector {
    private final Project myProject;

    public MVCRequestMappingRegexInjector(Project project) {
        this.myProject = project;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/web/mvc/pathVariables/MVCRequestMappingRegexInjector", "getLanguagesToInject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/web/mvc/pathVariables/MVCRequestMappingRegexInjector", "getLanguagesToInject"));
        }
        if (this.myProject.isDefault() || !MVCPathVariableReference.PATTERN.accepts((Object)context)) {
            return;
        }
        PsiLiteralExpression psiLiteral = (PsiLiteralExpression)context;
        Object value = psiLiteral.getValue();
        if (!(value instanceof String)) {
            return;
        }
        String text = (String)value;
        if (!StringUtil.containsChar((String)text, (char)':')) {
            return;
        }
        String escapedText = StringUtil.escapeStringCharacters((String)text);
        Set ranges = PlaceholderTextRanges.getPlaceholderRanges((String)escapedText, (String)"{", (String)"}");
        if (ranges.isEmpty()) {
            return;
        }
        for (TextRange textRange : ranges) {
            String rangeSubString = textRange.substring(escapedText);
            int i = rangeSubString.indexOf(58);
            if (i == -1) continue;
            TextRange regexRange = TextRange.from((int)(textRange.getStartOffset() + i + 2), (int)(textRange.getLength() - i - 1));
            registrar.startInjecting((Language)RegExpLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)psiLiteral, regexRange).doneInjecting();
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<PsiLiteralExpression>> list = Collections.singletonList(PsiLiteralExpression.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/pathVariables/MVCRequestMappingRegexInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

