/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class SpringBootApplicationRunDashboardChecker
implements StartupActivity {
    private static final NotificationGroup DASHBOARD_NOTIFICATION_GROUP = new NotificationGroup("Run Dashboard", NotificationDisplayType.STICKY_BALLOON, false);
    private static final String SHOW_RUN_DASHBOARD_NOTIFICATION = "show.run.dashboard.notification";

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardChecker", "runActivity"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!Registry.is((String)"ide.run.dashboard")) {
            return;
        }
        if (!PropertiesComponent.getInstance((Project)project).getBoolean(SHOW_RUN_DASHBOARD_NOTIFICATION, true)) {
            return;
        }
        project.getMessageBus().connect((Disposable)project).subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardChecker$1", "runConfigurationAdded"));
                }
                if (!PropertiesComponent.getInstance((Project)project).getBoolean(SpringBootApplicationRunDashboardChecker.SHOW_RUN_DASHBOARD_NOTIFICATION, true)) {
                    return;
                }
                if (settings.getType().equals(SpringBootApplicationConfigurationTypeBase.getInstance())) {
                    DumbService.getInstance((Project)project).runWhenSmart(() -> {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardChecker$1", "lambda$runConfigurationAdded$0"));
                        }
                        SpringBootApplicationRunDashboardChecker.checkRunDashboardAvailability(project);
                    });
                }
            }
        });
        SpringBootApplicationRunDashboardChecker.checkRunDashboardAvailability(project);
    }

    private static void checkRunDashboardAvailability(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardChecker", "checkRunDashboardAvailability"));
        }
        ConfigurationFactory defaultFactory = SpringBootApplicationConfigurationTypeBase.getInstance().getDefaultConfigurationFactory();
        RunConfiguration templateConfiguration = defaultFactory.createTemplateConfiguration(project);
        if (((SpringBootApplicationRunConfiguration)templateConfiguration).isShowInDashboard()) {
            return;
        }
        List settings = RunManager.getInstance((Project)project).getConfigurationSettingsList((ConfigurationType)SpringBootApplicationConfigurationTypeBase.getInstance());
        if (settings.size() <= 1 || settings.stream().anyMatch(configurationSettings -> ((SpringBootApplicationRunConfiguration)configurationSettings.getConfiguration()).isShowInDashboard())) {
            return;
        }
        DASHBOARD_NOTIFICATION_GROUP.createNotification("Run Dashboard", "<html><body>Multiple Spring Boot run configurations were detected.<br>Run Dashboard allows to manage multiple run configurations at once.<br><br><a href=\"show\">Show run configurations in Run Dashboard</a><br><br><a href=\"ignore\">Do not show again for this project</a></body></html>", NotificationType.INFORMATION, (notification, event) -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardChecker", "lambda$checkRunDashboardAvailability$3"));
            }
            if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            String description = event.getDescription();
            if ("ignore".equals(description)) {
                PropertiesComponent.getInstance((Project)project).setValue(SHOW_RUN_DASHBOARD_NOTIFICATION, false, true);
                notification.expire();
            } else if ("show".equals(description)) {
                notification.hideBalloon();
                DumbService.getInstance((Project)project).runWhenSmart(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardChecker", "lambda$null$2"));
                    }
                    RunManagerImpl runManager = (RunManagerImpl)RunManager.getInstance((Project)project);
                    ((SpringBootApplicationRunConfiguration)runManager.getConfigurationTemplate(defaultFactory).getConfiguration()).setShowInDashboard(true);
                    settings.forEach(configurationSettings -> {
                        ((SpringBootApplicationRunConfiguration)configurationSettings.getConfiguration()).setShowInDashboard(true);
                        runManager.fireRunConfigurationChanged(configurationSettings);
                    });
                    SpringBootApplicationRunDashboardChecker.showToolWindow(project);
                });
            }
        }).notify(project);
    }

    private static void showToolWindow(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardChecker", "showToolWindow"));
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        toolWindowManager.invokeLater(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardChecker", "lambda$showToolWindow$4"));
            }
            if (project.isDisposed()) {
                return;
            }
            ToolWindow toolWindow = toolWindowManager.getToolWindow(RunDashboardManager.getInstance((Project)project).getToolWindowId());
            if (toolWindow != null && toolWindow.isAvailable()) {
                toolWindow.show(null);
            }
        });
    }
}

