/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.editor;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.ui.ClassBrowser;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.ide.util.ClassFilter;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.spring.boot.application.SpringBootApplicationUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.editor.SpringBootSettingsPanel;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationRunConfigurationEditor
extends SettingsEditor<SpringBootApplicationRunConfiguration>
implements PanelWithAnchor {
    private final Project myProject;
    private JPanel myWholePanel;
    private JComponent myAnchor;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myMainClass;
    private LabeledComponent<ModulesComboBox> myModule;
    private final ConfigurationModuleSelector myModuleSelector;
    private CommonJavaParametersPanel myCommonProgramParameters;
    private JrePathEditor myJrePathEditor;
    private SpringBootSettingsPanel mySpringBootSettings;

    public SpringBootApplicationRunConfigurationEditor(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myModuleSelector = new ConfigurationModuleSelector(project, (ModulesComboBox)this.myModule.getComponent()){

            public boolean isModuleAccepted(Module module) {
                return SpringBootLibraryUtil.hasSpringBootLibrary((Module)module);
            }
        };
        this.myJrePathEditor.setDefaultJreSelector(DefaultJreSelector.fromSourceRootsDependencies((ModulesComboBox)((ModulesComboBox)this.myModule.getComponent()), (EditorTextFieldWithBrowseButton)this.getMainClassField()));
        this.myCommonProgramParameters.setModuleContext(this.myModuleSelector.getModule());
        ((ModulesComboBox)this.myModule.getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Module module = SpringBootApplicationRunConfigurationEditor.this.myModuleSelector.getModule();
                SpringBootApplicationRunConfigurationEditor.this.myCommonProgramParameters.setModuleContext(module);
                SpringBootApplicationRunConfigurationEditor.this.mySpringBootSettings.setModule(module);
            }
        });
        new SpringBootClassBrowser(project, this.myModuleSelector).setField((ComponentWithBrowseButton)this.getMainClassField());
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myMainClass, this.myCommonProgramParameters, this.myJrePathEditor, this.myModule, this.mySpringBootSettings});
    }

    private void createUIComponents() {
        this.myMainClass = new LabeledComponent();
        this.myMainClass.setComponent((JComponent)new EditorTextFieldWithBrowseButton(this.myProject, true, new JavaCodeFragment.VisibilityChecker(){

            public JavaCodeFragment.VisibilityChecker.Visibility isDeclarationVisible(PsiElement declaration, PsiElement place) {
                PsiClass aClass;
                if (declaration instanceof PsiClass && SpringBootApplicationUtil.isSpringApplication((PsiClass)(aClass = (PsiClass)declaration))) {
                    return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
                }
                return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
            }
        }));
        this.mySpringBootSettings = new SpringBootSettingsPanel(this.myProject);
    }

    protected void resetEditorFrom(@NotNull SpringBootApplicationRunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/boot/run/editor/SpringBootApplicationRunConfigurationEditor", "resetEditorFrom"));
        }
        this.myCommonProgramParameters.reset((CommonJavaRunConfigurationParameters)configuration);
        this.myModuleSelector.reset((ModuleBasedConfiguration)configuration);
        this.getMainClassField().setText(configuration.getSpringBootMainClass() != null ? configuration.getSpringBootMainClass().replace('$', '.') : "");
        this.mySpringBootSettings.setEnableDebugOutput(configuration.isDebugMode());
        this.mySpringBootSettings.setEnableLaunchOptimization(configuration.isEnableLaunchOptimization());
        this.mySpringBootSettings.setHideBanner(configuration.isHideBanner());
        this.mySpringBootSettings.setEnableJmxAgent(configuration.isEnableJmxAgent());
        this.mySpringBootSettings.setShowInDashboard(configuration.isShowInDashboard());
        this.mySpringBootSettings.setActiveProfiles(configuration.getActiveProfiles());
        this.mySpringBootSettings.setAdditionalParameters(configuration.getAdditionalParameters());
        this.myJrePathEditor.setPathOrName(configuration.getAlternativeJrePath(), configuration.isAlternativeJrePathEnabled());
    }

    protected void applyEditorTo(@NotNull SpringBootApplicationRunConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/boot/run/editor/SpringBootApplicationRunConfigurationEditor", "applyEditorTo"));
        }
        this.myCommonProgramParameters.applyTo((CommonJavaRunConfigurationParameters)configuration);
        this.myModuleSelector.applyTo((ModuleBasedConfiguration)configuration);
        String className = this.getMainClassField().getText();
        PsiClass aClass = this.myModuleSelector.findClass(className);
        configuration.setSpringBootMainClass(aClass != null ? JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass) : className);
        configuration.setDebugMode(this.mySpringBootSettings.isEnableDebugOutput());
        configuration.setEnableLaunchOptimization(this.mySpringBootSettings.isEnableLaunchOptimization());
        configuration.setHideBanner(this.mySpringBootSettings.isHideBanner());
        configuration.setEnableJmxAgent(this.mySpringBootSettings.isEnableJmxAgent());
        configuration.setShowInDashboard(this.mySpringBootSettings.isShowInDashboard());
        configuration.setActiveProfiles(this.mySpringBootSettings.getActiveProfiles());
        configuration.setAdditionalParameters(this.mySpringBootSettings.getAdditionalParameters());
        configuration.setAlternativeJrePath(this.myJrePathEditor.getJrePathOrName());
        configuration.setAlternativeJrePathEnabled(this.myJrePathEditor.isAlternativeJreSelected());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/editor/SpringBootApplicationRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myMainClass.setAnchor(anchor);
        this.myModule.setAnchor(anchor);
        this.myCommonProgramParameters.setAnchor(anchor);
        this.myJrePathEditor.setAnchor(anchor);
        this.mySpringBootSettings.setAnchor(anchor);
    }

    private EditorTextFieldWithBrowseButton getMainClassField() {
        return (EditorTextFieldWithBrowseButton)this.myMainClass.getComponent();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LabeledComponent labeledComponent;
        JrePathEditor jrePathEditor;
        CommonJavaParametersPanel commonJavaParametersPanel;
        JPanel jPanel;
        this.createUIComponents();
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCommonProgramParameters = commonJavaParametersPanel = new CommonJavaParametersPanel();
        jPanel.add((Component)commonJavaParametersPanel, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myJrePathEditor = jrePathEditor = new JrePathEditor();
        jPanel.add((Component)jrePathEditor, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent<EditorTextFieldWithBrowseButton> labeledComponent2 = this.myMainClass;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText("Main class");
        jPanel.add((Component)labeledComponent2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myModule = labeledComponent = new LabeledComponent();
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("application.configuration.use.classpath.and.jdk.of.module.label"));
        labeledComponent.setComponentClass("com.intellij.application.options.ModulesComboBox");
        jPanel.add((Component)labeledComponent, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        SpringBootSettingsPanel springBootSettingsPanel = this.mySpringBootSettings;
        JComponent jComponent = springBootSettingsPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(6, 0, 1, 1, 1, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private static class SpringBootClassBrowser
    extends ClassBrowser.MainClassBrowser {
        public SpringBootClassBrowser(Project project, ConfigurationModuleSelector moduleSelector) {
            super(project, moduleSelector, SpringBootRunBundle.message("spring.boot.choose.class.dialog.title", new Object[0]));
        }

        protected ClassFilter createFilter(Module module) {
            return new ClassFilter(){

                public boolean isAccepted(PsiClass aClass) {
                    return SpringBootApplicationUtil.isSpringApplication((PsiClass)aClass) && this.findMainMethod(aClass) != null;
                }

                @Nullable
                private PsiMethod findMainMethod(PsiClass aClass) {
                    return (PsiMethod)ReadAction.compute(() -> PsiMethodUtil.findMainMethod((PsiClass)SpringBootApplicationRunConfiguration.guessUastMainClass(aClass)));
                }
            };
        }
    }
}

