/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.openapi.Disposable;
import com.intellij.spring.boot.run.lifecycle.AsyncLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LifecycleErrorHandler;
import com.intellij.spring.boot.run.lifecycle.LifecycleException;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationConnector;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationServerConfiguration;
import org.jetbrains.annotations.Nullable;

class ServerConfigurationLiveProperty
extends AsyncLiveProperty<SpringBootApplicationServerConfiguration> {
    ServerConfigurationLiveProperty(int jmxPort, LifecycleErrorHandler errorHandler, Disposable parent) {
        super(jmxPort, errorHandler, parent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected SpringBootApplicationServerConfiguration doCompute() throws LifecycleException {
        try (SpringBootApplicationConnector connector = new SpringBootApplicationConnector(this.getJmxPort());){
            boolean sslEnabled = false;
            Object keyStore = connector.getProperty("server.ssl.key-store");
            if (keyStore != null) {
                sslEnabled = connector.getBooleanProperty("server.ssl.enabled", true);
            }
            Object contextPath = connector.getProperty("server.context-path");
            Object servletPath = connector.getProperty("server.servlet-path");
            Object address = connector.getProperty("server.address");
            MyApplicationServerConfiguration myApplicationServerConfiguration = new MyApplicationServerConfiguration(sslEnabled, contextPath == null ? null : contextPath.toString(), servletPath == null ? null : servletPath.toString(), address == null ? null : address.toString());
            return myApplicationServerConfiguration;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static class MyApplicationServerConfiguration
    implements SpringBootApplicationServerConfiguration {
        private final boolean mySslEnabled;
        private final String myContextPath;
        private final String myServletPath;
        private final String myAddress;

        MyApplicationServerConfiguration(boolean sslEnabled, String contextPath, String servletPath, String address) {
            this.mySslEnabled = sslEnabled;
            this.myContextPath = contextPath;
            this.myServletPath = servletPath;
            this.myAddress = address;
        }

        public boolean isSslEnabled() {
            return this.mySslEnabled;
        }

        @Nullable
        public String getContextPath() {
            return this.myContextPath;
        }

        @Nullable
        public String getServletPath() {
            return this.myServletPath;
        }

        @Nullable
        public String getAddress() {
            return this.myAddress;
        }
    }
}

