/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfoImpl;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationLifecycleManagerImpl
implements SpringBootApplicationLifecycleManager,
Disposable {
    private final Project myProject;
    private final Map<ProcessHandler, SpringBootApplicationInfo> myInfos = new ConcurrentHashMap<ProcessHandler, SpringBootApplicationInfo>();
    private final List<SpringBootApplicationLifecycleManager.InfoListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public SpringBootApplicationLifecycleManagerImpl(Project project) {
        this.myProject = project;
        this.init();
        Disposer.register((Disposable)project, (Disposable)this);
    }

    private void init() {
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                if (executorId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl$1", "processStarted"));
                }
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl$1", "processStarted"));
                }
                if (handler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl$1", "processStarted"));
                }
                RunnerAndConfigurationSettings configurationSettings = env.getRunnerAndConfigurationSettings();
                if (configurationSettings == null) {
                    return;
                }
                if (configurationSettings.getConfiguration() instanceof SpringBootApplicationRunConfiguration) {
                    Integer jmxPort = (Integer)handler.getUserData(SpringBootApplicationLifecycleManager.JMX_PORT);
                    if (jmxPort == null || jmxPort <= 0) {
                        return;
                    }
                    SpringBootApplicationInfo info = SpringBootApplicationInfoImpl.createInfo(SpringBootApplicationLifecycleManagerImpl.this.myProject, env, (SpringBootApplicationRunConfiguration)configurationSettings.getConfiguration(), jmxPort);
                    Disposer.register((Disposable)SpringBootApplicationLifecycleManagerImpl.this, (Disposable)info);
                    SpringBootApplicationLifecycleManagerImpl.this.myInfos.put(handler, info);
                    SpringBootApplicationLifecycleManagerImpl.this.myListeners.forEach(listener -> {
                        if (handler == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl$1", "lambda$processStarted$0"));
                        }
                        listener.infoAdded(handler, info);
                    });
                }
            }

            public void processTerminating(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                if (executorId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl$1", "processTerminating"));
                }
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl$1", "processTerminating"));
                }
                if (handler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl$1", "processTerminating"));
                }
                SpringBootApplicationInfo info = (SpringBootApplicationInfo)SpringBootApplicationLifecycleManagerImpl.this.myInfos.remove(handler);
                if (info != null) {
                    Disposer.dispose((Disposable)info);
                    SpringBootApplicationLifecycleManagerImpl.this.myListeners.forEach(listener -> {
                        if (handler == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl$1", "lambda$processTerminating$1"));
                        }
                        listener.infoRemoved(handler, info);
                    });
                }
            }
        });
    }

    public void dispose() {
        this.myInfos.forEach((handler, info) -> this.myListeners.forEach(listener -> listener.infoRemoved(handler, info)));
        this.myInfos.clear();
    }

    public boolean isLifecycleManagementEnabled(@NotNull ProcessHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl", "isLifecycleManagementEnabled"));
        }
        Integer jmxPort = (Integer)handler.getUserData(JMX_PORT);
        return jmxPort != null && jmxPort > 0;
    }

    @Nullable
    public SpringBootApplicationInfo getSpringBootApplicationInfo(ProcessHandler handler) {
        return this.myInfos.get(handler);
    }

    public void addInfoListener(@NotNull SpringBootApplicationLifecycleManager.InfoListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl", "addInfoListener"));
        }
        this.myListeners.add(listener);
    }

    public void removeInfoListener(@NotNull SpringBootApplicationLifecycleManager.InfoListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl", "removeInfoListener"));
        }
        this.myListeners.remove(listener);
    }
}

