/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.LiveResource;
import com.intellij.spring.boot.run.lifecycle.beans.LiveResourceImpl;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.xml.util.PsiElementPointer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveBeanImpl
implements LiveBean {
    private static final String BEAN_RESOURCE_PREFIX = "/WEB-INF/classes/";
    private static final String CONFIGURATION_PROPERTIES_BEAN = "CONFIGURATION_PROPERTIES";
    @NotNull
    private final String myId;
    @Nullable
    private final String myScope;
    @Nullable
    private final String myType;
    @Nullable
    private final LiveResource myResource;
    private final Set<LiveBean> myDependencies;
    private final Set<LiveBean> myInjectedInto;
    private final boolean myInnerBean;
    private volatile String myName;
    private volatile String myClassName;

    static LiveBeanImpl createLiveBean(@NotNull String id, @Nullable String scope, @Nullable String type, @NotNull LiveResource resource) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/spring/boot/run/lifecycle/beans/LiveBeanImpl", "createLiveBean"));
        }
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "com/intellij/spring/boot/run/lifecycle/beans/LiveBeanImpl", "createLiveBean"));
        }
        return new LiveBeanImpl(id, scope, type, resource, false);
    }

    static LiveBeanImpl createInnerBean(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/spring/boot/run/lifecycle/beans/LiveBeanImpl", "createInnerBean"));
        }
        return new LiveBeanImpl(id, null, null, null, true);
    }

    private LiveBeanImpl(@NotNull String id, @Nullable String scope, @Nullable String type, @Nullable LiveResource resource, boolean innerBean) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/spring/boot/run/lifecycle/beans/LiveBeanImpl", "<init>"));
        }
        this.myDependencies = new HashSet<LiveBean>();
        this.myInjectedInto = new HashSet<LiveBean>();
        this.myId = id;
        this.myScope = scope;
        this.myType = type;
        this.myResource = resource;
        this.myInnerBean = innerBean;
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/LiveBeanImpl", "getId"));
        }
        return string;
    }

    @Nullable
    public String getScope() {
        return this.myScope;
    }

    @Nullable
    public String getType() {
        return this.myType;
    }

    @Nullable
    public LiveResource getResource() {
        return this.myResource;
    }

    @NotNull
    public Set<LiveBean> getDependencies() {
        Set<LiveBean> set = Collections.unmodifiableSet(this.myDependencies);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/LiveBeanImpl", "getDependencies"));
        }
        return set;
    }

    @NotNull
    public Set<LiveBean> getInjectedInto() {
        Set<LiveBean> set = Collections.unmodifiableSet(this.myInjectedInto);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/LiveBeanImpl", "getInjectedInto"));
        }
        return set;
    }

    public boolean isInnerBean() {
        return this.myInnerBean;
    }

    @NotNull
    public String getName() {
        String name = this.myName;
        if (name != null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/LiveBeanImpl", "getName"));
            }
            return string;
        }
        if (this.myId.endsWith(CONFIGURATION_PROPERTIES_BEAN)) {
            String string = this.myName = this.myId;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/LiveBeanImpl", "getName"));
            }
            return string;
        }
        int index = StringUtil.lastIndexOfAny((CharSequence)this.myId, (String)".$");
        name = this.myId;
        if (index >= 0 && index < this.myId.length() - 1) {
            name = this.myId.substring(index + 1);
        }
        if ((index = name.indexOf(64)) > 0) {
            name = name.substring(0, index);
        }
        String string = this.myName = StringUtil.decapitalize((String)name);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/LiveBeanImpl", "getName"));
        }
        return string;
    }

    @Nullable
    public String getClassName() {
        String className = this.myClassName;
        if (className != null) {
            return className;
        }
        className = this.myType;
        if (className != null && className.trim().length() > 0) {
            String resourcePath;
            if (className.startsWith("com.sun.proxy") && this.myResource != null && this.myResource.hasDescription() && LiveResourceImpl.isClassResource(resourcePath = this.myResource.getResourcePath())) {
                className = LiveBeanImpl.extractClassName(resourcePath);
            }
        } else {
            className = this.myId;
        }
        this.myClassName = LiveBeanImpl.cleanClassName(className);
        return this.myClassName;
    }

    @Nullable
    public PsiClass getBeanClass(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/beans/LiveBeanImpl", "getBeanClass"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/boot/run/lifecycle/beans/LiveBeanImpl", "getBeanClass"));
        }
        String className = this.getClassName();
        if (className == null) {
            return null;
        }
        return LiveResourceImpl.findClass(className, project, searchScope);
    }

    @NotNull
    public PsiElementPointer getBeanPointer(@Nullable PsiClass beanClass, @Nullable PsiElement resourceElement, @Nullable CommonSpringModel springModel) {
        final PsiFile beanFile = resourceElement == null ? null : resourceElement.getContainingFile();
        final PsiClass beanContainingClass = LiveBeanImpl.getBeanContainingClass(resourceElement);
        Object pointer = null;
        if (springModel != null) {
            CommonProcessors.FindProcessor<SpringBeanPointer> findProcessor = new CommonProcessors.FindProcessor<SpringBeanPointer>(){

                protected boolean accept(SpringBeanPointer pointer) {
                    if (beanFile == null) {
                        return true;
                    }
                    boolean accept = beanFile.getManager().areElementsEquivalent((PsiElement)beanFile, (PsiElement)pointer.getContainingFile());
                    if (!accept) {
                        accept = InheritanceUtil.isInheritorOrSelf((PsiClass)beanContainingClass, (PsiClass)LiveBeanImpl.getBeanContainingClass(pointer.getPsiElement()), (boolean)true);
                    }
                    return accept;
                }
            };
            springModel.processByName(SpringModelSearchParameters.byName((String)this.getName()), (Processor)findProcessor);
            pointer = (PsiElementPointer)findProcessor.getFoundValue();
        }
        if (pointer == null) {
            pointer = this.myResource == null || !this.myResource.hasDescription() ? () -> beanClass : LiveBeanImpl.getLiveResourcePointer((PsiElement)(beanContainingClass != null ? beanContainingClass : beanFile));
        }
        PsiElementPointer psiElementPointer = pointer;
        if (psiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/LiveBeanImpl", "getBeanPointer"));
        }
        return psiElementPointer;
    }

    public void addDependency(@NotNull LiveBeanImpl dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/intellij/spring/boot/run/lifecycle/beans/LiveBeanImpl", "addDependency"));
        }
        this.myDependencies.add(dependency);
        dependency.myInjectedInto.add(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LiveBeanImpl) {
            LiveBeanImpl liveBean = (LiveBeanImpl)obj;
            return this.myId.equals(liveBean.myId) && Comparing.equal((Object)this.myResource, (Object)liveBean.myResource);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.myId.hashCode();
        result = 31 * result + (this.myResource != null ? this.myResource.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.myId;
    }

    private static String cleanClassName(@Nullable String className) {
        if (className != null) {
            int index = className.indexOf("$$");
            if (index > 0) {
                className = className.substring(0, index);
            }
            if ((index = className.indexOf(35)) > 0) {
                className = className.substring(0, index);
            }
            if ((index = className.indexOf(64)) > 0) {
                className = className.substring(0, index);
            }
        }
        return className;
    }

    private static String extractClassName(@NotNull String resourcePath) {
        if (resourcePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourcePath", "com/intellij/spring/boot/run/lifecycle/beans/LiveBeanImpl", "extractClassName"));
        }
        int index = resourcePath.lastIndexOf(BEAN_RESOURCE_PREFIX);
        if (index >= 0) {
            resourcePath = resourcePath.substring(index + BEAN_RESOURCE_PREFIX.length());
        }
        resourcePath = StringUtil.trimEnd((String)resourcePath, (String)".class", (boolean)true);
        resourcePath = resourcePath.replaceAll("[\\\\/]", ".");
        return resourcePath;
    }

    @Nullable
    private static PsiClass getBeanContainingClass(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof PsiClass) {
            return (PsiClass)element;
        }
        if (element instanceof PsiClassOwner) {
            PsiClass[] classes = ((PsiClassOwner)element).getClasses();
            return classes.length > 0 ? classes[0] : null;
        }
        return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
    }

    @NotNull
    private static LiveBean.LiveResourcePointer getLiveResourcePointer(final @Nullable PsiElement element) {
        LiveBean.LiveResourcePointer liveResourcePointer = new LiveBean.LiveResourcePointer(){

            @Nullable
            public PsiElement getPsiElement() {
                return element;
            }
        };
        if (liveResourcePointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/LiveBeanImpl", "getLiveResourcePointer"));
        }
        return liveResourcePointer;
    }
}

