/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.diagram;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiManager;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.diagram.LiveBeanWrapper;
import com.intellij.spring.boot.run.lifecycle.tabs.LiveBeansPanel;
import com.intellij.spring.perspectives.diagrams.SpringDependencyType;
import com.intellij.spring.perspectives.diagrams.SpringDiagramEdge;
import com.intellij.spring.perspectives.diagrams.SpringDiagramNode;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveBeanDiagramDataModel
extends DiagramDataModel<SpringElementWrapper> {
    private final LiveBean myLiveBean;
    private final LiveBeansPanel.LiveBeanContext myBeanContext;
    private final Collection<DiagramNode<SpringElementWrapper>> myNodes = ContainerUtil.newLinkedHashSet();
    private final Collection<DiagramEdge<SpringElementWrapper>> myEdges = ContainerUtil.newLinkedHashSet();
    private final Collection<SpringElementWrapper> myRemovedNodes = ContainerUtil.newLinkedHashSet();

    LiveBeanDiagramDataModel(DiagramProvider<SpringElementWrapper> springBaseBeanPointerDiagramProvider, LiveBean liveBean, LiveBeansPanel.LiveBeanContext beanContext) {
        super(beanContext.project, springBaseBeanPointerDiagramProvider);
        this.myLiveBean = liveBean;
        this.myBeanContext = beanContext;
    }

    @NotNull
    public Collection<DiagramNode<SpringElementWrapper>> getNodes() {
        Collection<DiagramNode<SpringElementWrapper>> collection = this.myNodes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/diagram/LiveBeanDiagramDataModel", "getNodes"));
        }
        return collection;
    }

    @NotNull
    public Collection<DiagramEdge<SpringElementWrapper>> getEdges() {
        Collection<DiagramEdge<SpringElementWrapper>> collection = this.myEdges;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/diagram/LiveBeanDiagramDataModel", "getEdges"));
        }
        return collection;
    }

    @NotNull
    public String getNodeName(DiagramNode<SpringElementWrapper> n) {
        String string = ((SpringElementWrapper)n.getIdentifyingElement()).getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/diagram/LiveBeanDiagramDataModel", "getNodeName"));
        }
        return string;
    }

    @Nullable
    public DiagramNode<SpringElementWrapper> getOrCreateElement(LiveBean liveBean) {
        DiagramNode<SpringElementWrapper> target = this.getNode(liveBean);
        if (target == null) {
            target = this.addNode(liveBean);
        }
        return target;
    }

    @Nullable
    private DiagramNode<SpringElementWrapper> addNode(LiveBean liveBean) {
        return liveBean == null ? null : this.addNode(new LiveBeanWrapper(liveBean, this.myBeanContext));
    }

    @Nullable
    private DiagramNode<SpringElementWrapper> addNode(SpringElementWrapper wrapper) {
        if (this.myRemovedNodes.contains(wrapper)) {
            return null;
        }
        SpringDiagramNode node = new SpringDiagramNode(wrapper, this.getProvider());
        if (!this.myNodes.contains(node)) {
            this.myNodes.add((DiagramNode<SpringElementWrapper>)node);
        }
        return node;
    }

    public DiagramNode<SpringElementWrapper> addElement(SpringElementWrapper wrapper) {
        return this.addNode(wrapper);
    }

    public void refreshDataModel() {
        if (DumbService.isDumb((Project)this.getProject())) {
            return;
        }
        this.clearAll();
        this.updateDataModel();
    }

    private void updateDataModel() {
        DiagramNode<SpringElementWrapper> node = this.getOrCreateElement(this.myLiveBean);
        for (LiveBean dependency : this.myLiveBean.getDependencies()) {
            DiagramNode<SpringElementWrapper> targetNode = this.getOrCreateElement(dependency);
            this.addEdge(node, targetNode, SpringDependencyType.UNKNOWN);
        }
        for (LiveBean injectedInto : this.myLiveBean.getInjectedInto()) {
            DiagramNode<SpringElementWrapper> sourceNode = this.getOrCreateElement(injectedInto);
            this.addEdge(sourceNode, node, SpringDependencyType.UNKNOWN);
        }
    }

    private void addEdge(@Nullable DiagramNode<SpringElementWrapper> source, @Nullable DiagramNode<SpringElementWrapper> target, @NotNull SpringDependencyType info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/spring/boot/run/lifecycle/beans/diagram/LiveBeanDiagramDataModel", "addEdge"));
        }
        if (source != null && target != null) {
            this.addEdge(new SpringDiagramEdge(source, target, info));
        }
    }

    private void addEdge(SpringDiagramEdge edge) {
        if (!this.myEdges.contains(edge)) {
            this.myEdges.add((DiagramEdge<SpringElementWrapper>)edge);
        }
    }

    public long getModificationCount() {
        return super.getModificationCount() + PsiManager.getInstance((Project)this.getProject()).getModificationTracker().getJavaStructureModificationCount();
    }

    @Nullable
    private DiagramNode<SpringElementWrapper> getNode(@NotNull LiveBean bean) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/boot/run/lifecycle/beans/diagram/LiveBeanDiagramDataModel", "getNode"));
        }
        for (DiagramNode<SpringElementWrapper> node : this.myNodes) {
            if (!bean.equals(((SpringElementWrapper)node.getIdentifyingElement()).getWrapped())) continue;
            return node;
        }
        return null;
    }

    private void clearAll() {
        this.myEdges.clear();
        this.myNodes.clear();
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        LiveBeanDiagramDataModel liveBeanDiagramDataModel = this;
        if (liveBeanDiagramDataModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/diagram/LiveBeanDiagramDataModel", "getModificationTracker"));
        }
        return liveBeanDiagramDataModel;
    }

    public void dispose() {
    }

    public void removeNode(DiagramNode<SpringElementWrapper> node) {
        this.myRemovedNodes.add((SpringElementWrapper)node.getIdentifyingElement());
    }
}

