/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBeansModel;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class LifecycleFinderRecursivePanel<T>
extends FinderRecursivePanel<T> {
    @NotNull
    private final SpringBootApplicationRunConfiguration myRunConfiguration;
    @NotNull
    private final ProcessHandler myProcessHandler;
    private JBList<T> myList;

    protected LifecycleFinderRecursivePanel(@NotNull Project project, @Nullable FinderRecursivePanel parent, @Nullable String groupId, @NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull ProcessHandler processHandler) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/tabs/LifecycleFinderRecursivePanel", "<init>"));
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/spring/boot/run/lifecycle/tabs/LifecycleFinderRecursivePanel", "<init>"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/spring/boot/run/lifecycle/tabs/LifecycleFinderRecursivePanel", "<init>"));
        }
        super(project, parent, groupId);
        this.myRunConfiguration = runConfiguration;
        this.myProcessHandler = processHandler;
    }

    @NotNull
    protected final SpringBootApplicationRunConfiguration getRunConfiguration() {
        SpringBootApplicationRunConfiguration springBootApplicationRunConfiguration = this.myRunConfiguration;
        if (springBootApplicationRunConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/LifecycleFinderRecursivePanel", "getRunConfiguration"));
        }
        return springBootApplicationRunConfiguration;
    }

    @NotNull
    protected final ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/LifecycleFinderRecursivePanel", "getProcessHandler"));
        }
        return processHandler;
    }

    protected boolean performEditAction() {
        String message;
        Object selectedValue = this.getSelectedValue();
        this.updateItem(selectedValue);
        Navigatable data = (Navigatable)CommonDataKeys.NAVIGATABLE.getData((DataProvider)this);
        if (data != null && data.canNavigate()) {
            data.navigate(true);
        } else if (selectedValue != null && StringUtil.isNotEmpty((String)(message = this.getEditActionHintMessage(selectedValue)))) {
            this.showHint(message);
        }
        return false;
    }

    protected JBList<T> createList() {
        this.myList = super.createList();
        return this.myList;
    }

    @Nullable
    protected final LiveBeansModel getModel() {
        SpringBootApplicationInfo info = SpringBootApplicationLifecycleManager.getInstance((Project)this.getProject()).getSpringBootApplicationInfo(this.getProcessHandler());
        return info != null ? (LiveBeansModel)info.getLiveBeansModel().getValue() : null;
    }

    protected final void updateItem(@Nullable T t) {
        if (DumbService.isDumb((Project)this.getProject()) || t == null) {
            return;
        }
        boolean changed = this.doUpdateItem(t);
        if (changed) {
            this.updateRightComponent(!this.hasChildren(t));
        }
    }

    protected boolean doUpdateItem(@NotNull T t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/spring/boot/run/lifecycle/tabs/LifecycleFinderRecursivePanel", "doUpdateItem"));
        }
        return false;
    }

    protected void showHint(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/spring/boot/run/lifecycle/tabs/LifecycleFinderRecursivePanel", "showHint"));
        }
        if (this.myList == null) {
            return;
        }
        JComponent messageComponent = HintUtil.createInformationLabel((String)message);
        BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder(messageComponent);
        Balloon balloon = builder.setRequestFocus(false).setFadeoutTime(3000L).setFillColor(HintUtil.getInformationColor()).createBalloon();
        int selectedIndex = this.myList.getSelectedIndex();
        Rectangle cellBounds = this.myList.getCellBounds(selectedIndex, selectedIndex);
        if (cellBounds == null) {
            balloon.showInCenterOf(this.myList);
        } else {
            Point point = new Point(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2);
            balloon.show(new RelativePoint(this.myList, point), Balloon.Position.below);
        }
    }

    protected String getEditActionHintMessage(@NotNull T t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/spring/boot/run/lifecycle/tabs/LifecycleFinderRecursivePanel", "getEditActionHintMessage"));
        }
        return null;
    }

    public final void updateComponent() {
        if (!this.isDisposed()) {
            this.updatePanel();
        }
    }
}

