/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.Argument;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.DefaultValues;
import org.jetbrains.kotlin.cli.common.arguments.GradleOption;
import org.jetbrains.kotlin.config.AnalysisFlag;

public abstract class CommonCompilerArguments
extends CommonToolArguments {
    public static final long serialVersionUID = 0L;
    public static final String PLUGIN_OPTION_FORMAT = "plugin:<pluginId>:<optionName>=<value>";
    @GradleOption(value=DefaultValues.LanguageVersions.class)
    @Argument(value="-language-version", valueDescription="<version>", description="Provide source compatibility with specified language version")
    public String languageVersion;
    @GradleOption(value=DefaultValues.LanguageVersions.class)
    @Argument(value="-api-version", valueDescription="<version>", description="Allow to use declarations only from the specified version of bundled libraries")
    public String apiVersion;
    @Argument(value="-P", valueDescription="plugin:<pluginId>:<optionName>=<value>", description="Pass an option to a plugin")
    public String[] pluginOptions;
    @Argument(value="-Xno-inline", description="Disable method inlining")
    public boolean noInline;
    @Argument(value="-Xrepeat", valueDescription="<count>", description="Repeat compilation (for performance analysis)")
    public String repeat;
    @Argument(value="-Xskip-metadata-version-check", description="Load classes with bad metadata version anyway (incl. pre-release classes)")
    public boolean skipMetadataVersionCheck;
    @Argument(value="-Xallow-kotlin-package", description="Allow compiling code in package 'kotlin'")
    public boolean allowKotlinPackage;
    @Argument(value="-Xreport-output-files", description="Report source to output files mapping")
    public boolean reportOutputFiles;
    @Argument(value="-Xplugin", valueDescription="<path>", description="Load plugins from the given classpath")
    public String[] pluginClasspaths;
    @Argument(value="-Xmulti-platform", description="Enable experimental language support for multi-platform projects")
    public boolean multiPlatform;
    @Argument(value="-Xno-check-impl", description="Do not check presence of 'impl' modifier in multi-platform projects")
    public boolean noCheckImpl;
    @Argument(value="-Xintellij-plugin-root", valueDescription="<path>", description="Path to the kotlin-compiler.jar or directory where IntelliJ configuration files can be found")
    public String intellijPluginRoot;
    @Argument(value="-Xcoroutines", valueDescription="{enable|warn|error}", description="Enable coroutines or report warnings or errors on declarations and use sites of 'suspend' modifier")
    public String coroutinesState = "warn";
    public static final String WARN = "warn";
    public static final String ERROR = "error";
    public static final String ENABLE = "enable";

    @NotNull
    public Map<AnalysisFlag<?>, Object> configureAnalysisFlags() {
        HashMap result = new HashMap();
        result.put(AnalysisFlag.getSkipMetadataVersionCheck(), this.skipMetadataVersionCheck);
        result.put(AnalysisFlag.getMultiPlatformDoNotCheckImpl(), this.noCheckImpl);
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments", "configureAnalysisFlags"));
        }
        return hashMap;
    }

    public static final class DummyImpl
    extends CommonCompilerArguments {
    }
}

